/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.executor;

import org.jboss.weld.config.ConfigurationKey;
import org.jboss.weld.config.WeldConfiguration;
import org.jboss.weld.executor.CommonForkJoinPoolExecutorServices;
import org.jboss.weld.executor.FixedThreadPoolExecutorServices;
import org.jboss.weld.executor.ProfilingExecutorServices;
import org.jboss.weld.executor.SingleThreadExecutorServices;
import org.jboss.weld.executor.TimingOutFixedThreadPoolExecutorServices;
import org.jboss.weld.logging.BootstrapLogger;
import org.jboss.weld.manager.api.ExecutorServices;
import org.jboss.weld.resources.spi.ResourceLoader;

public class ExecutorServicesFactory {
    private ExecutorServicesFactory() {
    }

    public static ExecutorServices create(ResourceLoader loader, WeldConfiguration configuration) {
        int threadPoolSize = configuration.getIntegerProperty(ConfigurationKey.EXECUTOR_THREAD_POOL_SIZE);
        boolean debug = configuration.getBooleanProperty(ConfigurationKey.EXECUTOR_THREAD_POOL_DEBUG);
        ThreadPoolType threadPoolType = ExecutorServicesFactory.initThreadPoolType(configuration);
        long threadPoolKeepAliveTime = configuration.getLongProperty(ConfigurationKey.EXECUTOR_THREAD_POOL_KEEP_ALIVE_TIME);
        if (debug) {
            return ExecutorServicesFactory.enableDebugMode(ExecutorServicesFactory.constructExecutorServices(threadPoolType, threadPoolSize, threadPoolKeepAliveTime));
        }
        return ExecutorServicesFactory.constructExecutorServices(threadPoolType, threadPoolSize, threadPoolKeepAliveTime);
    }

    private static ExecutorServices constructExecutorServices(ThreadPoolType type2, int threadPoolSize, long threadPoolKeepAliveTime) {
        switch (type2) {
            case NONE: {
                return null;
            }
            case SINGLE_THREAD: {
                return new SingleThreadExecutorServices();
            }
            case FIXED_TIMEOUT: {
                return new TimingOutFixedThreadPoolExecutorServices(threadPoolSize, threadPoolKeepAliveTime);
            }
            case COMMON: {
                return new CommonForkJoinPoolExecutorServices();
            }
        }
        return new FixedThreadPoolExecutorServices(threadPoolSize);
    }

    private static ExecutorServices enableDebugMode(ExecutorServices executor) {
        if (executor == null) {
            return executor;
        }
        return new ProfilingExecutorServices(executor);
    }

    private static ThreadPoolType initThreadPoolType(WeldConfiguration configuration) {
        String threadPoolTypeString = configuration.getStringProperty(ConfigurationKey.EXECUTOR_THREAD_POOL_TYPE);
        if (threadPoolTypeString.isEmpty()) {
            return ThreadPoolType.FIXED;
        }
        try {
            ThreadPoolType threadPoolType = ThreadPoolType.valueOf(threadPoolTypeString);
            return threadPoolType;
        }
        catch (Exception e) {
            throw BootstrapLogger.LOG.invalidThreadPoolType(threadPoolTypeString);
        }
    }

    public static enum ThreadPoolType {
        FIXED,
        FIXED_TIMEOUT,
        NONE,
        SINGLE_THREAD,
        COMMON;

    }
}

