/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.util.actions;

import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public final class GetAnnotationAttribute {
    private static final Log LOG = LoggerFactory.make(MethodHandles.lookup());

    private GetAnnotationAttribute() {
    }

    public static <T> T action(Annotation annotation, String attributeName, Class<T> type2) {
        try {
            Method m = annotation.getClass().getMethod(attributeName, new Class[0]);
            m.setAccessible(true);
            Object o = m.invoke((Object)annotation, new Object[0]);
            if (type2.isAssignableFrom(o.getClass())) {
                return (T)o;
            }
            throw LOG.getWrongAnnotationAttributeTypeException(annotation.annotationType(), attributeName, type2, o.getClass());
        }
        catch (NoSuchMethodException e) {
            throw LOG.getUnableToFindAnnotationAttributeException(annotation.annotationType(), attributeName, e);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw LOG.getUnableToGetAnnotationAttributeException(annotation.annotationType(), attributeName, e);
        }
    }
}

