/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.constraintvalidators.hv.kor;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.validator.constraints.kor.KorRRN;
import org.hibernate.validator.internal.util.Contracts;
import org.hibernate.validator.internal.util.ModUtil;

public class KorRRNValidator
implements ConstraintValidator<KorRRN, CharSequence> {
    private static final List<Integer> GENDER_DIGIT = List.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4));
    private static final int[] CHECK_SUM_WEIGHT = new int[]{5, 4, 3, 2, 9, 8, 7, 6, 5, 4, 3, 2};
    private static final int GENDER_DIGIT_INDEX = 6;
    private RRNValidationAlgorithm rrnValidationAlgorithm;

    @Override
    public void initialize(KorRRN constraintAnnotation) {
        this.rrnValidationAlgorithm = RRNValidationAlgorithm.from(constraintAnnotation.validateCheckDigit());
    }

    @Override
    public boolean isValid(CharSequence rrnValue, ConstraintValidatorContext context) {
        if (rrnValue == null) {
            return true;
        }
        return this.rrnValidationAlgorithm.isValid(rrnValue.toString().replace("-", ""));
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum RRNValidationAlgorithm {
        NEVER{

            @Override
            public boolean isValid(String rrn) {
                return RRNValidationAlgorithm.isValidLength(rrn) && RRNValidationAlgorithm.isValidDate(rrn) && RRNValidationAlgorithm.isValidGenderDigit(rrn);
            }
        }
        ,
        ALWAYS{

            @Override
            public boolean isValid(String rrn) {
                return RRNValidationAlgorithm.isValidLength(rrn) && RRNValidationAlgorithm.isValidDate(rrn) && RRNValidationAlgorithm.isValidGenderDigit(rrn) && RRNValidationAlgorithm.isValidChecksum(rrn);
            }
        };

        private static final int VALID_LENGTH = 13;
        private static final int THRESHOLD = 9;
        private static final int MODULDO = 11;

        static RRNValidationAlgorithm from(KorRRN.ValidateCheckDigit validateCheckDigit) {
            Contracts.assertNotNull((Object)validateCheckDigit);
            if (validateCheckDigit == KorRRN.ValidateCheckDigit.ALWAYS) {
                return ALWAYS;
            }
            return NEVER;
        }

        abstract boolean isValid(String var1);

        private static boolean isValidChecksum(String rrn) {
            int checksum = ModUtil.calculateModXCheckWithWeights(RRNValidationAlgorithm.toChecksumDigits(rrn), 11, 9, CHECK_SUM_WEIGHT);
            checksum = checksum >= 10 ? checksum - 10 : checksum;
            return checksum == RRNValidationAlgorithm.getCheckDigit(rrn);
        }

        private static boolean isValidDate(String rrn) {
            int month = RRNValidationAlgorithm.extractMonth(rrn);
            int day = RRNValidationAlgorithm.extractDay(rrn);
            if (month > 12 || day < 0 || day > 31) {
                return false;
            }
            return day <= 31 && (day <= 30 || month != 4 && month != 6 && month != 9 && month != 11) && (day <= 29 || month != 2);
        }

        private static boolean isValidLength(String rrn) {
            return rrn.length() == 13;
        }

        private static boolean isValidGenderDigit(String rrn) {
            return GENDER_DIGIT.contains(RRNValidationAlgorithm.extractGenderDigit(rrn));
        }

        private static int extractGenderDigit(String rrn) {
            return Character.getNumericValue(rrn.charAt(6));
        }

        private static List<Integer> toChecksumDigits(String rrn) {
            ArrayList<Integer> collect = new ArrayList<Integer>();
            for (int i = 0; i < rrn.length() - 1; ++i) {
                collect.add(Character.getNumericValue(rrn.charAt(i)));
            }
            return collect;
        }

        private static int getCheckDigit(String rrn) {
            return Character.getNumericValue(rrn.charAt(rrn.length() - 1));
        }

        private static int extractDay(String rrn) {
            return Integer.parseInt(rrn.substring(4, 6));
        }

        private static int extractMonth(String rrn) {
            return Integer.parseInt(rrn.substring(2, 4));
        }
    }
}

