/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.constraintvalidators.hv.br;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.lang.invoke.MethodHandles;
import java.util.regex.Pattern;
import org.hibernate.validator.constraints.Mod11Check;
import org.hibernate.validator.constraints.br.CNPJ;
import org.hibernate.validator.internal.constraintvalidators.hv.Mod11CheckValidator;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public class CNPJValidator
implements ConstraintValidator<CNPJ, CharSequence> {
    private static final Pattern NUMBERS_UPPER_LETTERS_ONLY_REGEXP = Pattern.compile("[0-9A-Z]+");
    private static final Pattern ALPHANUMERIC_PATTERN = Pattern.compile("([0-9A-Z]{2}[.]?[0-9A-Z]{3}[.]?[0-9A-Z]{3}[/]?[0-9A-Z]{4}[-]?[0-9]{2})");
    private static final Pattern NUMERIC_PATTERN = Pattern.compile("([0-9]{2}[.]?[0-9]{3}[.]?[0-9]{3}[/]?[0-9]{4}[-]?[0-9]{2})");
    private Mod11CheckValidator withSeparatorMod11Validator1;
    private Mod11CheckValidator withSeparatorMod11Validator2;
    private Mod11CheckValidator withoutSeparatorMod11Validator1;
    private Mod11CheckValidator withoutSeparatorMod11Validator2;
    private Pattern pattern;

    @Override
    public void initialize(CNPJ constraintAnnotation) {
        if (CNPJ.Format.NUMERIC.equals((Object)constraintAnnotation.format())) {
            this.withSeparatorMod11Validator1 = new Mod11CheckValidator();
            this.withSeparatorMod11Validator2 = new Mod11CheckValidator();
            this.withoutSeparatorMod11Validator1 = new Mod11CheckValidator();
            this.withoutSeparatorMod11Validator2 = new Mod11CheckValidator();
            this.pattern = NUMERIC_PATTERN;
        } else {
            this.withSeparatorMod11Validator1 = new CnpjAlphanumericMod11CheckValidator();
            this.withSeparatorMod11Validator2 = new CnpjAlphanumericMod11CheckValidator();
            this.withoutSeparatorMod11Validator1 = new CnpjAlphanumericMod11CheckValidator();
            this.withoutSeparatorMod11Validator2 = new CnpjAlphanumericMod11CheckValidator();
            this.pattern = ALPHANUMERIC_PATTERN;
        }
        this.withSeparatorMod11Validator1.initialize(0, 14, 16, true, 9, '0', '0', Mod11Check.ProcessingDirection.RIGHT_TO_LEFT, new int[0]);
        this.withSeparatorMod11Validator2.initialize(0, 16, 17, true, 9, '0', '0', Mod11Check.ProcessingDirection.RIGHT_TO_LEFT, new int[0]);
        this.withoutSeparatorMod11Validator1.initialize(0, 11, 12, true, 9, '0', '0', Mod11Check.ProcessingDirection.RIGHT_TO_LEFT, new int[0]);
        this.withoutSeparatorMod11Validator2.initialize(0, 12, 13, true, 9, '0', '0', Mod11Check.ProcessingDirection.RIGHT_TO_LEFT, new int[0]);
    }

    @Override
    public boolean isValid(CharSequence value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        if (!this.pattern.matcher(value.toString()).matches()) {
            return false;
        }
        char firstDigit = value.charAt(0);
        char otherDigit = value.charAt(1);
        for (int i = 2; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (!Character.isDigit(c) || firstDigit == c) continue;
            otherDigit = c;
        }
        if (firstDigit == otherDigit) {
            return false;
        }
        if (NUMBERS_UPPER_LETTERS_ONLY_REGEXP.matcher(value).matches()) {
            return this.withoutSeparatorMod11Validator1.isValid(value, context) && this.withoutSeparatorMod11Validator2.isValid(value, context);
        }
        return this.withSeparatorMod11Validator1.isValid(value, context) && this.withSeparatorMod11Validator2.isValid(value, context);
    }

    private static class CnpjAlphanumericMod11CheckValidator
    extends Mod11CheckValidator {
        private static final Log LOG = LoggerFactory.make(MethodHandles.lookup());
        private static final Pattern NUMBERS_UPPER_LETTERS_ONLY_STRIP_REGEXP = Pattern.compile("[^0-9A-Z]");
        private static final int BASE_CHAR_INDEX = 48;

        private CnpjAlphanumericMod11CheckValidator() {
        }

        @Override
        protected int extractDigit(char value) throws NumberFormatException {
            if (Character.isDigit(value) || value >= 'A' && value <= 'Z') {
                return value - 48;
            }
            throw LOG.getCharacterIsNotDigitOrUpperCaseLetterException(value);
        }

        @Override
        protected String stripNonDigitsIfRequired(String value) {
            if (this.ignoreDelimitingCharacters) {
                return NUMBERS_UPPER_LETTERS_ONLY_STRIP_REGEXP.matcher(value).replaceAll("");
            }
            return value;
        }
    }
}

