/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.cdi.internal.util;

import jakarta.validation.ValidatorFactory;
import java.lang.reflect.Method;
import java.util.Optional;
import org.hibernate.validator.HibernateValidatorFactory;
import org.hibernate.validator.internal.properties.DefaultGetterPropertySelectionStrategy;
import org.hibernate.validator.spi.properties.ConstrainableExecutable;
import org.hibernate.validator.spi.properties.GetterPropertySelectionStrategy;

public class GetterPropertySelectionStrategyHelper {
    private final GetterPropertySelectionStrategy getterPropertySelectionStrategy;

    private GetterPropertySelectionStrategyHelper(GetterPropertySelectionStrategy getterPropertySelectionStrategy) {
        this.getterPropertySelectionStrategy = getterPropertySelectionStrategy;
    }

    public Optional<String> getProperty(Method method) {
        return this.getterPropertySelectionStrategy.getProperty(new ConstrainableMethod(method));
    }

    public static GetterPropertySelectionStrategyHelper forValidationFactory(ValidatorFactory factory) {
        GetterPropertySelectionStrategy getterPropertySelectionStrategy = factory instanceof HibernateValidatorFactory ? factory.unwrap(HibernateValidatorFactory.class).getGetterPropertySelectionStrategy() : new DefaultGetterPropertySelectionStrategy();
        return new GetterPropertySelectionStrategyHelper(getterPropertySelectionStrategy);
    }

    private static class ConstrainableMethod
    implements ConstrainableExecutable {
        private final Method method;

        private ConstrainableMethod(Method method) {
            this.method = method;
        }

        @Override
        public Class<?> getReturnType() {
            return this.method.getReturnType();
        }

        @Override
        public String getName() {
            return this.method.getName();
        }

        @Override
        public Class<?>[] getParameterTypes() {
            return this.method.getParameterTypes();
        }
    }
}

