/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.cdi;

import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.AnnotatedCallable;
import jakarta.enterprise.inject.spi.AnnotatedConstructor;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.ProcessBean;
import jakarta.enterprise.inject.spi.WithAnnotations;
import jakarta.enterprise.util.AnnotationLiteral;
import jakarta.validation.BootstrapConfiguration;
import jakarta.validation.Configuration;
import jakarta.validation.Constraint;
import jakarta.validation.Valid;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import jakarta.validation.executable.ExecutableType;
import jakarta.validation.executable.ValidateOnExecution;
import jakarta.validation.metadata.BeanDescriptor;
import jakarta.validation.metadata.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.hibernate.validator.cdi.HibernateValidator;
import org.hibernate.validator.cdi.interceptor.internal.ValidationEnabledAnnotatedType;
import org.hibernate.validator.cdi.interceptor.spi.ValidationInterceptor;
import org.hibernate.validator.cdi.internal.InheritedMethodsHelper;
import org.hibernate.validator.cdi.internal.ValidationProviderHelper;
import org.hibernate.validator.cdi.internal.ValidatorBean;
import org.hibernate.validator.cdi.internal.ValidatorFactoryBean;
import org.hibernate.validator.cdi.internal.util.GetterPropertySelectionStrategyHelper;
import org.hibernate.validator.internal.util.Contracts;
import org.hibernate.validator.internal.util.ExecutableHelper;
import org.hibernate.validator.internal.util.TypeResolutionHelper;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;

public class ValidationExtension
implements Extension {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private static final EnumSet<ExecutableType> ALL_EXECUTABLE_TYPES = EnumSet.of(ExecutableType.CONSTRUCTORS, ExecutableType.NON_GETTER_METHODS, ExecutableType.GETTER_METHODS);
    private static final EnumSet<ExecutableType> DEFAULT_EXECUTABLE_TYPES = EnumSet.of(ExecutableType.CONSTRUCTORS, ExecutableType.NON_GETTER_METHODS);
    private final Annotation defaultQualifier = new AnnotationLiteral<Default>(){};
    private final Annotation hibernateValidatorQualifier = new AnnotationLiteral<HibernateValidator>(){};
    private final ExecutableHelper executableHelper;
    private final Validator validator;
    private final ValidatorFactory validatorFactory;
    private final GetterPropertySelectionStrategyHelper getterPropertySelectionStrategyHelper;
    private final Set<ExecutableType> globalExecutableTypes;
    private final boolean isExecutableValidationEnabled;
    private Bean<?> defaultValidatorFactoryBean;
    private Bean<?> hibernateValidatorFactoryBean;
    private Bean<?> defaultValidatorBean;
    private Bean<?> hibernateValidatorBean;

    public ValidationExtension() {
        Configuration<?> config = Validation.byDefaultProvider().configure();
        config.parameterNameProvider(config.getDefaultParameterNameProvider());
        BootstrapConfiguration bootstrap = config.getBootstrapConfiguration();
        this.globalExecutableTypes = bootstrap.getDefaultValidatedExecutableTypes();
        this.isExecutableValidationEnabled = bootstrap.isExecutableValidationEnabled();
        this.validatorFactory = config.buildValidatorFactory();
        this.validator = this.validatorFactory.getValidator();
        this.getterPropertySelectionStrategyHelper = GetterPropertySelectionStrategyHelper.forValidationFactory(this.validatorFactory);
        this.executableHelper = new ExecutableHelper(new TypeResolutionHelper());
    }

    public void beforeBeanDiscovery(@Observes BeforeBeanDiscovery beforeBeanDiscoveryEvent, BeanManager beanManager) {
        Contracts.assertNotNull(beforeBeanDiscoveryEvent, "The BeforeBeanDiscovery event cannot be null");
        Contracts.assertNotNull(beanManager, "The BeanManager cannot be null");
        AnnotatedType<ValidationInterceptor> annotatedType = beanManager.createAnnotatedType(ValidationInterceptor.class);
        beforeBeanDiscoveryEvent.addAnnotatedType(annotatedType, ValidationInterceptor.class.getName());
    }

    public void afterBeanDiscovery(@Observes AfterBeanDiscovery afterBeanDiscoveryEvent, BeanManager beanManager) {
        Contracts.assertNotNull(afterBeanDiscoveryEvent, "The AfterBeanDiscovery event cannot be null");
        Contracts.assertNotNull(beanManager, "The BeanManager cannot be null");
        ValidationProviderHelper defaultProviderHelper = ValidationProviderHelper.forDefaultProvider(this.validatorFactory);
        ValidationProviderHelper hvProviderHelper = ValidationProviderHelper.forHibernateValidator();
        if (this.defaultValidatorFactoryBean == null) {
            this.defaultValidatorFactoryBean = new ValidatorFactoryBean(beanManager, defaultProviderHelper);
            if (this.hibernateValidatorFactoryBean == null && defaultProviderHelper.isHibernateValidator()) {
                this.hibernateValidatorFactoryBean = this.defaultValidatorFactoryBean;
            }
            afterBeanDiscoveryEvent.addBean(this.defaultValidatorFactoryBean);
        }
        if (this.hibernateValidatorFactoryBean == null) {
            this.hibernateValidatorFactoryBean = new ValidatorFactoryBean(beanManager, hvProviderHelper);
            afterBeanDiscoveryEvent.addBean(this.hibernateValidatorFactoryBean);
        }
        if (this.defaultValidatorBean == null) {
            this.defaultValidatorBean = new ValidatorBean(beanManager, this.defaultValidatorFactoryBean, defaultProviderHelper);
            if (this.hibernateValidatorBean == null && defaultProviderHelper.isHibernateValidator()) {
                this.hibernateValidatorBean = this.defaultValidatorBean;
            }
            afterBeanDiscoveryEvent.addBean(this.defaultValidatorBean);
        }
        if (this.hibernateValidatorBean == null) {
            this.hibernateValidatorBean = new ValidatorBean(beanManager, this.hibernateValidatorFactoryBean, hvProviderHelper);
            afterBeanDiscoveryEvent.addBean(this.hibernateValidatorBean);
        }
    }

    public void processBean(@Observes ProcessBean<?> processBeanEvent) {
        Contracts.assertNotNull(processBeanEvent, "The ProcessBean event cannot be null");
        Bean<?> bean = processBeanEvent.getBean();
        if (bean.getTypes().contains(ValidatorFactory.class) || bean instanceof ValidatorFactoryBean) {
            if (bean.getQualifiers().contains(this.defaultQualifier)) {
                this.defaultValidatorFactoryBean = bean;
            }
            if (bean.getQualifiers().contains(this.hibernateValidatorQualifier)) {
                this.hibernateValidatorFactoryBean = bean;
            }
        } else if (bean.getTypes().contains(Validator.class) || bean instanceof ValidatorBean) {
            if (bean.getQualifiers().contains(this.defaultQualifier)) {
                this.defaultValidatorBean = bean;
            }
            if (bean.getQualifiers().contains(this.hibernateValidatorQualifier)) {
                this.hibernateValidatorBean = bean;
            }
        }
    }

    public <T> void processAnnotatedType(@Observes @WithAnnotations(value={Constraint.class, Valid.class, ValidateOnExecution.class}) ProcessAnnotatedType<T> processAnnotatedTypeEvent) {
        Contracts.assertNotNull(processAnnotatedTypeEvent, "The ProcessAnnotatedType event cannot be null");
        if (!this.isExecutableValidationEnabled) {
            return;
        }
        AnnotatedType<T> type2 = processAnnotatedTypeEvent.getAnnotatedType();
        Set constrainedCallables = this.determineConstrainedCallables(type2);
        if (!constrainedCallables.isEmpty()) {
            ValidationEnabledAnnotatedType wrappedType = new ValidationEnabledAnnotatedType(type2, constrainedCallables);
            processAnnotatedTypeEvent.setAnnotatedType(wrappedType);
        }
    }

    private <T> Set<AnnotatedCallable<? super T>> determineConstrainedCallables(AnnotatedType<T> type2) {
        HashSet<AnnotatedCallable<? super T>> callables = new HashSet<AnnotatedCallable<? super T>>();
        BeanDescriptor beanDescriptor = this.validator.getConstraintsForClass(type2.getJavaClass());
        this.determineConstrainedConstructors(type2, beanDescriptor, callables);
        this.determineConstrainedMethods(type2, beanDescriptor, callables);
        return callables;
    }

    private <T> void determineConstrainedMethods(AnnotatedType<T> type2, BeanDescriptor beanDescriptor, Set<AnnotatedCallable<? super T>> callables) {
        List<Method> overriddenAndImplementedMethods = InheritedMethodsHelper.getAllMethods(type2.getJavaClass());
        for (AnnotatedMethod<T> annotatedMethod : type2.getMethods()) {
            boolean needsValidation;
            ExecutableType currentExecutableType;
            EnumSet<ExecutableType> memberLevelExecutableType;
            Method method = annotatedMethod.getJavaMember();
            Optional<String> correspondingProperty = this.getterPropertySelectionStrategyHelper.getProperty(method);
            Method methodForExecutableTypeRetrieval = this.replaceWithOverriddenOrInterfaceMethod(method, overriddenAndImplementedMethods);
            EnumSet<ExecutableType> classLevelExecutableTypes = this.executableTypesDefinedOnType(methodForExecutableTypeRetrieval.getDeclaringClass());
            if (this.veto(classLevelExecutableTypes, memberLevelExecutableType = this.executableTypesDefinedOnMethod(methodForExecutableTypeRetrieval, correspondingProperty.isPresent()), currentExecutableType = correspondingProperty.isPresent() ? ExecutableType.GETTER_METHODS : ExecutableType.NON_GETTER_METHODS) || !(needsValidation = correspondingProperty.isPresent() ? this.isGetterConstrained(beanDescriptor, method, correspondingProperty.get()) : this.isNonGetterConstrained(beanDescriptor, method))) continue;
            callables.add(annotatedMethod);
        }
    }

    private <T> void determineConstrainedConstructors(AnnotatedType<T> type2, BeanDescriptor beanDescriptor, Set<AnnotatedCallable<? super T>> callables) {
        Class<T> clazz = type2.getJavaClass();
        EnumSet<ExecutableType> classLevelExecutableTypes = this.executableTypesDefinedOnType(clazz);
        for (AnnotatedConstructor<T> annotatedConstructor : type2.getConstructors()) {
            Member constructor = annotatedConstructor.getJavaMember();
            EnumSet<ExecutableType> memberLevelExecutableType = this.executableTypesDefinedOnConstructor((Constructor<?>)constructor);
            if (this.veto(classLevelExecutableTypes, memberLevelExecutableType, ExecutableType.CONSTRUCTORS) || beanDescriptor.getConstraintsForConstructor(((Constructor)constructor).getParameterTypes()) == null) continue;
            callables.add(annotatedConstructor);
        }
    }

    private boolean isNonGetterConstrained(BeanDescriptor beanDescriptor, Method method) {
        return beanDescriptor.getConstraintsForMethod(method.getName(), method.getParameterTypes()) != null;
    }

    private boolean isGetterConstrained(BeanDescriptor beanDescriptor, Method method, String property) {
        PropertyDescriptor propertyDescriptor = beanDescriptor.getConstraintsForProperty(property);
        return propertyDescriptor != null && propertyDescriptor.findConstraints().declaredOn(ElementType.METHOD).hasConstraints();
    }

    private boolean veto(EnumSet<ExecutableType> classLevelExecutableTypes, EnumSet<ExecutableType> memberLevelExecutableType, ExecutableType currentExecutableType) {
        if (!memberLevelExecutableType.isEmpty()) {
            return !memberLevelExecutableType.contains((Object)currentExecutableType) && !memberLevelExecutableType.contains((Object)ExecutableType.IMPLICIT);
        }
        if (!classLevelExecutableTypes.isEmpty()) {
            return !classLevelExecutableTypes.contains((Object)currentExecutableType) && !classLevelExecutableTypes.contains((Object)ExecutableType.IMPLICIT);
        }
        return !this.globalExecutableTypes.contains((Object)currentExecutableType);
    }

    private EnumSet<ExecutableType> executableTypesDefinedOnType(Class<?> clazz) {
        ValidateOnExecution validateOnExecutionAnnotation = clazz.getAnnotation(ValidateOnExecution.class);
        EnumSet<ExecutableType> executableTypes = this.commonExecutableTypeChecks(validateOnExecutionAnnotation);
        if (executableTypes.contains((Object)ExecutableType.IMPLICIT)) {
            return DEFAULT_EXECUTABLE_TYPES;
        }
        return executableTypes;
    }

    private EnumSet<ExecutableType> executableTypesDefinedOnMethod(Method method, boolean isGetter) {
        ValidateOnExecution validateOnExecutionAnnotation = method.getAnnotation(ValidateOnExecution.class);
        EnumSet<ExecutableType> executableTypes = this.commonExecutableTypeChecks(validateOnExecutionAnnotation);
        if (executableTypes.contains((Object)ExecutableType.IMPLICIT)) {
            if (isGetter) {
                executableTypes.add(ExecutableType.GETTER_METHODS);
            } else {
                executableTypes.add(ExecutableType.NON_GETTER_METHODS);
            }
        }
        return executableTypes;
    }

    private EnumSet<ExecutableType> executableTypesDefinedOnConstructor(Constructor<?> constructor) {
        ValidateOnExecution validateOnExecutionAnnotation = constructor.getAnnotation(ValidateOnExecution.class);
        EnumSet<ExecutableType> executableTypes = this.commonExecutableTypeChecks(validateOnExecutionAnnotation);
        if (executableTypes.contains((Object)ExecutableType.IMPLICIT)) {
            executableTypes.add(ExecutableType.CONSTRUCTORS);
        }
        return executableTypes;
    }

    private EnumSet<ExecutableType> commonExecutableTypeChecks(ValidateOnExecution validateOnExecutionAnnotation) {
        if (validateOnExecutionAnnotation == null) {
            return EnumSet.noneOf(ExecutableType.class);
        }
        EnumSet<ExecutableType> executableTypes = EnumSet.noneOf(ExecutableType.class);
        if (validateOnExecutionAnnotation.type().length == 0) {
            executableTypes.add(ExecutableType.NONE);
        } else {
            Collections.addAll(executableTypes, validateOnExecutionAnnotation.type());
        }
        if (executableTypes.contains((Object)ExecutableType.IMPLICIT) && executableTypes.size() > 1) {
            throw log.getMixingImplicitWithOtherExecutableTypesException();
        }
        if (executableTypes.contains((Object)ExecutableType.NONE) && executableTypes.size() > 1) {
            executableTypes.remove((Object)ExecutableType.NONE);
        }
        if (executableTypes.contains((Object)ExecutableType.ALL)) {
            executableTypes = ALL_EXECUTABLE_TYPES;
        }
        return executableTypes;
    }

    private Method replaceWithOverriddenOrInterfaceMethod(Method method, List<Method> allMethodsOfType) {
        LinkedList<Method> list = new LinkedList<Method>(allMethodsOfType);
        Iterator<Method> iterator = list.descendingIterator();
        while (iterator.hasNext()) {
            Method overriddenOrInterfaceMethod = iterator.next();
            if (!this.executableHelper.overrides(method, overriddenOrInterfaceMethod)) continue;
            if (method.getAnnotation(ValidateOnExecution.class) != null) {
                throw log.getValidateOnExecutionOnOverriddenOrInterfaceMethodException(method);
            }
            return overriddenOrInterfaceMethod;
        }
        return method;
    }
}

