/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld.services;

import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import jakarta.transaction.Synchronization;
import jakarta.transaction.SystemException;
import jakarta.transaction.UserTransaction;
import java.lang.annotation.Annotation;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.glassfish.hk2.api.ServiceLocator;
import org.jboss.weld.transaction.spi.TransactionServices;

public class TransactionServicesImpl
implements TransactionServices {
    private final JavaEETransactionManager transactionManager;

    public TransactionServicesImpl(ServiceLocator services) {
        this.transactionManager = services.getService(JavaEETransactionManager.class, new Annotation[0]);
        if (this.transactionManager == null) {
            throw new RuntimeException("Unable to retrieve transaction mgr.");
        }
    }

    @Override
    public boolean isTransactionActive() {
        try {
            int curStatus = this.transactionManager.getStatus();
            return curStatus == 0 || curStatus == 1 || curStatus == 2 || curStatus == 5 || curStatus == 7 || curStatus == 8 || curStatus == 9;
        }
        catch (SystemException e) {
            throw new RuntimeException("Unable to determine transaction status", e);
        }
    }

    @Override
    public void registerSynchronization(Synchronization observer) {
        try {
            this.transactionManager.registerSynchronization(observer);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to register synchronization " + String.valueOf(observer) + " for current transaction", e);
        }
    }

    @Override
    public UserTransaction getUserTransaction() {
        try {
            return (UserTransaction)InitialContext.doLookup("java:comp/UserTransaction");
        }
        catch (NamingException e) {
            return null;
        }
    }

    @Override
    public void cleanup() {
    }
}

