/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld.services;

import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import jakarta.enterprise.inject.spi.AnnotatedConstructor;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.weld.construction.api.AroundConstructCallback;
import org.jboss.weld.construction.api.ConstructionHandle;
import org.jboss.weld.exceptions.WeldException;

public class CDIAroundConstructCallback<T>
implements AroundConstructCallback<T> {
    private BaseContainer container;
    private EJBContextImpl ejbContext;
    private final AtomicReference<T> target = new AtomicReference();
    private ConstructionHandle<T> handle;
    private Object[] parameters;

    public CDIAroundConstructCallback(BaseContainer container, EJBContextImpl ejbContext) {
        this.container = container;
        this.ejbContext = ejbContext;
    }

    @Override
    public T aroundConstruct(ConstructionHandle<T> handle, AnnotatedConstructor<T> constructor, Object[] parameters, Map<String, Object> data) {
        this.handle = handle;
        this.parameters = parameters;
        try {
            this.container.intercept(LifecycleCallbackDescriptor.CallbackType.AROUND_CONSTRUCT, this.ejbContext);
            if (this.target.get() == null) {
                T ejb = handle.proceed(parameters, new HashMap<String, Object>());
                this.target.set(ejb);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new WeldException(e);
        }
        return this.target.get();
    }

    public T createEjb() {
        T instance = null;
        if (this.handle != null) {
            instance = this.handle.proceed(this.parameters, new HashMap<String, Object>());
        }
        this.target.set(instance);
        return instance;
    }
}

