/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.weld;

import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.jsp.JspApplicationContext;
import jakarta.servlet.jsp.JspFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.cdi.CDILoggerInfo;
import org.glassfish.wasp.runtime.JspApplicationContextImpl;
import org.jboss.weld.module.web.el.WeldELContextListener;

public class WeldContextListener
implements ServletContextListener {
    private Logger logger = CDILoggerInfo.getLogger();
    @Inject
    private BeanManager beanManager;

    @Override
    public void contextInitialized(ServletContextEvent servletContextEvent) {
        if (this.beanManager != null) {
            JspApplicationContext jspAppContext = this.getJspApplicationContext(servletContextEvent);
            jspAppContext.addELResolver(this.beanManager.getELResolver());
            try {
                Class<?> weldClass = Class.forName("org.jboss.weld.module.web.el.WeldELContextListener");
                WeldELContextListener welcl = (WeldELContextListener)weldClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                jspAppContext.addELContextListener(welcl);
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, "AS-CDI-00035", new Object[]{e});
            }
            ((JspApplicationContextImpl)jspAppContext).setExpressionFactory(this.beanManager.wrapExpressionFactory(jspAppContext.getExpressionFactory()));
        }
    }

    @Override
    public void contextDestroyed(ServletContextEvent sce) {
        if (this.beanManager != null) {
            this.beanManager = null;
        }
    }

    protected JspApplicationContext getJspApplicationContext(ServletContextEvent servletContextEvent) {
        return JspFactory.getDefaultFactory().getJspApplicationContext(servletContextEvent.getServletContext());
    }
}

