/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.deployment.node.runtime.gf;

import com.sun.enterprise.deployment.node.XMLElement;
import com.sun.enterprise.deployment.node.runtime.RuntimeDescriptorNode;
import java.util.Map;
import org.glassfish.web.deployment.node.runtime.gf.ConstraintFieldNode;
import org.glassfish.web.deployment.runtime.CacheMapping;
import org.glassfish.web.deployment.runtime.ConstraintField;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;

public class CacheMappingNode
extends RuntimeDescriptorNode<CacheMapping> {
    protected CacheMapping descriptor = null;

    public CacheMappingNode() {
        this.registerElementHandler(new XMLElement("constraint-field"), ConstraintFieldNode.class, "addNewConstraintField");
    }

    @Override
    public CacheMapping getDescriptor() {
        if (this.descriptor == null) {
            this.descriptor = new CacheMapping();
        }
        return this.descriptor;
    }

    @Override
    protected Map<String, String> getDispatchTable() {
        Map<String, String> dispatchTable = super.getDispatchTable();
        dispatchTable.put("servlet-name", "setServletName");
        dispatchTable.put("url-pattern", "setURLPattern");
        dispatchTable.put("cache-helper-ref", "setCacheHelperRef");
        dispatchTable.put("timeout", "setTimeout");
        dispatchTable.put("http-method", "addNewHttpMethod");
        dispatchTable.put("dispatcher", "addNewDispatcher");
        return dispatchTable;
    }

    @Override
    public void startElement(XMLElement element, Attributes attributes) {
        CacheMapping descriptor = this.getDescriptor();
        if (element.getQName().equals("timeout")) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                if ("name".equals(attributes.getQName(i))) {
                    descriptor.setAttributeValue("Timeout", "Name", attributes.getValue(i));
                    continue;
                }
                if (!"scope".equals(attributes.getQName(i))) continue;
                int index = 0;
                while (descriptor.getAttributeValue("Timeout", index, "Name") != null) {
                    ++index;
                }
                descriptor.setAttributeValue("Timeout", index - 1, "Scope", attributes.getValue(i));
            }
        } else if (element.getQName().equals("refresh-field")) {
            descriptor.setRefreshField(true);
            for (int i = 0; i < attributes.getLength(); ++i) {
                if ("name".equals(attributes.getQName(i))) {
                    descriptor.setAttributeValue("RefreshField", 0, "Name", attributes.getValue(i));
                    continue;
                }
                if (!"scope".equals(attributes.getQName(i))) continue;
                descriptor.setAttributeValue("RefreshField", 0, "Scope", attributes.getValue(i));
            }
        } else if (element.getQName().equals("key-field")) {
            descriptor.addKeyField(true);
            for (int i = 0; i < attributes.getLength(); ++i) {
                if ("name".equals(attributes.getQName(i))) {
                    descriptor.setAttributeValue("KeyField", "Name", attributes.getValue(i));
                    continue;
                }
                if (!"scope".equals(attributes.getQName(i))) continue;
                int index = descriptor.sizeKeyField();
                descriptor.setAttributeValue("KeyField", index - 1, "Scope", attributes.getValue(i));
            }
        } else {
            super.startElement(element, attributes);
        }
    }

    @Override
    public Node writeDescriptor(Node parent, String nodeName, CacheMapping descriptor) {
        String[] httpMethods;
        String scope;
        Node cacheMapping = super.writeDescriptor(parent, nodeName, descriptor);
        if (descriptor.getServletName() != null) {
            CacheMappingNode.appendTextChild(cacheMapping, "servlet-name", descriptor.getServletName());
        } else {
            CacheMappingNode.appendTextChild(cacheMapping, "url-pattern", descriptor.getURLPattern());
        }
        CacheMappingNode.appendTextChild(cacheMapping, "cache-helper-ref", (String)descriptor.getValue("CacheHelperRef"));
        String[] dispatchers = descriptor.getDispatcher();
        if (dispatchers != null) {
            for (String dispatcher : dispatchers) {
                CacheMappingNode.appendTextChild(cacheMapping, "dispatcher", dispatcher);
            }
        }
        Element timeout = (Element)CacheMappingNode.forceAppendTextChild(cacheMapping, "timeout", (String)descriptor.getValue("Timeout"));
        String name = descriptor.getAttributeValue("Timeout", "Name");
        if (name != null) {
            CacheMappingNode.setAttribute(timeout, "name", name);
        }
        if ((scope = descriptor.getAttributeValue("Timeout", "Scope")) != null) {
            CacheMappingNode.setAttribute(timeout, "scope", scope);
        }
        if (descriptor.isRefreshField()) {
            Element refreshField = CacheMappingNode.appendChild(cacheMapping, "refresh-field");
            CacheMappingNode.setAttribute(refreshField, "name", descriptor.getAttributeValue("RefreshField", "Name"));
            CacheMappingNode.setAttribute(refreshField, "scope", descriptor.getAttributeValue("RefreshField", "Scope"));
        }
        if ((httpMethods = descriptor.getHttpMethod()) != null) {
            for (String httpMethod : httpMethods) {
                CacheMappingNode.appendTextChild(cacheMapping, "http-method", httpMethod);
            }
        }
        if (descriptor.sizeKeyField() > 0) {
            for (int i = 0; i < descriptor.sizeKeyField(); ++i) {
                if (!descriptor.isKeyField(i)) continue;
                Element keyField = CacheMappingNode.appendChild(cacheMapping, "key-field");
                CacheMappingNode.setAttribute(keyField, "name", descriptor.getAttributeValue("KeyField", i, "Name"));
                CacheMappingNode.setAttribute(keyField, "scope", descriptor.getAttributeValue("KeyField", i, "Scope"));
            }
        }
        if (descriptor.sizeConstraintField() > 0) {
            ConstraintField[] constraintFields = descriptor.getConstraintField();
            ConstraintFieldNode cfn = new ConstraintFieldNode();
            cfn.writeDescriptor(cacheMapping, "constraint-field", constraintFields);
        }
        return cacheMapping;
    }
}

