/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.monitor;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.external.probe.provider.PluginPoint;
import org.glassfish.external.probe.provider.StatsProviderManager;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.web.admin.LogFacade;
import org.glassfish.web.admin.monitor.HttpServiceStatsProvider;
import org.glassfish.web.admin.monitor.VirtualServerInfoStatsProvider;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigurationException;

@Service(name="http-service")
@Singleton
public class HttpServiceStatsProviderBootstrap
implements PostConstruct {
    @Inject
    @Named(value="default-instance-name")
    Config config;
    private static final Logger logger = LogFacade.getLogger();
    private static final ResourceBundle rb = logger.getResourceBundle();

    @Override
    public void postConstruct() {
        if (this.config == null) {
            Object[] params = new Object[]{VirtualServerInfoStatsProvider.class.getName(), HttpServiceStatsProvider.class.getName(), "http service", "virtual server"};
            logger.log(Level.SEVERE, "AS-WEB-ADMIN-00001", params);
            throw new ConfigurationException(rb.getString("AS-WEB-ADMIN-00002"));
        }
        HttpService httpService = this.config.getHttpService();
        for (VirtualServer vs : httpService.getVirtualServer()) {
            StatsProviderManager.register("http-service", PluginPoint.SERVER, "http-service/" + vs.getId(), new VirtualServerInfoStatsProvider(vs));
            StatsProviderManager.register("http-service", PluginPoint.SERVER, "http-service/" + vs.getId() + "/request", new HttpServiceStatsProvider(vs.getId(), vs.getNetworkListeners(), this.config.getNetworkConfig()));
        }
    }
}

