/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.monitor;

import com.sun.enterprise.util.StringUtils;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.StringStatistic;
import org.glassfish.external.statistics.annotations.Reset;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.external.statistics.impl.StringStatisticImpl;
import org.glassfish.external.statistics.impl.TimeStatisticImpl;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;
import org.glassfish.grizzly.config.dom.NetworkConfig;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.web.admin.LogFacade;
import org.glassfish.web.admin.monitor.TimeStatData;

@AMXMetadata(type="request-mon", group="monitoring")
@ManagedObject
@Description(value="Web Container HTTP Service Statistics")
public class HttpServiceStatsProvider
implements PostConstruct {
    private NetworkConfig networkConfig;
    private static final Logger logger = LogFacade.getLogger();
    private static final String ERROR_COUNT_DESCRIPTION = "Cumulative value of the error count, with error count representing the number of cases where the response code was greater than or equal to 400";
    private static final String MAX_TIME_DESCRIPTION = "Longest response time for a request; not a cumulative value, but the largest response time from among the response times";
    private static final String PROCESSING_TIME_DESCRIPTION = "Average request processing time";
    private static final String COUNT_BYTES_RECEIVED_DESCRIPTION = "The number of bytes received";
    private static final String COUNT_BYTES_TRANSMITTED_DESCRIPTION = "The number of bytes transmitted";
    private static final String COUNT_OPEN_CONNECTIONS_DESCRIPTION = "The number of open connections";
    private static final String COUNT_REQUESTS_DESCRIPTION = "The number of requests received";
    private static final String MAX_OPEN_CONNECTIONS_DESCRIPTION = "The maximum number of open connections";
    private static final String METHOD_DESCRIPTION = "The method of the last request serviced";
    private static final String URI_DESCRIPTION = "The URI of the last request serviced";
    private static final String COUNT_200_DESCRIPTION = "Number of responses with a status code equal to 200";
    private static final String COUNT_2xx_DESCRIPTION = "Number of responses with a status code in the 2xx range";
    private static final String COUNT_302_DESCRIPTION = "Number of responses with a status code equal to 302";
    private static final String COUNT_304_DESCRIPTION = "Number of responses with a status code equal to 304";
    private static final String COUNT_3xx_DESCRIPTION = "Number of responses with a status code in the 3xx range";
    private static final String COUNT_400_DESCRIPTION = "Number of responses with a status code equal to 400";
    private static final String COUNT_401_DESCRIPTION = "Number of responses with a status code equal to 401";
    private static final String COUNT_403_DESCRIPTION = "Number of responses with a status code equal to 403";
    private static final String COUNT_404_DESCRIPTION = "Number of responses with a status code equal to 404";
    private static final String COUNT_4xx_DESCRIPTION = "Number of responses with a status code in the 4xx range";
    private static final String COUNT_503_DESCRIPTION = "Number of responses with a status code equal to 503";
    private static final String COUNT_5xx_DESCRIPTION = "Number of responses with a status code in the 5xx range";
    private static final String COUNT_OTHER_DESCRIPTION = "Number of responses with a status code outside the 2xx, 3xx, 4xx, and 5xx range";
    private CountStatisticImpl errorCount = new CountStatisticImpl("ErrorCount", "count", "Cumulative value of the error count, with error count representing the number of cases where the response code was greater than or equal to 400");
    private CountStatisticImpl maxTime = new CountStatisticImpl("MaxTime", "millisecond", "Longest response time for a request; not a cumulative value, but the largest response time from among the response times");
    private CountStatisticImpl processingTime = new CountStatisticImpl("ProcessingTime", "millisecond", "Average request processing time");
    private CountStatisticImpl countBytesReceived = new CountStatisticImpl("CountBytesReceived", "count", "The number of bytes received");
    private CountStatisticImpl countBytesTransmitted = new CountStatisticImpl("CountBytesTransmitted", "count", "The number of bytes transmitted");
    private CountStatisticImpl countOpenConnections = new CountStatisticImpl("CountOpenConnections", "count", "The number of open connections");
    private CountStatisticImpl countRequests = new CountStatisticImpl("CountRequests", "count", "The number of requests received");
    private CountStatisticImpl maxOpenConnections = new CountStatisticImpl("MaxOpenConnections", "count", "The maximum number of open connections");
    private StringStatisticImpl method = new StringStatisticImpl("Method", "String", "The method of the last request serviced");
    private StringStatisticImpl uri = new StringStatisticImpl("Uri", "String", "The URI of the last request serviced");
    private CountStatisticImpl count200 = new CountStatisticImpl("Count200", "count", "Number of responses with a status code equal to 200");
    private CountStatisticImpl count2xx = new CountStatisticImpl("Count2xx", "count", "Number of responses with a status code in the 2xx range");
    private CountStatisticImpl count302 = new CountStatisticImpl("Count302", "count", "Number of responses with a status code equal to 302");
    private CountStatisticImpl count304 = new CountStatisticImpl("Count304", "count", "Number of responses with a status code equal to 304");
    private CountStatisticImpl count3xx = new CountStatisticImpl("Count3xx", "count", "Number of responses with a status code in the 3xx range");
    private CountStatisticImpl count400 = new CountStatisticImpl("Count400", "count", "Number of responses with a status code equal to 400");
    private CountStatisticImpl count401 = new CountStatisticImpl("Count401", "count", "Number of responses with a status code equal to 401");
    private CountStatisticImpl count403 = new CountStatisticImpl("Count403", "count", "Number of responses with a status code equal to 403");
    private CountStatisticImpl count404 = new CountStatisticImpl("Count404", "count", "Number of responses with a status code equal to 404");
    private CountStatisticImpl count4xx = new CountStatisticImpl("Count4xx", "count", "Number of responses with a status code in the 4xx range");
    private CountStatisticImpl count503 = new CountStatisticImpl("Count503", "count", "Number of responses with a status code equal to 503");
    private CountStatisticImpl count5xx = new CountStatisticImpl("Count5xx", "count", "Number of responses with a status code in the 5xx range");
    private CountStatisticImpl countOther = new CountStatisticImpl("CountOther", "count", "Number of responses with a status code outside the 2xx, 3xx, 4xx, and 5xx range");
    private TimeStatisticImpl requestProcessTime = new TimeStatisticImpl(0L, 0L, 0L, 0L, "", "", "", System.currentTimeMillis(), -1L);
    private String virtualServerName = null;
    private String[] networkListeners = null;
    private AtomicLong maxOpenConnectionsAtomic = new AtomicLong();
    private ThreadLocal<TimeStatData> individualData = new ThreadLocal<TimeStatData>(){
        TimeStatData tsd;

        @Override
        protected TimeStatData initialValue() {
            this.tsd = new TimeStatData();
            return this.tsd;
        }

        @Override
        public TimeStatData get() {
            if (this.tsd == null) {
                this.tsd = new TimeStatData();
            }
            return this.tsd;
        }
    };

    public HttpServiceStatsProvider(String vsName, String listeners, NetworkConfig networkConfig) {
        this.virtualServerName = vsName;
        List<String> listenerList = StringUtils.parseStringList(listeners, ",");
        this.networkListeners = listenerList == null ? new String[]{} : listenerList.toArray(new String[listenerList.size()]);
        this.networkConfig = networkConfig;
    }

    @Override
    public void postConstruct() {
    }

    @ManagedAttribute(id="maxtime")
    @Description(value="Longest response time for a request; not a cumulative value, but the largest response time from among the response times")
    public CountStatistic getMaxTime() {
        this.maxTime.setCount(this.requestProcessTime.getMaxTime());
        return this.maxTime;
    }

    @ManagedAttribute(id="processingtime")
    @Description(value="Average request processing time")
    public CountStatistic getTime() {
        this.processingTime.setCount(this.getProcessTime());
        return this.processingTime;
    }

    @ManagedAttribute(id="countbytesreceived")
    @Description(value="The number of bytes received")
    public CountStatistic getCountBytesReceived() {
        return this.countBytesReceived;
    }

    @ManagedAttribute(id="countbytestransmitted")
    @Description(value="The number of bytes transmitted")
    public CountStatistic getCountBytesTransmitted() {
        return this.countBytesTransmitted;
    }

    @ManagedAttribute(id="countopenconnections")
    @Description(value="The number of open connections")
    public CountStatistic getCountOpenConnections() {
        return this.countOpenConnections;
    }

    @ManagedAttribute(id="countrequests")
    @Description(value="The number of requests received")
    public CountStatistic getCountRequests() {
        return this.countRequests;
    }

    @ManagedAttribute(id="maxopenconnections")
    @Description(value="The maximum number of open connections")
    public CountStatistic getMaxOpenConnections() {
        return this.maxOpenConnections;
    }

    @ManagedAttribute(id="method")
    @Description(value="The method of the last request serviced")
    public StringStatistic getMethod() {
        return this.method;
    }

    @ManagedAttribute(id="uri")
    @Description(value="The URI of the last request serviced")
    public StringStatistic getUri() {
        return this.uri;
    }

    @ManagedAttribute(id="errorcount")
    @Description(value="Cumulative value of the error count, with error count representing the number of cases where the response code was greater than or equal to 400")
    public CountStatistic getErrorCount() {
        return this.errorCount;
    }

    @ManagedAttribute(id="count200")
    @Description(value="Number of responses with a status code equal to 200")
    public CountStatistic getCount200() {
        return this.count200;
    }

    @ManagedAttribute(id="count2xx")
    @Description(value="Number of responses with a status code in the 2xx range")
    public CountStatistic getCount2xx() {
        return this.count2xx;
    }

    @ManagedAttribute(id="count302")
    @Description(value="Number of responses with a status code equal to 302")
    public CountStatistic getCount302() {
        return this.count302;
    }

    @ManagedAttribute(id="count304")
    @Description(value="Number of responses with a status code equal to 304")
    public CountStatistic getCount304() {
        return this.count304;
    }

    @ManagedAttribute(id="count3xx")
    @Description(value="Number of responses with a status code in the 3xx range")
    public CountStatistic getCount3xxt() {
        return this.count3xx;
    }

    @ManagedAttribute(id="count400")
    @Description(value="Number of responses with a status code equal to 400")
    public CountStatistic getCount400() {
        return this.count400;
    }

    @ManagedAttribute(id="count401")
    @Description(value="Number of responses with a status code equal to 401")
    public CountStatistic getCount401() {
        return this.count401;
    }

    @ManagedAttribute(id="count403")
    @Description(value="Number of responses with a status code equal to 403")
    public CountStatistic getCount403() {
        return this.count403;
    }

    @ManagedAttribute(id="count404")
    @Description(value="Number of responses with a status code equal to 404")
    public CountStatistic getCount404() {
        return this.count404;
    }

    @ManagedAttribute(id="count4xx")
    @Description(value="Number of responses with a status code in the 4xx range")
    public CountStatistic getCount4xx() {
        return this.count4xx;
    }

    @ManagedAttribute(id="count503")
    @Description(value="Number of responses with a status code equal to 503")
    public CountStatistic getCount503() {
        return this.count503;
    }

    @ManagedAttribute(id="count5xx")
    @Description(value="Number of responses with a status code in the 5xx range")
    public CountStatistic getCount5xx() {
        return this.count5xx;
    }

    @ManagedAttribute(id="countother")
    @Description(value="Number of responses with a status code outside the 2xx, 3xx, 4xx, and 5xx range")
    public CountStatistic getCountOther() {
        return this.countOther;
    }

    @ProbeListener(value="glassfish:web:http-service:dataReceivedEvent")
    public void dataReceivedEvent(@ProbeParam(value="size") int size, @ProbeParam(value="hostName") String hostName) {
        if (hostName != null && hostName.equals(this.virtualServerName)) {
            this.countBytesReceived.increment(size);
        }
    }

    @ProbeListener(value="glassfish:web:http-service:dataSentEvent")
    public void dataSentEvent(@ProbeParam(value="size") long size, @ProbeParam(value="hostName") String hostName) {
        if (hostName != null && hostName.equals(this.virtualServerName)) {
            this.countBytesTransmitted.increment(size);
        }
    }

    @ProbeListener(value="glassfish:web:http-service:requestStartEvent")
    public void requestStartEvent(@ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName, @ProbeParam(value="serverName") String serverName, @ProbeParam(value="serverPort") int serverPort, @ProbeParam(value="contextPath") String contextPath, @ProbeParam(value="servletPath") String servletPath) {
        if (hostName != null && hostName.equals(this.virtualServerName)) {
            this.individualData.get().setEntryTime(System.currentTimeMillis());
            this.countRequests.increment();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("[TM]requestStartEvent received - virtual-server = " + hostName + " : port = " + serverPort);
            }
        }
    }

    @ProbeListener(value="glassfish:web:http-service:requestEndEvent")
    public void requestEndEvent(@ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName, @ProbeParam(value="serverName") String serverName, @ProbeParam(value="serverPort") int serverPort, @ProbeParam(value="contextPath") String contextPath, @ProbeParam(value="servletPath") String servletPath, @ProbeParam(value="statusCode") int statusCode, @ProbeParam(value="method") String method, @ProbeParam(value="uri") String uri) {
        if (hostName != null && hostName.equals(this.virtualServerName)) {
            TimeStatData tsd = this.individualData.get();
            tsd.setExitTime(System.currentTimeMillis());
            this.requestProcessTime.incrementCount(tsd.getTotalTime());
            this.incrementStatsCounter(statusCode);
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("[TM]requestEndEvent received - virtual-server = " + hostName + ": application = " + contextPath + " : servlet = " + servletPath + " :Response code = " + statusCode + " :Response time = " + tsd.getTotalTime());
            }
        }
        this.method.setCurrent(method);
        this.uri.setCurrent(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ProbeListener(value="glassfish:kernel:connection-queue:connectionAcceptedEvent")
    public void connectionAcceptedEvent(@ProbeParam(value="listenerName") String listenerName, @ProbeParam(value="connection") int connectionId, @ProbeParam(value="address") String address) {
        block3: for (String listener : this.networkListeners) {
            long maxOpenConnectionsCount;
            if (!listener.equals(listenerName)) continue;
            this.countOpenConnections.increment();
            long openConnections = this.countOpenConnections.getCount();
            while (openConnections > (maxOpenConnectionsCount = this.maxOpenConnectionsAtomic.get())) {
                if (!this.maxOpenConnectionsAtomic.compareAndSet(maxOpenConnectionsCount, openConnections)) continue;
                AtomicLong atomicLong = this.maxOpenConnectionsAtomic;
                synchronized (atomicLong) {
                    this.maxOpenConnections.setCount(openConnections);
                    continue block3;
                }
            }
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("[TM]connectionAcceptedEvent received - virtual-server = " + listenerName);
        }
    }

    @ProbeListener(value="glassfish:kernel:connection-queue:connectionClosedEvent")
    public void connectionClosedEvent(@ProbeParam(value="listenerName") String listenerName, @ProbeParam(value="connection") int connectionId) {
        for (String listener : this.networkListeners) {
            if (!listener.equals(listenerName)) continue;
            this.countOpenConnections.decrement();
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("[TM]connectionClosedEvent received - virtual-server = " + listenerName);
        }
    }

    public long getProcessTime() {
        long count = this.requestProcessTime.getCount();
        long processTime = 0L;
        if (count != 0L) {
            processTime = this.requestProcessTime.getTotalTime() / count;
        }
        return processTime;
    }

    private void incrementStatsCounter(int statusCode) {
        switch (statusCode) {
            case 200: {
                this.count200.increment();
                break;
            }
            case 302: {
                this.count302.increment();
                break;
            }
            case 304: {
                this.count304.increment();
                break;
            }
            case 400: {
                this.count400.increment();
                break;
            }
            case 401: {
                this.count401.increment();
                break;
            }
            case 403: {
                this.count403.increment();
                break;
            }
            case 404: {
                this.count404.increment();
                break;
            }
            case 503: {
                this.count503.increment();
                break;
            }
        }
        if (200 <= statusCode && statusCode <= 299) {
            this.count2xx.increment();
        } else if (300 <= statusCode && statusCode <= 399) {
            this.count3xx.increment();
        } else if (400 <= statusCode && statusCode <= 499) {
            this.count4xx.increment();
        } else if (500 <= statusCode && statusCode <= 599) {
            this.count5xx.increment();
        } else {
            this.countOther.increment();
        }
        if (statusCode >= 400) {
            this.errorCount.increment();
        }
    }

    @Reset
    public void reset() {
        this.requestProcessTime.reset();
        this.count200.reset();
        this.count2xx.reset();
        this.count302.reset();
        this.count304.reset();
        this.count3xx.reset();
        this.count400.reset();
        this.count401.reset();
        this.count403.reset();
        this.count404.reset();
        this.count4xx.reset();
        this.count503.reset();
        this.count5xx.reset();
        this.countOther.reset();
        this.errorCount.reset();
        this.maxTime.reset();
        this.processingTime.reset();
        this.countBytesReceived.reset();
        this.countBytesTransmitted.reset();
        this.countOpenConnections.reset();
        this.countRequests.reset();
        this.maxOpenConnections.reset();
        this.method.reset();
        this.uri.reset();
    }
}

