/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.beans.PropertyVetoException;
import java.lang.annotation.Annotation;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.grizzly.config.dom.Protocol;
import org.glassfish.grizzly.config.dom.ProtocolChain;
import org.glassfish.grizzly.config.dom.ProtocolChainInstanceHandler;
import org.glassfish.grizzly.config.dom.ProtocolFilter;
import org.glassfish.grizzly.config.dom.Protocols;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.glassfish.web.admin.LogFacade;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="delete-protocol-filter")
@PerLookup
@I18n(value="delete.protocol.filter")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=Protocol.class, opType=RestEndpoint.OpType.DELETE, path="delete-protocol-filter", description="Delete", params={@RestParam(name="protocol", value="$parent")})})
public class DeleteProtocolFilter
implements AdminCommand {
    @Param(name="name", primary=true)
    String name;
    @Param(name="protocol", optional=false)
    String protocolName;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Inject
    @Named(value="default-instance-name")
    Config config;
    @Inject
    Domain domain;
    @Inject
    ServiceLocator services;
    private ActionReport report;
    private static final ResourceBundle rb = LogFacade.getLogger().getResourceBundle();

    @Override
    public void execute(AdminCommandContext context) {
        Target targetUtil = this.services.getService(Target.class, new Annotation[0]);
        Config newConfig = targetUtil.getConfig(this.target);
        if (newConfig != null) {
            this.config = newConfig;
        }
        this.report = context.getActionReport();
        try {
            Protocols protocols = this.config.getNetworkConfig().getProtocols();
            Protocol protocol = protocols.findProtocol(this.protocolName);
            this.validate(protocol, "AS-WEB-ADMIN-00013", this.protocolName);
            ProtocolChainInstanceHandler handler = this.getHandler(protocol);
            ProtocolChain chain = this.getChain(handler);
            ConfigSupport.apply(new SingleConfigCode<ProtocolChain>(){

                @Override
                public Object run(ProtocolChain param) throws PropertyVetoException, TransactionFailure {
                    List<ProtocolFilter> list = param.getProtocolFilter();
                    ArrayList<ProtocolFilter> newList = new ArrayList<ProtocolFilter>();
                    for (ProtocolFilter filter : list) {
                        if (DeleteProtocolFilter.this.name.equals(filter.getName())) continue;
                        newList.add(filter);
                    }
                    if (list.size() == newList.size()) {
                        throw new RuntimeException(String.format("No filter named %s found for protocol %s", DeleteProtocolFilter.this.name, DeleteProtocolFilter.this.protocolName));
                    }
                    param.setProtocolFilter(newList);
                    return null;
                }
            }, chain);
            this.cleanChain(chain);
            this.cleanHandler(handler);
        }
        catch (ValidationFailureException e) {
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.report.setMessage(MessageFormat.format(rb.getString("AS-WEB-ADMIN-00038"), this.name, e.getMessage() == null ? "No reason given" : e.getMessage()));
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            this.report.setFailureCause(e);
            return;
        }
    }

    private ProtocolChain getChain(ProtocolChainInstanceHandler handler) throws TransactionFailure {
        ProtocolChain chain = handler.getProtocolChain();
        if (chain == null && this.report != null) {
            this.report.setMessage(MessageFormat.format(rb.getString("AS-WEB-ADMIN-00039"), "protocol-chain", handler.getParent(Protocol.class).getName()));
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
        return chain;
    }

    private void cleanChain(ProtocolChain chain) throws TransactionFailure {
        if (chain != null && chain.getProtocolFilter().isEmpty()) {
            ConfigSupport.apply(new SingleConfigCode<ProtocolChainInstanceHandler>(){

                @Override
                public Object run(ProtocolChainInstanceHandler param) throws PropertyVetoException, TransactionFailure {
                    param.setProtocolChain(null);
                    return null;
                }
            }, chain.getParent(ProtocolChainInstanceHandler.class));
        }
    }

    private ProtocolChainInstanceHandler getHandler(Protocol protocol) throws TransactionFailure {
        ProtocolChainInstanceHandler handler = protocol.getProtocolChainInstanceHandler();
        if (handler == null && this.report != null) {
            this.report.setMessage(MessageFormat.format(rb.getString("AS-WEB-ADMIN-00039"), "protocol-chain-instance-handler", protocol.getName()));
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        }
        return handler;
    }

    private void cleanHandler(ProtocolChainInstanceHandler handler) throws TransactionFailure {
        if (handler != null && handler.getProtocolChain() == null) {
            ConfigSupport.apply(new SingleConfigCode<Protocol>(){

                @Override
                public Object run(Protocol param) throws PropertyVetoException, TransactionFailure {
                    param.setProtocolChainInstanceHandler(null);
                    return null;
                }
            }, handler.getParent(Protocol.class));
        }
    }

    private void validate(ConfigBeanProxy check, String key, String ... arguments) throws ValidationFailureException {
        if (check == null && this.report != null) {
            this.report.setMessage(MessageFormat.format(rb.getString(key), arguments));
            this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            throw new ValidationFailureException();
        }
    }

    private static class ValidationFailureException
    extends Exception {
        private ValidationFailureException() {
        }
    }
}

