/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.wasp.taglibs.standard.tlv;

import jakarta.servlet.jsp.tagext.PageData;
import jakarta.servlet.jsp.tagext.ValidationMessage;
import java.util.Set;
import java.util.Stack;
import org.glassfish.wasp.taglibs.standard.resources.Resources;
import org.glassfish.wasp.taglibs.standard.tlv.JstlBaseTLV;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class JstlSqlTLV
extends JstlBaseTLV {
    private final String SETDATASOURCE = "setDataSource";
    private final String QUERY = "query";
    private final String UPDATE = "update";
    private final String TRANSACTION = "transaction";
    private final String PARAM = "param";
    private final String DATEPARAM = "dateParam";
    private final String JSP_TEXT = "jsp:text";
    private final String SQL = "sql";
    private final String DATASOURCE = "dataSource";

    @Override
    public ValidationMessage[] validate(String prefix, String uri, PageData page) {
        return super.validate(3, prefix, uri, page);
    }

    @Override
    protected DefaultHandler getHandler() {
        return new Handler();
    }

    private class Handler
    extends DefaultHandler {
        private int depth = 0;
        private Stack<Integer> queryDepths = new Stack();
        private Stack<Integer> updateDepths = new Stack();
        private Stack<Integer> transactionDepths = new Stack();
        private String lastElementName = null;
        private boolean bodyNecessary = false;
        private boolean bodyIllegal = false;

        private Handler() {
        }

        @Override
        public void startElement(String nameSpace, String localName, String qualifiedName, Attributes attributes) {
            Set expAtts;
            if (localName == null) {
                localName = JstlSqlTLV.this.getLocalPart(qualifiedName);
            }
            if (qualifiedName.equals("jsp:text")) {
                return;
            }
            if (this.bodyIllegal) {
                JstlSqlTLV.this.fail(Resources.getMessage("TLV_ILLEGAL_BODY", this.lastElementName));
            }
            if (qualifiedName.startsWith(JstlSqlTLV.this.prefix + ":") && (expAtts = (Set)JstlSqlTLV.this.config.get(localName)) != null) {
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String vMsg;
                    String attName = attributes.getLocalName(i);
                    if (!expAtts.contains(attName) || (vMsg = JstlSqlTLV.this.validateExpression(localName, attName, attributes.getValue(i))) == null) continue;
                    JstlSqlTLV.this.fail(vMsg);
                }
            }
            if (qualifiedName.startsWith(JstlSqlTLV.this.prefix + ":") && !JstlSqlTLV.this.hasNoInvalidScope(attributes)) {
                JstlSqlTLV.this.fail(Resources.getMessage("TLV_INVALID_ATTRIBUTE", "scope", qualifiedName, attributes.getValue("scope")));
            }
            if (qualifiedName.startsWith(JstlSqlTLV.this.prefix + ":") && JstlSqlTLV.this.hasEmptyVar(attributes)) {
                JstlSqlTLV.this.fail(Resources.getMessage("TLV_EMPTY_VAR", qualifiedName));
            }
            if (qualifiedName.startsWith(JstlSqlTLV.this.prefix + ":") && JstlSqlTLV.this.hasDanglingScope(attributes) && !qualifiedName.startsWith(JstlSqlTLV.this.prefix + ":setDataSource")) {
                JstlSqlTLV.this.fail(Resources.getMessage("TLV_DANGLING_SCOPE", qualifiedName));
            }
            if ((JstlSqlTLV.this.isSqlTag(nameSpace, localName, "param") || JstlSqlTLV.this.isSqlTag(nameSpace, localName, "dateParam")) && this.queryDepths.empty() && this.updateDepths.empty()) {
                JstlSqlTLV.this.fail(Resources.getMessage("SQL_PARAM_OUTSIDE_PARENT"));
            }
            if (JstlSqlTLV.this.isSqlTag(nameSpace, localName, "query")) {
                this.queryDepths.push(this.depth);
            }
            if (JstlSqlTLV.this.isSqlTag(nameSpace, localName, "update")) {
                this.updateDepths.push(this.depth);
            }
            if (JstlSqlTLV.this.isSqlTag(nameSpace, localName, "transaction")) {
                this.transactionDepths.push(this.depth);
            }
            this.bodyIllegal = false;
            this.bodyNecessary = false;
            if (JstlSqlTLV.this.isSqlTag(nameSpace, localName, "query") || JstlSqlTLV.this.isSqlTag(nameSpace, localName, "update")) {
                if (!JstlSqlTLV.this.hasAttribute(attributes, "sql")) {
                    this.bodyNecessary = true;
                }
                if (JstlSqlTLV.this.hasAttribute(attributes, "dataSource") && !this.transactionDepths.empty()) {
                    JstlSqlTLV.this.fail(Resources.getMessage("ERROR_NESTED_DATASOURCE"));
                }
            }
            if (JstlSqlTLV.this.isSqlTag(nameSpace, localName, "dateParam")) {
                this.bodyIllegal = true;
            }
            this.lastElementName = qualifiedName;
            JstlSqlTLV.this.lastElementId = attributes.getValue("http://java.sun.com/JSP/Page", "id");
            ++this.depth;
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.bodyNecessary = false;
            String s = new String(ch, start, length).trim();
            if (s.equals("")) {
                return;
            }
            if (this.bodyIllegal) {
                JstlSqlTLV.this.fail(Resources.getMessage("TLV_ILLEGAL_BODY", this.lastElementName));
            }
        }

        @Override
        public void endElement(String ns, String ln, String qn) {
            if (qn.equals("jsp:text")) {
                return;
            }
            if (this.bodyNecessary) {
                JstlSqlTLV.this.fail(Resources.getMessage("TLV_MISSING_BODY", this.lastElementName));
            }
            this.bodyIllegal = false;
            if (JstlSqlTLV.this.isSqlTag(ns, ln, "query")) {
                this.queryDepths.pop();
            }
            if (JstlSqlTLV.this.isSqlTag(ns, ln, "update")) {
                this.updateDepths.pop();
            }
            if (JstlSqlTLV.this.isSqlTag(ns, ln, "transaction")) {
                this.transactionDepths.pop();
            }
            --this.depth;
        }
    }
}

