/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.wasp.runtime;

import jakarta.el.ELContext;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.jsp.JspContext;
import jakarta.servlet.jsp.JspWriter;
import jakarta.servlet.jsp.PageContext;
import jakarta.servlet.jsp.tagext.BodyContent;
import jakarta.servlet.jsp.tagext.JspTag;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.glassfish.wasp.compiler.Localizer;
import org.glassfish.wasp.runtime.ELContextImpl;
import org.glassfish.wasp.runtime.ELContextWrapper;
import org.glassfish.wasp.runtime.JspSourceDependent;
import org.glassfish.wasp.runtime.PageContextImpl;
import org.glassfish.wasp.runtime.VariableMapperImpl;

public class JspContextWrapper
extends PageContext {
    private JspTag jspTag;
    private PageContext invokingJspCtxt;
    private Hashtable<String, Object> pageAttributes;
    private List<String> nestedVars;
    private List<String> atBeginVars;
    private List<String> atEndVars;
    private Map<String, String> aliases;
    private Map<String, Object> originalNestedVars;
    private ELContext elContext;

    public JspContextWrapper(JspTag jspTag, JspContext jspContext, ArrayList<String> nestedVars, ArrayList<String> atBeginVars, ArrayList<String> atEndVars, Map<String, String> aliases) {
        this.jspTag = jspTag;
        this.invokingJspCtxt = (PageContext)jspContext;
        this.nestedVars = nestedVars;
        this.atBeginVars = atBeginVars;
        this.atEndVars = atEndVars;
        this.pageAttributes = new Hashtable(16);
        this.aliases = aliases;
        if (nestedVars != null) {
            this.originalNestedVars = new HashMap<String, Object>(nestedVars.size());
        }
        this.syncBeginTagFile();
    }

    @Override
    public void initialize(Servlet servlet, ServletRequest request, ServletResponse response, String errorPageURL, boolean needsSession, int bufferSize, boolean autoFlush) throws IOException, IllegalStateException, IllegalArgumentException {
    }

    @Override
    public Object getAttribute(String name) {
        if (name == null) {
            throw new NullPointerException(Localizer.getMessage("jsp.error.attribute.null_name"));
        }
        return this.pageAttributes.get(name);
    }

    @Override
    public Object getAttribute(String name, int scope) {
        if (name == null) {
            throw new NullPointerException(Localizer.getMessage("jsp.error.attribute.null_name"));
        }
        if (scope == 1) {
            return this.pageAttributes.get(name);
        }
        return this.invokingJspCtxt.getAttribute(name, scope);
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (name == null) {
            throw new NullPointerException(Localizer.getMessage("jsp.error.attribute.null_name"));
        }
        if (value != null) {
            this.pageAttributes.put(name, value);
        } else {
            this.removeAttribute(name, 1);
        }
    }

    @Override
    public void setAttribute(String name, Object value, int scope) {
        if (name == null) {
            throw new NullPointerException(Localizer.getMessage("jsp.error.attribute.null_name"));
        }
        if (scope == 1) {
            if (value != null) {
                this.pageAttributes.put(name, value);
            } else {
                this.removeAttribute(name, 1);
            }
        } else {
            this.invokingJspCtxt.setAttribute(name, value, scope);
        }
    }

    @Override
    public Object findAttribute(String name) {
        if (name == null) {
            throw new NullPointerException(Localizer.getMessage("jsp.error.attribute.null_name"));
        }
        Object attribute = this.pageAttributes.get(name);
        if (attribute == null && (attribute = this.invokingJspCtxt.getAttribute(name, 2)) == null) {
            if (this.getSession() != null) {
                attribute = this.invokingJspCtxt.getAttribute(name, 3);
            }
            if (attribute == null) {
                attribute = this.invokingJspCtxt.getAttribute(name, 4);
            }
        }
        return attribute;
    }

    @Override
    public void removeAttribute(String name) {
        if (name == null) {
            throw new NullPointerException(Localizer.getMessage("jsp.error.attribute.null_name"));
        }
        this.pageAttributes.remove(name);
        this.invokingJspCtxt.removeAttribute(name, 2);
        if (this.getSession() != null) {
            this.invokingJspCtxt.removeAttribute(name, 3);
        }
        this.invokingJspCtxt.removeAttribute(name, 4);
    }

    @Override
    public void removeAttribute(String name, int scope) {
        if (name == null) {
            throw new NullPointerException(Localizer.getMessage("jsp.error.attribute.null_name"));
        }
        if (scope == 1) {
            this.pageAttributes.remove(name);
        } else {
            this.invokingJspCtxt.removeAttribute(name, scope);
        }
    }

    @Override
    public int getAttributesScope(String name) {
        if (name == null) {
            throw new NullPointerException(Localizer.getMessage("jsp.error.attribute.null_name"));
        }
        if (this.pageAttributes.get(name) != null) {
            return 1;
        }
        return this.invokingJspCtxt.getAttributesScope(name);
    }

    @Override
    public Enumeration<String> getAttributeNamesInScope(int scope) {
        if (scope == 1) {
            return this.pageAttributes.keys();
        }
        return this.invokingJspCtxt.getAttributeNamesInScope(scope);
    }

    @Override
    public void release() {
        this.invokingJspCtxt.release();
    }

    @Override
    public JspWriter getOut() {
        return this.invokingJspCtxt.getOut();
    }

    @Override
    public HttpSession getSession() {
        return this.invokingJspCtxt.getSession();
    }

    @Override
    public Object getPage() {
        return this.invokingJspCtxt.getPage();
    }

    @Override
    public ServletRequest getRequest() {
        return this.invokingJspCtxt.getRequest();
    }

    @Override
    public ServletResponse getResponse() {
        return this.invokingJspCtxt.getResponse();
    }

    @Override
    public Exception getException() {
        return this.invokingJspCtxt.getException();
    }

    @Override
    public ServletConfig getServletConfig() {
        return this.invokingJspCtxt.getServletConfig();
    }

    @Override
    public ServletContext getServletContext() {
        return this.invokingJspCtxt.getServletContext();
    }

    public static PageContext getRootPageContext(PageContext pageContect) {
        while (pageContect instanceof JspContextWrapper) {
            pageContect = ((JspContextWrapper)pageContect).invokingJspCtxt;
        }
        return pageContect;
    }

    @Override
    public ELContext getELContext() {
        if (this.elContext == null) {
            ELContextImpl elContextImpl = (ELContextImpl)this.getRootPageContextImpl().getJspApplicationContext().createELContext(this.invokingJspCtxt.getELContext().getELResolver());
            elContextImpl.putContext(JspContext.class, this);
            elContextImpl.setVariableMapper(new VariableMapperImpl());
            this.elContext = new ELContextWrapper(elContextImpl, this.isErrorOnELNotFound());
        }
        return this.elContext;
    }

    public PageContextImpl getRootPageContextImpl() {
        PageContext pageContext = this.invokingJspCtxt;
        while (pageContext instanceof JspContextWrapper) {
            pageContext = ((JspContextWrapper)pageContext).invokingJspCtxt;
        }
        return (PageContextImpl)pageContext;
    }

    public boolean isErrorOnELNotFound() {
        if (this.jspTag instanceof JspSourceDependent) {
            return ((JspSourceDependent)((Object)this.jspTag)).getErrorOnELNotFound();
        }
        return false;
    }

    @Override
    public void forward(String relativeUrlPath) throws ServletException, IOException {
        this.invokingJspCtxt.forward(relativeUrlPath);
    }

    @Override
    public void include(String relativeUrlPath) throws ServletException, IOException {
        this.invokingJspCtxt.include(relativeUrlPath);
    }

    @Override
    public void include(String relativeUrlPath, boolean flush) throws ServletException, IOException {
        this.invokingJspCtxt.include(relativeUrlPath, flush);
    }

    @Override
    public BodyContent pushBody() {
        return this.invokingJspCtxt.pushBody();
    }

    @Override
    public JspWriter pushBody(Writer writer) {
        return this.invokingJspCtxt.pushBody(writer);
    }

    @Override
    public JspWriter popBody() {
        return this.invokingJspCtxt.popBody();
    }

    @Override
    public void handlePageException(Exception ex) throws IOException, ServletException {
        this.handlePageException((Throwable)ex);
    }

    @Override
    public void handlePageException(Throwable t) throws IOException, ServletException {
        this.invokingJspCtxt.handlePageException(t);
    }

    public void syncBeginTagFile() {
        this.saveNestedVariables();
    }

    public void syncBeforeInvoke() {
        this.copyTagToPageScope(0);
        this.copyTagToPageScope(1);
    }

    public void syncEndTagFile() {
        this.copyTagToPageScope(1);
        this.copyTagToPageScope(2);
        this.restoreNestedVariables();
    }

    private void copyTagToPageScope(int scope) {
        Iterator<String> iter = null;
        switch (scope) {
            case 0: {
                if (this.nestedVars == null) break;
                iter = this.nestedVars.iterator();
                break;
            }
            case 1: {
                if (this.atBeginVars == null) break;
                iter = this.atBeginVars.iterator();
                break;
            }
            case 2: {
                if (this.atEndVars == null) break;
                iter = this.atEndVars.iterator();
            }
        }
        while (iter != null && iter.hasNext()) {
            String varName = iter.next();
            Object attribute = this.getAttribute(varName);
            varName = this.findAlias(varName);
            if (attribute != null) {
                this.invokingJspCtxt.setAttribute(varName, attribute);
                continue;
            }
            this.invokingJspCtxt.removeAttribute(varName, 1);
        }
    }

    private void saveNestedVariables() {
        if (this.nestedVars != null) {
            for (String varName : this.nestedVars) {
                Object attribute = this.invokingJspCtxt.getAttribute(varName = this.findAlias(varName));
                if (attribute == null) continue;
                this.originalNestedVars.put(varName, attribute);
            }
        }
    }

    private void restoreNestedVariables() {
        if (this.nestedVars != null) {
            for (String varName : this.nestedVars) {
                Object nestedVar = this.originalNestedVars.get(varName = this.findAlias(varName));
                if (nestedVar != null) {
                    this.invokingJspCtxt.setAttribute(varName, nestedVar);
                    continue;
                }
                this.invokingJspCtxt.removeAttribute(varName, 1);
            }
        }
    }

    private String findAlias(String varName) {
        if (this.aliases == null) {
            return varName;
        }
        String alias = this.aliases.get(varName);
        if (alias == null) {
            return varName;
        }
        return alias;
    }
}

