/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.wasp.compiler;

import java.util.HashMap;
import java.util.Map;
import org.glassfish.wasp.WaspException;
import org.glassfish.wasp.compiler.ErrorDispatcher;
import org.glassfish.wasp.compiler.Node;

class BeanRepository {
    private Map<String, String> beanTypes;
    private ClassLoader loader;
    private ErrorDispatcher errDispatcher;

    public BeanRepository(ClassLoader loader, ErrorDispatcher err) {
        this.loader = loader;
        this.errDispatcher = err;
        this.beanTypes = new HashMap<String, String>();
    }

    public void addBean(Node.UseBean n, String s, String type2, String scope) throws WaspException {
        if (scope == null || scope.equals("page") || scope.equals("request") || scope.equals("session") || scope.equals("application")) {
            this.beanTypes.put(s, type2);
        } else {
            this.errDispatcher.jspError((Node)n, "jsp.error.invalid.scope", scope);
        }
    }

    public Class<?> getBeanType(String bean) throws WaspException {
        try {
            return this.loader.loadClass(this.beanTypes.get(bean));
        }
        catch (ClassNotFoundException ex) {
            throw new WaspException(ex);
        }
    }

    public boolean checkVariable(String bean) {
        return this.beanTypes.containsKey(bean);
    }
}

