/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.servlet;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Deque;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.tyrus.servlet.TyrusHttpUpgradeHandler;
import org.glassfish.tyrus.spi.CompletionHandler;
import org.glassfish.tyrus.spi.Writer;

class TyrusServletWriter
extends Writer
implements WriteListener {
    private final TyrusHttpUpgradeHandler tyrusHttpUpgradeHandler;
    private final Deque<QueuedFrame> queue = new LinkedList<QueuedFrame>();
    private static final Logger LOGGER = Logger.getLogger(TyrusServletWriter.class.getName());
    private ServletOutputStream servletOutputStream = null;
    private boolean isListenerSet;

    public TyrusServletWriter(TyrusHttpUpgradeHandler tyrusHttpUpgradeHandler) {
        this.tyrusHttpUpgradeHandler = tyrusHttpUpgradeHandler;
    }

    @Override
    public synchronized void onWritePossible() throws IOException {
        LOGGER.log(Level.FINEST, "OnWritePossible called");
        try {
            while (!this.queue.isEmpty() && this.servletOutputStream.isReady()) {
                QueuedFrame queuedFrame = this.queue.poll();
                assert (queuedFrame != null);
                this._write(queuedFrame.dataFrame, queuedFrame.completionHandler);
            }
        }
        catch (Exception e) {
            this.onError(e);
        }
    }

    @Override
    public synchronized void onError(Throwable t) {
        QueuedFrame queuedFrame;
        LOGGER.log(Level.WARNING, "TyrusServletWriter.onError", t);
        while ((queuedFrame = this.queue.poll()) != null) {
            queuedFrame.completionHandler.failed(t);
        }
    }

    @Override
    public synchronized void write(ByteBuffer buffer, CompletionHandler<ByteBuffer> completionHandler) {
        if (this.servletOutputStream == null) {
            try {
                this.servletOutputStream = this.tyrusHttpUpgradeHandler.getWebConnection().getOutputStream();
            }
            catch (IOException e) {
                LOGGER.log(Level.CONFIG, "ServletOutputStream cannot be obtained", e);
                completionHandler.failed(e);
                return;
            }
        }
        try {
            if (this.queue.isEmpty() && this.servletOutputStream.isReady()) {
                this._write(buffer, completionHandler);
            } else {
                QueuedFrame queuedFrame = new QueuedFrame(completionHandler, buffer);
                this.queue.offer(queuedFrame);
                if (!this.isListenerSet) {
                    this.isListenerSet = true;
                    this.servletOutputStream.setWriteListener(this);
                }
            }
        }
        catch (Exception e) {
            completionHandler.failed(e);
        }
    }

    private void _write(ByteBuffer buffer, CompletionHandler<ByteBuffer> completionHandler) {
        block5: {
            try {
                if (buffer.hasArray()) {
                    byte[] array = buffer.array();
                    this.servletOutputStream.write(array, buffer.arrayOffset() + buffer.position(), buffer.remaining());
                } else {
                    int remaining = buffer.remaining();
                    byte[] array = new byte[remaining];
                    buffer.get(array);
                    this.servletOutputStream.write(array);
                }
                this.servletOutputStream.flush();
                if (completionHandler != null) {
                    completionHandler.completed(buffer);
                }
            }
            catch (Exception e) {
                if (completionHandler == null) break block5;
                completionHandler.failed(e);
            }
        }
    }

    @Override
    public void close() {
        try {
            this.tyrusHttpUpgradeHandler.getWebConnection().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class QueuedFrame {
        public final CompletionHandler<ByteBuffer> completionHandler;
        public final ByteBuffer dataFrame;

        QueuedFrame(CompletionHandler<ByteBuffer> completionHandler, ByteBuffer dataFrame) {
            this.completionHandler = completionHandler;
            this.dataFrame = dataFrame;
        }
    }
}

