/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.servlet;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSessionEvent;
import jakarta.servlet.http.HttpSessionListener;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.glassfish.tyrus.core.TyrusUpgradeResponse;
import org.glassfish.tyrus.core.Utils;
import org.glassfish.tyrus.servlet.TyrusServletUpgrade;

class TyrusServletFilter
implements Filter,
HttpSessionListener {
    private TyrusServletUpgrade tyrusServletUpgrade;

    TyrusServletFilter(TyrusServletUpgrade tyrusServletUpgrade) {
        this.tyrusServletUpgrade = tyrusServletUpgrade;
    }

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        ServletContext servletContext = filterConfig.getServletContext();
        this.tyrusServletUpgrade.init(servletContext);
    }

    @Override
    public void sessionCreated(HttpSessionEvent se) {
    }

    @Override
    public void sessionDestroyed(HttpSessionEvent se) {
        this.tyrusServletUpgrade.destroySession(se.getSession());
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        boolean success = this.tyrusServletUpgrade.upgrade(httpServletRequest, httpServletResponse);
        if (!success && filterChain != null) {
            filterChain.doFilter(request, response);
        }
    }

    private static void appendTraceHeaders(HttpServletResponse httpServletResponse, TyrusUpgradeResponse tyrusUpgradeResponse) {
        for (Map.Entry<String, List<String>> entry : tyrusUpgradeResponse.getHeaders().entrySet()) {
            if (!entry.getKey().contains("X-Tyrus-Tracing-")) continue;
            httpServletResponse.addHeader(entry.getKey(), Utils.getHeaderFromList(entry.getValue()));
        }
    }

    @Override
    public void destroy() {
        this.tyrusServletUpgrade.destroy();
    }
}

