/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria.mechanisms.openid.controller;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jwt.JWTClaimsSet;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import jakarta.security.enterprise.identitystore.openid.IdentityToken;
import jakarta.security.enterprise.identitystore.openid.RefreshToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.Response;
import java.io.StringReader;
import java.util.Collections;
import java.util.Map;
import org.glassfish.soteria.mechanisms.openid.controller.AccessTokenClaimsSetVerifier;
import org.glassfish.soteria.mechanisms.openid.controller.IdTokenClaimsSetVerifier;
import org.glassfish.soteria.mechanisms.openid.controller.JWTValidator;
import org.glassfish.soteria.mechanisms.openid.controller.NonceController;
import org.glassfish.soteria.mechanisms.openid.controller.RefreshedIdTokenClaimsSetVerifier;
import org.glassfish.soteria.mechanisms.openid.domain.AccessTokenImpl;
import org.glassfish.soteria.mechanisms.openid.domain.IdentityTokenImpl;
import org.glassfish.soteria.mechanisms.openid.domain.OpenIdConfiguration;
import org.glassfish.soteria.mechanisms.openid.domain.OpenIdNonce;

@ApplicationScoped
public class TokenController {
    @Inject
    private NonceController nonceController;
    @Inject
    private OpenIdConfiguration configuration;
    @Inject
    private JWTValidator validator;

    public TokensResponse getTokens(HttpServletRequest request) {
        String authorizationCode = request.getParameter("code");
        Form form = new Form().param("client_id", this.configuration.getClientId()).param("client_secret", new String(this.configuration.getClientSecret())).param("grant_type", "authorization_code").param("code", authorizationCode).param("redirect_uri", this.configuration.buildRedirectURI(request));
        try (Client client = ClientBuilder.newClient();){
            WebTarget target = client.target(this.configuration.getProviderMetadata().getTokenEndpoint());
            Response response = target.request().accept("application/json").post(Entity.form(form));
            try {
                JsonObject tokensObject = this.readJsonObject(response.readEntity(String.class));
                TokensResponse tokensResponse = new TokensResponse(response.getStatus(), tokensObject);
                if (response != null) {
                    response.close();
                }
                return tokensResponse;
            }
            catch (Throwable throwable) {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JWTClaimsSet validateIdToken(IdentityTokenImpl idToken, HttpMessageContext httpContext) {
        JWTClaimsSet claimsSet;
        HttpServletRequest request = httpContext.getRequest();
        HttpServletResponse response = httpContext.getResponse();
        String expectedNonceHash = null;
        if (this.configuration.isUseNonce()) {
            OpenIdNonce expectedNonce = this.nonceController.get(this.configuration, request, response);
            expectedNonceHash = this.nonceController.getNonceHash(expectedNonce);
        }
        try {
            claimsSet = this.validator.validateBearerToken(idToken.getTokenJWT(), new IdTokenClaimsSetVerifier(expectedNonceHash, this.configuration));
        }
        finally {
            this.nonceController.remove(this.configuration, request, response);
        }
        return claimsSet;
    }

    public JWTClaimsSet validateRefreshedIdToken(IdentityToken previousIdToken, IdentityTokenImpl newIdToken) {
        return this.validator.validateBearerToken(newIdToken.getTokenJWT(), new RefreshedIdTokenClaimsSetVerifier(previousIdToken, this.configuration));
    }

    public Map<String, Object> validateAccessToken(AccessTokenImpl accessToken, Algorithm idTokenAlgorithm, Map<String, Object> idTokenClaims) {
        Map<String, Object> claims = Collections.emptyMap();
        AccessTokenClaimsSetVerifier jwtVerifier = new AccessTokenClaimsSetVerifier(accessToken, idTokenAlgorithm, idTokenClaims, this.configuration);
        jwtVerifier.validateAccessToken();
        return claims;
    }

    public TokensResponse refreshTokens(RefreshToken refreshToken) {
        Form form = new Form().param("client_id", this.configuration.getClientId()).param("client_secret", new String(this.configuration.getClientSecret())).param("grant_type", "refresh_token").param("refresh_token", refreshToken.getToken());
        try (Client client = ClientBuilder.newClient();){
            WebTarget target = client.target(this.configuration.getProviderMetadata().getTokenEndpoint());
            Response response = target.request().accept("application/json").post(Entity.form(form));
            try {
                JsonObject tokensObject = this.readJsonObject(response.readEntity(String.class));
                TokensResponse tokensResponse = new TokensResponse(response.getStatus(), tokensObject);
                if (response != null) {
                    response.close();
                }
                return tokensResponse;
            }
            catch (Throwable throwable) {
                if (response != null) {
                    try {
                        response.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    private JsonObject readJsonObject(String tokensBody) {
        try (JsonReader reader = Json.createReader(new StringReader(tokensBody));){
            JsonObject jsonObject = reader.readObject();
            return jsonObject;
        }
    }

    public static class TokensResponse {
        private final int status;
        private final JsonObject tokensObject;

        TokensResponse(int status, JsonObject tokensObject) {
            this.status = status;
            this.tokensObject = tokensObject;
        }

        public int getStatus() {
            return this.status;
        }

        public JsonObject getTokensObject() {
            return this.tokensObject;
        }
    }
}

