/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria.mechanisms.openid.controller;

import com.nimbusds.jose.util.Base64URL;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Objects;
import org.glassfish.soteria.Utils;
import org.glassfish.soteria.mechanisms.openid.domain.OpenIdConfiguration;
import org.glassfish.soteria.mechanisms.openid.domain.OpenIdNonce;
import org.glassfish.soteria.servlet.HttpStorageController;

@ApplicationScoped
public class NonceController {
    private static final String NONCE_KEY = "oidc.nonce";

    public void store(OpenIdNonce nonce, OpenIdConfiguration configuration, HttpServletRequest request, HttpServletResponse response) {
        HttpStorageController.getInstance(configuration, request, response).store(NONCE_KEY, nonce.getValue(), null);
    }

    public OpenIdNonce get(OpenIdConfiguration configuration, HttpServletRequest request, HttpServletResponse response) {
        return HttpStorageController.getInstance(configuration, request, response).getAsString(NONCE_KEY).filter(k -> !Utils.isEmpty(k)).map(OpenIdNonce::new).orElse(null);
    }

    public void remove(OpenIdConfiguration configuration, HttpServletRequest request, HttpServletResponse response) {
        HttpStorageController.getInstance(configuration, request, response).remove(NONCE_KEY);
    }

    public String getNonceHash(OpenIdNonce nonce) {
        String nonceHash;
        Objects.requireNonNull(nonce, "OpenId nonce value must not be null");
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(nonce.getValue().getBytes(StandardCharsets.US_ASCII));
            byte[] hash = md.digest();
            nonceHash = Base64URL.encode(hash).toString();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalStateException("No MessageDigest instance found with the specified algorithm for nonce hash", ex);
        }
        return nonceHash;
    }
}

