/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria.mechanisms.openid.controller;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.proc.BadJWTException;
import jakarta.security.enterprise.identitystore.openid.AccessToken;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Map;
import org.glassfish.soteria.mechanisms.openid.controller.TokenClaimsSetVerifier;
import org.glassfish.soteria.mechanisms.openid.domain.OpenIdConfiguration;

public class AccessTokenClaimsSetVerifier
extends TokenClaimsSetVerifier {
    private final AccessToken accessToken;
    private final Algorithm idTokenAlgorithm;
    private final Map<String, Object> idTokenClaims;

    public AccessTokenClaimsSetVerifier(AccessToken accessToken, Algorithm idTokenAlgorithm, Map<String, Object> idTokenClaims, OpenIdConfiguration configuration) {
        super(configuration);
        this.accessToken = accessToken;
        this.idTokenAlgorithm = idTokenAlgorithm;
        this.idTokenClaims = idTokenClaims;
    }

    @Override
    public void verify(JWTClaimsSet claims) throws BadJWTException {
        this.validateAccessToken();
    }

    public void validateAccessToken() {
        if (this.idTokenClaims.containsKey("at_hash")) {
            MessageDigest md = this.getMessageDigest(this.idTokenAlgorithm);
            md.update(this.accessToken.toString().getBytes(StandardCharsets.US_ASCII));
            byte[] hash = md.digest();
            byte[] leftHalf = Arrays.copyOf(hash, hash.length / 2);
            String accessTokenHash = Base64URL.encode(leftHalf).toString();
            if (!this.idTokenClaims.get("at_hash").equals(accessTokenHash)) {
                throw new IllegalStateException("Invalid access token hash (at_hash) value");
            }
        }
    }

    private MessageDigest getMessageDigest(Algorithm algorithm) {
        String mdAlgorithm = "SHA-" + algorithm.getName().substring(2);
        try {
            return MessageDigest.getInstance(mdAlgorithm);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalStateException("No MessageDigest instance found with the specified algorithm : " + mdAlgorithm, ex);
        }
    }
}

