/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria.mechanisms.jaspic;

import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.AuthStatus;
import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.MessagePolicy;
import jakarta.security.auth.message.module.ServerAuthModule;
import jakarta.security.enterprise.AuthenticationException;
import jakarta.security.enterprise.AuthenticationStatus;
import jakarta.security.enterprise.authentication.mechanism.http.HttpAuthenticationMechanismHandler;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.annotation.Annotation;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import org.glassfish.soteria.cdi.CdiUtils;
import org.glassfish.soteria.cdi.spi.CDIPerRequestInitializer;
import org.glassfish.soteria.mechanisms.HttpMessageContextImpl;
import org.glassfish.soteria.mechanisms.jaspic.Jaspic;

public class HttpBridgeServerAuthModule
implements ServerAuthModule {
    private CallbackHandler handler;
    private final Class<?>[] supportedMessageTypes = new Class[]{HttpServletRequest.class, HttpServletResponse.class};
    private final CDIPerRequestInitializer cdiPerRequestInitializer;

    public HttpBridgeServerAuthModule(CDIPerRequestInitializer cdiPerRequestInitializer) {
        this.cdiPerRequestInitializer = cdiPerRequestInitializer;
    }

    public void initialize(MessagePolicy requestPolicy, MessagePolicy responsePolicy, CallbackHandler handler, Map options) throws AuthException {
        this.handler = handler;
    }

    @Override
    public Class<?>[] getSupportedMessageTypes() {
        return this.supportedMessageTypes;
    }

    @Override
    public AuthStatus validateRequest(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
        HttpMessageContextImpl msgContext = new HttpMessageContextImpl(this.handler, messageInfo, clientSubject);
        if (this.cdiPerRequestInitializer != null) {
            this.cdiPerRequestInitializer.init(msgContext.getRequest());
        }
        AuthenticationStatus status = AuthenticationStatus.NOT_DONE;
        Jaspic.setLastAuthenticationStatus(msgContext.getRequest(), status);
        try {
            status = CdiUtils.getBeanReference(HttpAuthenticationMechanismHandler.class, new Annotation[0]).validateRequest(msgContext.getRequest(), msgContext.getResponse(), msgContext);
        }
        catch (AuthenticationException e) {
            Jaspic.setLastAuthenticationStatus(msgContext.getRequest(), AuthenticationStatus.SEND_FAILURE);
            throw (AuthException)new AuthException("Authentication failure in HttpAuthenticationMechanism").initCause(e);
        }
        Jaspic.setLastAuthenticationStatus(msgContext.getRequest(), status);
        return Jaspic.fromAuthenticationStatus(status);
    }

    @Override
    public AuthStatus secureResponse(MessageInfo messageInfo, Subject serviceSubject) throws AuthException {
        HttpMessageContextImpl msgContext = new HttpMessageContextImpl(this.handler, messageInfo, null);
        try {
            AuthenticationStatus status = CdiUtils.getBeanReference(HttpAuthenticationMechanismHandler.class, new Annotation[0]).secureResponse(msgContext.getRequest(), msgContext.getResponse(), msgContext);
            AuthStatus authStatus = Jaspic.fromAuthenticationStatus(status);
            if (authStatus == AuthStatus.SUCCESS) {
                AuthStatus authStatus2 = AuthStatus.SEND_SUCCESS;
                return authStatus2;
            }
            AuthStatus authStatus3 = authStatus;
            return authStatus3;
        }
        catch (AuthenticationException e) {
            throw (AuthException)new AuthException("Secure response failure in HttpAuthenticationMechanism").initCause(e);
        }
        finally {
            if (this.cdiPerRequestInitializer != null) {
                this.cdiPerRequestInitializer.destroy(msgContext.getRequest());
            }
        }
    }

    @Override
    public void cleanSubject(MessageInfo messageInfo, Subject subject) throws AuthException {
        HttpMessageContextImpl msgContext = new HttpMessageContextImpl(this.handler, messageInfo, subject);
        CdiUtils.getBeanReference(HttpAuthenticationMechanismHandler.class, new Annotation[0]).cleanSubject(msgContext.getRequest(), msgContext.getResponse(), msgContext);
    }
}

