/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria.mechanisms;

import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Typed;
import jakarta.inject.Inject;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.security.auth.message.callback.CallerPrincipalCallback;
import jakarta.security.enterprise.AuthenticationException;
import jakarta.security.enterprise.AuthenticationStatus;
import jakarta.security.enterprise.authentication.mechanism.http.HttpAuthenticationMechanism;
import jakarta.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import jakarta.security.enterprise.identitystore.CredentialValidationResult;
import jakarta.security.enterprise.identitystore.IdentityStoreHandler;
import jakarta.security.enterprise.identitystore.openid.RefreshToken;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.glassfish.soteria.Utils;
import org.glassfish.soteria.mechanisms.openid.OpenIdCredential;
import org.glassfish.soteria.mechanisms.openid.OpenIdState;
import org.glassfish.soteria.mechanisms.openid.controller.AuthenticationController;
import org.glassfish.soteria.mechanisms.openid.controller.StateController;
import org.glassfish.soteria.mechanisms.openid.controller.TokenController;
import org.glassfish.soteria.mechanisms.openid.domain.LogoutConfiguration;
import org.glassfish.soteria.mechanisms.openid.domain.OpenIdConfiguration;
import org.glassfish.soteria.mechanisms.openid.domain.OpenIdContextImpl;
import org.glassfish.soteria.mechanisms.openid.domain.RefreshTokenImpl;
import org.glassfish.soteria.servlet.HttpServletRequestDelegator;
import org.glassfish.soteria.servlet.HttpStorageController;
import org.glassfish.soteria.servlet.RequestData;

@ApplicationScoped
@Typed(value={OpenIdAuthenticationMechanism.class})
public class OpenIdAuthenticationMechanism
implements HttpAuthenticationMechanism {
    private static final Logger LOGGER = Logger.getLogger(OpenIdAuthenticationMechanism.class.getName());
    public static final String ORIGINAL_REQUEST_DATA_JSON = "org.glassfish.soteria.original.request.json";
    private static final String SESSION_LOCK_NAME = OpenIdAuthenticationMechanism.class.getName();
    @Inject
    private OpenIdConfiguration configuration;
    @Inject
    private OpenIdContextImpl context;
    private IdentityStoreHandler identityStoreHandler;
    @Inject
    private AuthenticationController authenticationController;
    @Inject
    private TokenController tokenController;
    @Inject
    private StateController stateController;
    @Inject
    Instance<IdentityStoreHandler> storeHandlerInstance;

    @PostConstruct
    void init() {
        if (this.storeHandlerInstance.isResolvable()) {
            this.identityStoreHandler = (IdentityStoreHandler)this.storeHandlerInstance.get();
            return;
        }
        throw new IllegalStateException("Cannot get instance of IdentityStoreHandler\n@Inject IdentityStoreHandler is unsatisfied.");
    }

    @Override
    public AuthenticationStatus validateRequest(HttpServletRequest request, HttpServletResponse response, HttpMessageContext httpContext) throws AuthenticationException {
        if (Objects.isNull(request.getUserPrincipal())) {
            LOGGER.fine("UserPrincipal is not set, authenticate user using OpenId Connect protocol.");
            return this.authenticate(request, response, httpContext);
        }
        try {
            httpContext.getHandler().handle(new Callback[]{new CallerPrincipalCallback(httpContext.getClientSubject(), request.getUserPrincipal())});
        }
        catch (IOException | UnsupportedCallbackException ex) {
            throw new AuthenticationException("Failed to register CallerPrincipalCallback.", ex);
        }
        boolean accessTokenExpired = this.context.getAccessToken().isExpired();
        boolean identityTokenExpired = this.context.getIdentityToken().isExpired();
        if ((accessTokenExpired || identityTokenExpired) && this.configuration.isTokenAutoRefresh()) {
            if (accessTokenExpired) {
                LOGGER.fine("Access Token is expired. Request new Access Token with Refresh Token.");
            }
            if (identityTokenExpired) {
                LOGGER.fine("Identity Token is expired. Request new Identity Token with Refresh Token.");
            }
            return this.reAuthenticate(httpContext);
        }
        LogoutConfiguration logout = this.configuration.getLogoutConfiguration();
        if (logout.isIdentityTokenExpiry()) {
            LOGGER.log(Level.FINE, "UserPrincipal is set, check if Identity Token is valid.");
        }
        if (logout.isAccessTokenExpiry()) {
            LOGGER.log(Level.FINE, "UserPrincipal is set, check if Access Token is valid.");
        }
        if (logout.isAccessTokenExpiry() && accessTokenExpired || logout.isIdentityTokenExpiry() && identityTokenExpired) {
            this.logout(request, response);
            return AuthenticationStatus.SEND_FAILURE;
        }
        return AuthenticationStatus.SUCCESS;
    }

    @Override
    public void cleanSubject(HttpServletRequest request, HttpServletResponse response, HttpMessageContext httpMessageContext) {
        this.logout(request, response);
    }

    private AuthenticationStatus authenticate(HttpServletRequest request, HttpServletResponse response, HttpMessageContext httpContext) {
        Optional<OpenIdState> receivedState = OpenIdState.from(request.getParameter("state"));
        if (receivedState.isEmpty() && httpContext.isProtected() && Objects.isNull(request.getUserPrincipal())) {
            return this.authenticationController.authenticateUser(request, response);
        }
        if (!"GET".equalsIgnoreCase(request.getMethod())) {
            return httpContext.doNothing();
        }
        if (request.getParameter("code") == null) {
            return httpContext.doNothing();
        }
        if (receivedState.isPresent()) {
            Optional<OpenIdState> expectedState;
            String callbackUrl = this.configuration.buildRedirectURI(request);
            String orginalUrl = this.getOriginalUrl(request, response);
            String requestUrl = request.getRequestURL().toString();
            if (this.configuration.isRedirectToOriginalResource()) {
                if (!Utils.isOneOf(requestUrl, orginalUrl, callbackUrl)) {
                    LOGGER.log(Level.INFO, "OpenID request URL {0} not matched with either callback {1} or original URL {2}", new Object[]{requestUrl, callbackUrl, orginalUrl});
                    return httpContext.notifyContainerAboutLogin(CredentialValidationResult.NOT_VALIDATED_RESULT);
                }
            } else if (!Utils.isOneOf(requestUrl, callbackUrl)) {
                LOGGER.log(Level.INFO, "OpenID request URL {0} not matched with callback URL {1}", new Object[]{requestUrl, callbackUrl, orginalUrl});
                return httpContext.notifyContainerAboutLogin(CredentialValidationResult.NOT_VALIDATED_RESULT);
            }
            if (!(expectedState = this.stateController.get(request, response)).isPresent()) {
                LOGGER.fine("Expected state not found");
                return httpContext.notifyContainerAboutLogin(CredentialValidationResult.NOT_VALIDATED_RESULT);
            }
            if (!expectedState.equals(receivedState)) {
                LOGGER.fine("Inconsistent received state, value not matched");
                return httpContext.notifyContainerAboutLogin(CredentialValidationResult.INVALID_RESULT);
            }
            if (this.configuration.isRedirectToOriginalResource() && !this.isOnOriginalURL(request, response)) {
                return httpContext.redirect(this.getOriginalRedirectUrl(request, response));
            }
            return this.validateAuthorizationCode(httpContext);
        }
        return httpContext.doNothing();
    }

    private boolean isOnOriginalURL(HttpServletRequest request, HttpServletResponse response) {
        Optional<String> optionalOrginalUrl = HttpStorageController.getInstance(this.configuration, request, response).getAsString("oidc.original.request");
        if (optionalOrginalUrl.isEmpty()) {
            return true;
        }
        String originalUrl = optionalOrginalUrl.get();
        if (originalUrl.contains("?")) {
            originalUrl = originalUrl.substring(0, originalUrl.indexOf(63));
        }
        return request.getRequestURL().toString().equals(originalUrl);
    }

    private String getOriginalRedirectUrl(HttpServletRequest request, HttpServletResponse response) {
        return this.getOriginalUrl(request, response) + "?" + request.getQueryString();
    }

    private String getOriginalUrl(HttpServletRequest request, HttpServletResponse response) {
        String originalUrl = HttpStorageController.getInstance(this.configuration, request, response).getAsString("oidc.original.request").get();
        if (originalUrl.contains("?")) {
            originalUrl = originalUrl.substring(0, originalUrl.indexOf(63));
        }
        return originalUrl;
    }

    private RequestData getRequestData(HttpServletRequest request, HttpServletResponse response) {
        String requestJson = HttpStorageController.getInstance(this.configuration, request, response).getAsString(ORIGINAL_REQUEST_DATA_JSON).get();
        return RequestData.of(requestJson);
    }

    private AuthenticationStatus validateAuthorizationCode(HttpMessageContext httpContext) {
        HttpServletRequest request = httpContext.getRequest();
        HttpServletResponse response = httpContext.getResponse();
        String error = request.getParameter("error");
        String errorDescription = request.getParameter("error_description");
        if (!Utils.isEmpty(error)) {
            LOGGER.log(Level.WARNING, "Error occurred in receiving Authorization Code : {0} caused by {1}", new Object[]{error, errorDescription});
            return httpContext.notifyContainerAboutLogin(CredentialValidationResult.INVALID_RESULT);
        }
        this.stateController.remove(request, response);
        LOGGER.finer("Authorization Code received, now fetching Access token & Id token");
        TokenController.TokensResponse tokensResponse = this.tokenController.getTokens(request);
        JsonObject tokensObject = tokensResponse.getTokensObject();
        if (tokensResponse.getStatus() == Response.Status.OK.getStatusCode()) {
            this.updateContext(tokensObject);
            OpenIdCredential credential = new OpenIdCredential(tokensObject, httpContext, this.configuration.getTokenMinValidity());
            CredentialValidationResult validationResult = this.identityStoreHandler.validate(credential);
            httpContext.setRegisterSession(validationResult.getCallerPrincipal().getName(), validationResult.getCallerGroups());
            if (this.configuration.isRedirectToOriginalResource()) {
                httpContext.withRequest(new HttpServletRequestDelegator(request, this.getRequestData(request, response)));
            }
            return httpContext.notifyContainerAboutLogin(validationResult);
        }
        LOGGER.log(Level.WARNING, "Error occurred in validating Authorization Code : {0} caused by {1}", new Object[]{tokensObject.getString("error", "Unknown Error"), tokensObject.getString("error_description", "Unknown")});
        return httpContext.notifyContainerAboutLogin(CredentialValidationResult.INVALID_RESULT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuthenticationStatus reAuthenticate(HttpMessageContext httpContext) throws AuthenticationException {
        HttpServletRequest request = httpContext.getRequest();
        HttpServletResponse response = httpContext.getResponse();
        Object object = this.getSessionLock(httpContext.getRequest());
        synchronized (object) {
            boolean accessTokenExpired = this.context.getAccessToken().isExpired();
            boolean identityTokenExpired = this.context.getIdentityToken().isExpired();
            if (accessTokenExpired || identityTokenExpired) {
                AuthenticationStatus refreshStatus;
                if (accessTokenExpired) {
                    LOGGER.fine("Access Token is expired. Request new Access Token with Refresh Token.");
                }
                if (identityTokenExpired) {
                    LOGGER.fine("Identity Token is expired. Request new Identity Token with Refresh Token.");
                }
                if ((refreshStatus = this.context.getRefreshToken().map(rt -> this.refreshTokens(httpContext, (RefreshToken)rt)).orElse(AuthenticationStatus.SEND_FAILURE)) != AuthenticationStatus.SUCCESS) {
                    LOGGER.log(Level.FINE, "Failed to refresh token (Refresh Token might be invalid).");
                    this.logout(request, response);
                }
                return refreshStatus;
            }
        }
        return AuthenticationStatus.SUCCESS;
    }

    private AuthenticationStatus refreshTokens(HttpMessageContext httpContext, RefreshToken refreshToken) {
        TokenController.TokensResponse response = this.tokenController.refreshTokens(refreshToken);
        JsonObject tokensObject = response.getTokensObject();
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            this.updateContext(tokensObject);
            OpenIdCredential credential = new OpenIdCredential(tokensObject, httpContext, this.configuration.getTokenMinValidity());
            CredentialValidationResult validationResult = this.identityStoreHandler.validate(credential);
            return httpContext.notifyContainerAboutLogin(validationResult);
        }
        String error = tokensObject.getString("error", "Unknown Error");
        String errorDescription = tokensObject.getString("error_description", "Unknown");
        LOGGER.log(Level.FINE, "Error occurred in refreshing Access Token and Refresh Token : {0} caused by {1}", new Object[]{error, errorDescription});
        return AuthenticationStatus.SEND_FAILURE;
    }

    private void logout(HttpServletRequest request, HttpServletResponse response) {
        LogoutConfiguration logout = this.configuration.getLogoutConfiguration();
        if (logout == null) {
            LOGGER.log(Level.WARNING, "Logout invoked on session without OpenID session");
            OpenIdAuthenticationMechanism.redirect(response, request.getContextPath());
            return;
        }
        HttpSession session = request.getSession(false);
        if (session != null) {
            session.invalidate();
        }
        if (logout.isNotifyProvider() && !Utils.isEmpty(this.configuration.getProviderMetadata().getEndSessionEndpoint())) {
            UriBuilder logoutURI = UriBuilder.fromUri(this.configuration.getProviderMetadata().getEndSessionEndpoint()).queryParam("id_token_hint", this.context.getIdentityToken().getToken());
            if (!Utils.isEmpty(logout.getRedirectURI())) {
                logoutURI.queryParam("post_logout_redirect_uri", logout.buildRedirectURI(request));
            }
            OpenIdAuthenticationMechanism.redirect(response, logoutURI.toString());
        } else if (!Utils.isEmpty(logout.getRedirectURI())) {
            OpenIdAuthenticationMechanism.redirect(response, logout.buildRedirectURI(request));
        } else {
            this.authenticationController.authenticateUser(request, response);
        }
    }

    private static void redirect(HttpServletResponse response, String uri) {
        try {
            response.sendRedirect(uri);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private void updateContext(JsonObject tokensObject) {
        JsonNumber expiresIn;
        this.context.setTokenType(tokensObject.getString("token_type", null));
        String refreshToken = tokensObject.getString("refresh_token", null);
        if (Objects.nonNull(refreshToken)) {
            this.context.setRefreshToken(new RefreshTokenImpl(refreshToken));
        }
        if (Objects.nonNull(expiresIn = tokensObject.getJsonNumber("expires_in"))) {
            this.context.setExpiresIn(expiresIn.longValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object getSessionLock(HttpServletRequest request) {
        HttpSession session = request.getSession();
        Object lock = session.getAttribute(SESSION_LOCK_NAME);
        if (!Objects.isNull(lock)) return lock;
        Class<OpenIdAuthenticationMechanism> clazz = OpenIdAuthenticationMechanism.class;
        synchronized (OpenIdAuthenticationMechanism.class) {
            lock = session.getAttribute(SESSION_LOCK_NAME);
            if (!Objects.isNull(lock)) return lock;
            lock = new Lock();
            session.setAttribute(SESSION_LOCK_NAME, lock);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return lock;
        }
    }

    private static class Lock
    implements Serializable {
        private static final long serialVersionUID = 1L;

        private Lock() {
        }
    }
}

