/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria.mechanisms;

import jakarta.enterprise.inject.Typed;
import jakarta.security.enterprise.AuthenticationException;
import jakarta.security.enterprise.AuthenticationStatus;
import jakarta.security.enterprise.authentication.mechanism.http.AutoApplySession;
import jakarta.security.enterprise.authentication.mechanism.http.HttpAuthenticationMechanism;
import jakarta.security.enterprise.authentication.mechanism.http.HttpMessageContext;
import jakarta.security.enterprise.authentication.mechanism.http.LoginToContinue;
import jakarta.security.enterprise.credential.Password;
import jakarta.security.enterprise.credential.UsernamePasswordCredential;
import jakarta.security.enterprise.identitystore.IdentityStoreHandler;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.annotation.Annotation;
import org.glassfish.soteria.Utils;
import org.glassfish.soteria.cdi.CdiUtils;
import org.glassfish.soteria.mechanisms.LoginToContinueHolder;

@AutoApplySession
@LoginToContinue
@Typed(value={FormAuthenticationMechanism.class})
public class FormAuthenticationMechanism
implements HttpAuthenticationMechanism,
LoginToContinueHolder {
    private LoginToContinue loginToContinue;

    @Override
    public AuthenticationStatus validateRequest(HttpServletRequest request, HttpServletResponse response, HttpMessageContext httpMessageContext) throws AuthenticationException {
        if (FormAuthenticationMechanism.isValidFormPostback(request)) {
            IdentityStoreHandler identityStoreHandler = CdiUtils.getBeanReference(IdentityStoreHandler.class, new Annotation[0]);
            return httpMessageContext.notifyContainerAboutLogin(identityStoreHandler.validate(new UsernamePasswordCredential(request.getParameter("j_username"), new Password(request.getParameter("j_password")))));
        }
        return httpMessageContext.doNothing();
    }

    private static boolean isValidFormPostback(HttpServletRequest request) {
        return "POST".equals(request.getMethod()) && request.getRequestURI().endsWith("/j_security_check") && Utils.notNull(request.getParameter("j_username"), request.getParameter("j_password"));
    }

    @Override
    public LoginToContinue getLoginToContinue() {
        return this.loginToContinue;
    }

    public void setLoginToContinue(LoginToContinue loginToContinue) {
        this.loginToContinue = loginToContinue;
    }
}

