/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.soteria.identitystores;

import jakarta.security.enterprise.CallerPrincipal;
import jakarta.security.enterprise.credential.Credential;
import jakarta.security.enterprise.credential.UsernamePasswordCredential;
import jakarta.security.enterprise.identitystore.CredentialValidationResult;
import jakarta.security.enterprise.identitystore.IdentityStore;
import jakarta.security.enterprise.identitystore.InMemoryIdentityStoreDefinition;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class InMemoryIdentityStore
implements IdentityStore {
    private final InMemoryIdentityStoreDefinition embeddedIdentityStoreDefinition;
    private final Map<String, InMemoryIdentityStoreDefinition.Credentials> callerToCredentials;
    private final Set<IdentityStore.ValidationType> validationType;

    protected InMemoryIdentityStore() {
        this.embeddedIdentityStoreDefinition = null;
        this.callerToCredentials = null;
        this.validationType = null;
    }

    public InMemoryIdentityStore(InMemoryIdentityStoreDefinition embeddedIdentityStoreDefinition) {
        this.embeddedIdentityStoreDefinition = embeddedIdentityStoreDefinition;
        this.callerToCredentials = Arrays.stream(embeddedIdentityStoreDefinition.value()).collect(Collectors.toMap(e -> e.callerName(), e -> e));
        this.validationType = Collections.unmodifiableSet(new HashSet<IdentityStore.ValidationType>(Arrays.asList(embeddedIdentityStoreDefinition.useFor())));
    }

    @Override
    public CredentialValidationResult validate(Credential credential) {
        if (credential instanceof UsernamePasswordCredential) {
            return this.validate((UsernamePasswordCredential)credential);
        }
        return CredentialValidationResult.NOT_VALIDATED_RESULT;
    }

    public CredentialValidationResult validate(UsernamePasswordCredential usernamePasswordCredential) {
        InMemoryIdentityStoreDefinition.Credentials credentials = this.callerToCredentials.get(usernamePasswordCredential.getCaller());
        if (credentials != null && usernamePasswordCredential.getPassword().compareTo(credentials.password())) {
            return new CredentialValidationResult(new CallerPrincipal(credentials.callerName()), new HashSet<String>(Arrays.asList(credentials.groups())));
        }
        return CredentialValidationResult.INVALID_RESULT;
    }

    @Override
    public Set<String> getCallerGroups(CredentialValidationResult validationResult) {
        InMemoryIdentityStoreDefinition.Credentials credentials = this.callerToCredentials.get(validationResult.getCallerPrincipal().getName());
        return credentials != null ? new HashSet<String>(Arrays.asList(credentials.groups())) : Collections.emptySet();
    }

    @Override
    public int priority() {
        return this.embeddedIdentityStoreDefinition.priority();
    }

    @Override
    public Set<IdentityStore.ValidationType> validationTypes() {
        return this.validationType;
    }
}

