/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.security.services.impl;

import jakarta.inject.Singleton;
import java.security.Principal;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.glassfish.security.common.Group;
import org.glassfish.security.common.UserNameAndPassword;
import org.glassfish.security.services.api.authentication.ImpersonationService;
import org.jvnet.hk2.annotations.Service;

@Service(name="impersonationService")
@Singleton
public class ImpersonationServiceImpl
implements ImpersonationService {
    @Override
    public Subject impersonate(String user, String[] groups, Subject subject, boolean virtual) throws LoginException {
        Subject _subject;
        Subject subject2 = _subject = subject == null ? new Subject() : subject;
        if (user == null || user.isEmpty()) {
            return _subject;
        }
        if (!virtual) {
            throw new UnsupportedOperationException("Use of non-virtual parameter is not supported");
        }
        Set<Principal> principals = _subject.getPrincipals();
        principals.add(new UserNameAndPassword(user));
        if (groups != null) {
            for (String group : groups) {
                principals.add(new Group(group));
            }
        }
        return _subject;
    }
}

