/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.security.services.config;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.security.auth.login.FileLoginModule;
import jakarta.inject.Inject;
import java.beans.PropertyVetoException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.admin.config.ConfigurationUpgrade;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.security.services.config.AuthenticationService;
import org.glassfish.security.services.config.AuthorizationService;
import org.glassfish.security.services.config.LoginModuleConfig;
import org.glassfish.security.services.config.SecurityConfigurations;
import org.glassfish.security.services.config.SecurityProvider;
import org.glassfish.security.services.provider.authorization.AuthorizationProviderConfig;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.Transaction;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service
@PerLookup
public class SecurityConfigUpgradeService
implements ConfigurationUpgrade,
PostConstruct {
    private static final String AUTHENTICATION_SERVICE_NAME = "adminAuth";
    private static final String FILE_REALM_PROVIDER_NAME = "filerealm";
    private static final String FILE_REALM_PROVIDER_PROVIDER_NAME = "adminFile";
    private static final String FILE_LOGIN_MODULE_NAME = "adminFileLM";
    private static final String FILE_LOGIN_MODULE_CLASS = FileLoginModule.class.getName();
    private static final String ADM_REALM_PROVIDER_NAME = "spcrealm";
    private static final String ADM_REALM_PROVIDER_PROVIDER_NAME = "adminSpc";
    private static final String ADM_LOGIN_MODULE_NAME = "adminSpecialLM";
    private static final String ADM_LOGIN_MODULE_CLASS = "com.sun.enterprise.admin.util.AdminLoginModule";
    private static final String LOGIN_MODULE_TYPE_NAME = "LoginModule";
    private static final String AUTHORIZATION_SERVICE_NAME = "authorizationService";
    private static final String SIMPLE_PROVIDER_PROVIDER_NAME = "simpleAuthorizationProvider";
    private static final String SIMPLE_PROVIDER_NAME = "simpleAuthorization";
    private static final String SIMPLE_PROVIDER_TYPE = "simple";
    private static final String SIMPLE_PROVIDER_CONFIG_NAME = "simpleAuthorizationProviderConfig";
    private static final String SIMPLE_PROVIDER_CLASS_NAME = "org.glassfish.security.services.provider.authorization.SimpleAuthorizationProviderImpl";
    private static final String SUPPORT_POLICY_DEPLOY = "false";
    private static final Logger logger = Logger.getAnonymousLogger();
    @Inject
    private Domain domain;

    @Override
    public void postConstruct() {
        if (this.domain.getExtensionByType(SecurityConfigurations.class) != null) {
            logger.log(Level.INFO, "SecurityConfigUpgradeService bypassing - security-configurations already present");
            return;
        }
        Transaction t = null;
        try {
            t = new Transaction();
            Domain domain_w = t.enroll(this.domain);
            SecurityConfigurations sc_w = domain_w.createChild(SecurityConfigurations.class);
            domain_w.getExtensions().add(sc_w);
            AuthenticationService as_w = this.addAuthenticationService(sc_w);
            this.addAdmRealmProvider(as_w);
            this.addFileRealmProvider(as_w);
            AuthorizationService authorizationService = this.addAuthorizationService(sc_w);
            this.addSimpleAuthorizationProvider(authorizationService);
            t.commit();
            logger.log(Level.INFO, "SecurityConfigUpgradeService successfully completed the upgrade");
        }
        catch (Exception ex) {
            if (t != null) {
                t.rollback();
            }
            logger.log(Level.SEVERE, null, ex);
        }
    }

    private AuthenticationService addAuthenticationService(SecurityConfigurations sc_w) throws TransactionFailure, PropertyVetoException {
        AuthenticationService as_w = sc_w.createChild(AuthenticationService.class);
        sc_w.getSecurityServices().add(as_w);
        as_w.setDefault(true);
        as_w.setName(AUTHENTICATION_SERVICE_NAME);
        as_w.setUsePasswordCredential(true);
        return as_w;
    }

    private SecurityProvider addFileRealmProvider(AuthenticationService as_w) throws PropertyVetoException, TransactionFailure {
        SecurityProvider sp_w = this.addProvider(as_w, FILE_REALM_PROVIDER_NAME, FILE_REALM_PROVIDER_PROVIDER_NAME, LOGIN_MODULE_TYPE_NAME);
        this.addLoginModule(sp_w, FILE_LOGIN_MODULE_NAME, FILE_LOGIN_MODULE_CLASS);
        return sp_w;
    }

    private SecurityProvider addAdmRealmProvider(AuthenticationService as_w) throws TransactionFailure, PropertyVetoException {
        SecurityProvider sp_w = this.addProvider(as_w, ADM_REALM_PROVIDER_NAME, ADM_REALM_PROVIDER_PROVIDER_NAME, LOGIN_MODULE_TYPE_NAME);
        this.addLoginModule(sp_w, ADM_LOGIN_MODULE_NAME, ADM_LOGIN_MODULE_CLASS);
        return sp_w;
    }

    private SecurityProvider addProvider(AuthenticationService as_w, String providerName, String providerProviderName, String type2) throws TransactionFailure, PropertyVetoException {
        SecurityProvider sp_w = as_w.createChild(SecurityProvider.class);
        as_w.getSecurityProviders().add(sp_w);
        sp_w.setName(providerName);
        sp_w.setProviderName(providerProviderName);
        sp_w.setType(type2);
        return sp_w;
    }

    private LoginModuleConfig addLoginModule(SecurityProvider sp_w, String name, String className) throws TransactionFailure, PropertyVetoException {
        LoginModuleConfig lm_w = sp_w.createChild(LoginModuleConfig.class);
        sp_w.getSecurityProviderConfig().add(lm_w);
        lm_w.setName(name);
        lm_w.setModuleClass(className);
        lm_w.setControlFlag("sufficient");
        Property configProp = lm_w.createChild(Property.class);
        configProp.setName("config");
        configProp.setValue("server-config");
        Property realmProp = lm_w.createChild(Property.class);
        realmProp.setName("auth-realm");
        realmProp.setValue("admin-realm");
        lm_w.getProperty().add(configProp);
        lm_w.getProperty().add(realmProp);
        return lm_w;
    }

    private AuthorizationService addAuthorizationService(SecurityConfigurations sc_w) throws TransactionFailure, PropertyVetoException {
        AuthorizationService as_w = sc_w.createChild(AuthorizationService.class);
        sc_w.getSecurityServices().add(as_w);
        as_w.setDefault(true);
        as_w.setName(AUTHORIZATION_SERVICE_NAME);
        return as_w;
    }

    private SecurityProvider addSimpleAuthorizationProvider(AuthorizationService as_w) throws PropertyVetoException, TransactionFailure {
        SecurityProvider sp_w = this.addAuthzProvider(as_w, SIMPLE_PROVIDER_NAME, SIMPLE_PROVIDER_PROVIDER_NAME, SIMPLE_PROVIDER_TYPE);
        this.addAuthorizationConfig(sp_w, SIMPLE_PROVIDER_CONFIG_NAME, SUPPORT_POLICY_DEPLOY);
        return sp_w;
    }

    private void addAuthorizationConfig(SecurityProvider sp_w, String configName, String supportPolicyDeploy) throws TransactionFailure, PropertyVetoException {
        AuthorizationProviderConfig authorizationProviderConfig = sp_w.createChild(AuthorizationProviderConfig.class);
        authorizationProviderConfig.setName(configName);
        authorizationProviderConfig.setSupportPolicyDeploy(Boolean.valueOf(supportPolicyDeploy));
        authorizationProviderConfig.setProviderClass(SIMPLE_PROVIDER_CLASS_NAME);
        sp_w.getSecurityProviderConfig().add(authorizationProviderConfig);
    }

    private SecurityProvider addAuthzProvider(AuthorizationService as_w, String simpleProviderName, String simpleProviderProviderName, String simpleProviderType) throws TransactionFailure, PropertyVetoException {
        SecurityProvider sp_w = as_w.createChild(SecurityProvider.class);
        sp_w.setName(simpleProviderName);
        sp_w.setProviderName(simpleProviderProviderName);
        sp_w.setType(simpleProviderType);
        as_w.getSecurityProviders().add(sp_w);
        return sp_w;
    }
}

