/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.resources.module;

import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.logging.LogDomains;
import jakarta.inject.Inject;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.ApplicationContainer;
import org.glassfish.api.deployment.ApplicationContext;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.resources.listener.ApplicationScopedResourcesManager;
import org.glassfish.resources.module.ResourcesDeployer;
import org.jvnet.hk2.annotations.Service;

@Service
@PerLookup
public class ResourcesApplication
implements ApplicationContainer {
    private static final Logger _logger = LogDomains.getLogger(ResourcesApplication.class, "jakarta.enterprise.resource.resourceadapter");
    private String applicationName;
    @Inject
    private ApplicationRegistry appRegistry;
    @Inject
    private Applications applications;
    private Resources resources;
    @Inject
    private ApplicationScopedResourcesManager asrManager;
    @Inject
    private ResourcesDeployer resourcesDeployer;

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public Object getDescriptor() {
        return null;
    }

    @Override
    public boolean start(ApplicationContext startupContext) throws Exception {
        DeploymentContext dc = (DeploymentContext)startupContext;
        DeployCommandParameters deployParams = dc.getCommandParameters(DeployCommandParameters.class);
        if (deployParams.origin == OpsParams.Origin.deploy || deployParams.origin == OpsParams.Origin.deploy_instance) {
            this.resourcesDeployer.deployResources(this.applicationName, true);
        } else if (deployParams.origin == OpsParams.Origin.load || deployParams.origin == OpsParams.Origin.create_application_ref) {
            this.asrManager.deployResources(this.applicationName);
        }
        return true;
    }

    @Override
    public boolean stop(ApplicationContext stopContext) {
        this.asrManager.undeployResources(this.applicationName);
        return true;
    }

    @Override
    public boolean suspend() {
        return true;
    }

    @Override
    public boolean resume() throws Exception {
        return true;
    }

    @Override
    public ClassLoader getClassLoader() {
        return null;
    }

    private void debug(String message) {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("[ResourcesApplication] " + message);
        }
    }
}

