/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.resources.mail.deployer;

import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.deployment.MailConfiguration;
import com.sun.logging.LogDomains;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.mail.Session;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Reference;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.resourcebase.resources.api.ResourceConflictException;
import org.glassfish.resourcebase.resources.api.ResourceDeployer;
import org.glassfish.resourcebase.resources.api.ResourceDeployerInfo;
import org.glassfish.resourcebase.resources.api.ResourceInfo;
import org.glassfish.resourcebase.resources.naming.ResourceNamingService;
import org.glassfish.resourcebase.resources.util.ResourceUtil;
import org.glassfish.resources.api.GlobalResourceDeployer;
import org.glassfish.resources.api.JavaEEResource;
import org.glassfish.resources.api.ResourcePropertyImpl;
import org.glassfish.resources.mail.beans.MailResource;
import org.glassfish.resources.mail.naming.MailNamingObjectFactory;
import org.glassfish.resources.naming.SerializableObjectRefAddr;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.types.Property;

@Service
@Singleton
@ResourceDeployerInfo(value=org.glassfish.resources.mail.config.MailResource.class)
public class MailResourceDeployer
extends GlobalResourceDeployer
implements ResourceDeployer<org.glassfish.resources.mail.config.MailResource> {
    private static final Logger LOG = LogDomains.getLogger(MailResourceDeployer.class, "jakarta.enterprise.resource.resourceadapter");
    @Inject
    private ResourceNamingService namingService;

    @Override
    public boolean handles(Object resource) {
        return resource instanceof org.glassfish.resources.mail.config.MailResource;
    }

    @Override
    public void validatePreservedResource(Application oldApp, Application newApp, Resource resource, Resources allResources) throws ResourceConflictException {
    }

    @Override
    public synchronized void deployResource(org.glassfish.resources.mail.config.MailResource resource) throws Exception {
        ResourceInfo resourceInfo = ResourceUtil.getResourceInfo(resource);
        this.deployResource(resource, resourceInfo.getApplicationName(), resourceInfo.getModuleName());
    }

    @Override
    public synchronized void deployResource(org.glassfish.resources.mail.config.MailResource resource, String applicationName, String moduleName) throws Exception {
        if (resource == null) {
            LOG.log(Level.INFO, "Error in resource deploy.");
        } else {
            SimpleJndiName jndiName = SimpleJndiName.of(resource.getJndiName());
            ResourceInfo resourceInfo = new ResourceInfo(jndiName, applicationName, moduleName);
            this.installResource(resource, resourceInfo);
        }
    }

    @Override
    public synchronized void undeployResource(org.glassfish.resources.mail.config.MailResource resource) throws Exception {
        ResourceInfo resourceInfo = ResourceUtil.getResourceInfo(resource);
        this.namingService.unpublishObject(resourceInfo, resourceInfo.getName());
    }

    @Override
    public void undeployResource(org.glassfish.resources.mail.config.MailResource resource, String applicationName, String moduleName) throws Exception {
        SimpleJndiName jndiName = SimpleJndiName.of(resource.getJndiName());
        ResourceInfo resourceInfo = new ResourceInfo(jndiName, applicationName, moduleName);
        this.namingService.unpublishObject(resourceInfo, resourceInfo.getName());
    }

    private void installResource(org.glassfish.resources.mail.config.MailResource mailResource, ResourceInfo resourceInfo) throws Exception {
        JavaEEResource j2eeRes = MailResourceDeployer.toMailJavaEEResource(mailResource, resourceInfo);
        this.installMailResource((MailResource)j2eeRes, resourceInfo);
    }

    private void installMailResource(MailResource mailResource, ResourceInfo resourceInfo) {
        try {
            MailConfiguration config = new MailConfiguration(mailResource);
            Reference ref = new Reference(Session.class.getName(), MailNamingObjectFactory.class.getName(), null);
            SerializableObjectRefAddr serializableRefAddr = new SerializableObjectRefAddr("jndiName", config);
            ref.add(serializableRefAddr);
            this.namingService.publishObject(resourceInfo, ref, true);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "mailrsrc.create_obj_error", resourceInfo);
            LOG.log(Level.SEVERE, "mailrsrc.create_obj_error_excp", ex);
        }
    }

    private static JavaEEResource toMailJavaEEResource(org.glassfish.resources.mail.config.MailResource mailResourceConfig, ResourceInfo resourceInfo) {
        MailResource mailResource = new MailResource(resourceInfo);
        mailResource.setEnabled(Boolean.valueOf(mailResourceConfig.getEnabled()));
        mailResource.setStoreProtocol(mailResourceConfig.getStoreProtocol());
        mailResource.setStoreProtocolClass(mailResourceConfig.getStoreProtocolClass());
        mailResource.setTransportProtocol(mailResourceConfig.getTransportProtocol());
        mailResource.setTransportProtocolClass(mailResourceConfig.getTransportProtocolClass());
        mailResource.setMailHost(mailResourceConfig.getHost());
        mailResource.setUsername(mailResourceConfig.getUser());
        mailResource.setMailFrom(mailResourceConfig.getFrom());
        mailResource.setDebug(Boolean.valueOf(mailResourceConfig.getDebug()));
        List<Property> properties = mailResourceConfig.getProperty();
        if (properties != null) {
            for (Property property : properties) {
                ResourcePropertyImpl rp = new ResourcePropertyImpl(property.getName(), property.getValue());
                mailResource.addProperty(rp);
            }
        }
        return mailResource;
    }
}

