/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.resources.mail.admin.cli;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.util.LocalStringManagerImpl;
import jakarta.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.resourcebase.resources.admin.cli.ResourceUtil;
import org.glassfish.resources.mail.config.MailResource;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@TargetType(value={CommandTarget.DAS, CommandTarget.DOMAIN, CommandTarget.CLUSTER, CommandTarget.STANDALONE_INSTANCE})
@RestEndpoints(value={@RestEndpoint(configBean=Resources.class, opType=RestEndpoint.OpType.DELETE, path="delete-mail-resource", description="delete-mail-resource")})
@ExecuteOn(value={RuntimeType.ALL})
@Service(name="delete-mail-resource")
@PerLookup
@I18n(value="delete.mail.resource")
public class DeleteMailResource
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(DeleteMailResource.class);
    @Param(optional=true, defaultValue="server")
    private String target;
    @Param(name="jndi_name", primary=true)
    private String jndiName;
    @Inject
    private Domain domain;
    @Inject
    private ServerEnvironment environment;
    @Inject
    private ResourceUtil resourceUtil;

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        if (!this.isResourceExists(this.domain.getResources(), this.jndiName)) {
            report.setMessage(localStrings.getLocalString("delete.mail.resource.notfound", "A Mail resource named {0} does not exist.", this.jndiName));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        SimpleJndiName simpleJndiName = SimpleJndiName.of(this.jndiName);
        if (this.environment.isDas()) {
            if ("domain".equals(this.target)) {
                if (!this.resourceUtil.getTargetsReferringResourceRef(simpleJndiName).isEmpty()) {
                    report.setMessage(localStrings.getLocalString("delete.mail.resource.resource-ref.exist", "mail-resource [ {0} ] is referenced in an instance/cluster target, Use delete-resource-ref on appropriate target", this.jndiName));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
            } else {
                if (!this.resourceUtil.isResourceRefInTarget(simpleJndiName, this.target)) {
                    report.setMessage(localStrings.getLocalString("delete.mail.resource.no.resource-ref", "mail-resource [ {0} ] is not referenced in target [ {1} ]", this.jndiName, this.target));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
                if (this.resourceUtil.getTargetsReferringResourceRef(simpleJndiName).size() > 1) {
                    report.setMessage(localStrings.getLocalString("delete.mail.resource.multiple.resource-refs", "mail-resource [ {0} ] is referenced in multiple instance/cluster targets, Use delete-resource-ref on appropriate target", this.jndiName));
                    report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                    return;
                }
            }
        }
        try {
            if (!"domain".equals(this.target)) {
                this.resourceUtil.deleteResourceRef(simpleJndiName, this.target);
            }
            SingleConfigCode<Resources> configCode = param -> {
                MailResource resource = (MailResource)org.glassfish.resourcebase.resources.util.ResourceUtil.getBindableResourceByName(this.domain.getResources(), this.jndiName);
                return param.getResources().remove(resource);
            };
            ConfigSupport.apply(configCode, this.domain.getResources());
            report.setMessage(localStrings.getLocalString("delete.mail.resource.success", "Mail resource {0} deleted", this.jndiName));
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (TransactionFailure tfe) {
            report.setMessage(localStrings.getLocalString("delete.mail.resource.failed", "Unable to delete mail resource {0}", this.jndiName) + " " + tfe.getLocalizedMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(tfe);
        }
    }

    private boolean isResourceExists(Resources resources, String jndiName) {
        return org.glassfish.resourcebase.resources.util.ResourceUtil.getBindableResourceByName(resources, jndiName) != null;
    }
}

