/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.tf.tools.enhancer;

import org.glassfish.pfl.tf.spi.EnhancedClassData;
import org.glassfish.pfl.tf.spi.TraceEnhancementException;
import org.glassfish.pfl.tf.spi.annotation.TFEnhanced;
import org.glassfish.pfl.tf.spi.annotation.TraceEnhanceLevel;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class TFEnhanceAdapter
extends ClassVisitor {
    private static final String TFENHANCED_ANNO_DESC = Type.getDescriptor(TFEnhanced.class);
    private static final String TRACE_ENHANCE_LEVEL_DESC = Type.getDescriptor(TraceEnhanceLevel.class);
    private boolean firstCall = true;
    private final TraceEnhanceLevel[] present = new TraceEnhanceLevel[1];
    private final TraceEnhanceLevel required;
    private final TraceEnhanceLevel result;
    private final EnhancedClassData ecd;

    public TFEnhanceAdapter(ClassVisitor cv, TraceEnhanceLevel required, TraceEnhanceLevel result, EnhancedClassData ecd) {
        super(458752, cv);
        this.required = required;
        this.result = result;
        this.ecd = ecd;
        this.present[0] = TraceEnhanceLevel.NONE;
    }

    private void checkForTFEnhanceAnnotation() {
        if (this.firstCall) {
            this.firstCall = false;
            if (this.present[0] != this.required) {
                throw new TraceEnhancementException("Class " + this.ecd.getClassName() + " has trace enhancement level " + this.present[0] + " but " + this.required + " is required.");
            }
            AnnotationVisitor av = super.visitAnnotation(TFENHANCED_ANNO_DESC, true);
            av.visitEnum("stage", TRACE_ENHANCE_LEVEL_DESC, this.result.name());
            av.visitEnd();
        }
    }

    @Override
    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        this.checkForTFEnhanceAnnotation();
        super.visitInnerClass(name, outerName, innerName, access);
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        this.checkForTFEnhanceAnnotation();
        return super.visitField(access, name, desc, signature, value);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        this.checkForTFEnhanceAnnotation();
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean isVisible) {
        if (desc.equals(TFENHANCED_ANNO_DESC)) {
            return new AnnotationVisitor(458752){

                @Override
                public void visit(String name, Object value) {
                }

                @Override
                public void visitEnum(String name, String desc, String value) {
                    if (name.equals("stage")) {
                        TFEnhanceAdapter.this.present[0] = Enum.valueOf(TraceEnhanceLevel.class, value);
                    }
                }

                @Override
                public AnnotationVisitor visitAnnotation(String name, String desc) {
                    return null;
                }

                @Override
                public AnnotationVisitor visitArray(String name) {
                    return null;
                }

                @Override
                public void visitEnd() {
                }
            };
        }
        AnnotationVisitor av = super.visitAnnotation(desc, isVisible);
        return av;
    }
}

