/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.tf.timer.spi;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Properties;
import org.glassfish.pfl.basic.contain.Pair;
import org.glassfish.pfl.dynamic.codegen.impl.ASMUtil;
import org.glassfish.pfl.dynamic.codegen.spi.Expression;
import org.glassfish.pfl.dynamic.codegen.spi.ImportList;
import org.glassfish.pfl.dynamic.codegen.spi.Type;
import org.glassfish.pfl.dynamic.codegen.spi.Wrapper;
import org.glassfish.pfl.tf.timer.spi.Controllable;
import org.glassfish.pfl.tf.timer.spi.Named;
import org.glassfish.pfl.tf.timer.spi.Timer;
import org.glassfish.pfl.tf.timer.spi.TimerEventController;
import org.glassfish.pfl.tf.timer.spi.TimerFactory;
import org.glassfish.pfl.tf.timer.spi.TimerGroup;

public class TimerPointSourceGenerator {
    private static final Comparator<Named> COMP = new Comparator<Named>(){

        @Override
        public int compare(Named o1, Named o2) {
            return o1.name().compareTo(o2.name());
        }
    };
    private static Type TimerFactory;
    private static Type Timer;
    private static Type TimerEventController;
    private static Type TimerGroup;
    private static ImportList standardImports;

    public static void generateFile(String dirName, Pair<String, TimerFactory> description) throws IOException {
        String packageName = description.first();
        TimerFactory tf = description.second();
        TimerPointSourceGenerator.generateSingleClass(dirName, packageName, tf);
    }

    private static void generateSingleClass(String dirName, String packageName, TimerFactory tf) throws IOException {
        TimerPointSourceGenerator.startFile(packageName);
        Wrapper._class(1, tf.name(), Wrapper._Object(), new Type[0]);
        TimerPointSourceGenerator.generateFields(tf, false, true);
        TimerPointSourceGenerator.generateConstructor(tf, false);
        TimerPointSourceGenerator.generateAccessorMethods(tf, true);
        Wrapper._end();
        Type type2 = Type._classGenerator(Wrapper._classGenerator());
        TimerPointSourceGenerator.writeFile(dirName, type2);
    }

    private static void startFile(String packageName) {
        Wrapper._clear();
        Wrapper._package(packageName);
        Wrapper._import(standardImports);
    }

    private static void generateFields(TimerFactory tf, boolean generateController, boolean privateTimers) {
        if (generateController) {
            Wrapper._data(20, TimerEventController, "controller");
        }
        int mod = 0x10 | (privateTimers ? 2 : 4);
        ArrayList<? extends Timer> timers = new ArrayList<Timer>(tf.timers().values());
        Collections.sort(timers, COMP);
        for (Timer timer : timers) {
            Wrapper._data(mod, Timer, timer.name());
        }
        ArrayList<? extends TimerGroup> timerGroups = new ArrayList<TimerGroup>(tf.timerGroups().values());
        Collections.sort(timerGroups, COMP);
        for (TimerGroup timerGroup : timerGroups) {
            Wrapper._data(18, TimerGroup, timerGroup.name());
        }
    }

    private static void generateConstructor(TimerFactory tf, boolean generateController) {
        Expression controller = null;
        Wrapper._constructor(1, new Type[0]);
        Expression tfe = Wrapper._arg(TimerFactory, "tf");
        if (generateController) {
            controller = Wrapper._arg(TimerEventController, "controller");
        }
        Wrapper._body();
        if (generateController) {
            Wrapper._assign(Wrapper._field(Wrapper._this(), "controller"), controller);
        }
        for (Timer timer : tf.timers().values()) {
            Wrapper._assign(Wrapper._v(timer.name()), Wrapper._call(tfe, "makeTimer", Wrapper._const(timer.name()), Wrapper._const(timer.description())));
        }
        for (TimerGroup timerGroup : tf.timerGroups().values()) {
            Wrapper._assign(Wrapper._v(timerGroup.name()), Wrapper._call(tfe, "makeTimerGroup", Wrapper._const(timerGroup.name()), Wrapper._const(timerGroup.description())));
        }
        for (TimerGroup timerGroup : tf.timerGroups().values()) {
            for (Controllable controllable : timerGroup.contents()) {
                Wrapper._expr(Wrapper._call(Wrapper._v(timerGroup.name()), "add", Wrapper._v(controllable.name())));
            }
        }
        Wrapper._end();
    }

    private static void generateAccessorMethods(TimerFactory tf, boolean isImpl) {
        int modifiers = isImpl ? 17 : 1025;
        ArrayList<? extends Timer> timers = new ArrayList<Timer>(tf.timers().values());
        Collections.sort(timers, COMP);
        for (Timer timer : timers) {
            Wrapper._method(modifiers, Timer, timer.name(), new Type[0]);
            if (isImpl) {
                Wrapper._body();
                Wrapper._return(Wrapper._field(Wrapper._this(), timer.name()));
            }
            Wrapper._end();
        }
        ArrayList<? extends TimerGroup> timerGroups = new ArrayList<TimerGroup>(tf.timerGroups().values());
        Collections.sort(timerGroups, COMP);
        for (TimerGroup timerGroup : timerGroups) {
            Wrapper._method(modifiers, TimerGroup, timerGroup.name(), new Type[0]);
            if (isImpl) {
                Wrapper._body();
                Wrapper._return(Wrapper._field(Wrapper._this(), timerGroup.name()));
            }
            Wrapper._end();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFile(String dirName, Type type2) throws IOException {
        File file = ASMUtil.getFile(dirName, type2.name(), ".java");
        try (PrintStream ps = new PrintStream(file);){
            Wrapper._sourceCode(ps, new Properties());
        }
    }

    static {
        Wrapper._clear();
        Wrapper._package();
        TimerFactory = Wrapper._import(TimerFactory.class.getName());
        Timer = Wrapper._import(Timer.class.getName());
        TimerEventController = Wrapper._import(TimerEventController.class.getName());
        TimerGroup = Wrapper._import(TimerGroup.class.getName());
        standardImports = Wrapper._import();
    }
}

