/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.main.jul;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.glassfish.main.jul.GlassFishLogManager;
import org.glassfish.main.jul.GlassFishLoggingStatus;
import org.glassfish.main.jul.StartupQueue;
import org.glassfish.main.jul.env.LoggingSystemEnvironment;
import org.glassfish.main.jul.record.GlassFishLogRecord;
import org.glassfish.main.jul.record.MessageResolver;
import org.glassfish.main.jul.tracing.GlassFishLoggingTracer;

public class GlassFishLogger
extends Logger {
    private static final MessageResolver MSG_RESOLVER = new MessageResolver();
    private static final Function<Logger, Stream<Handler>> LOGER_TO_HANDLER = x -> Arrays.stream(x.getHandlers());

    protected GlassFishLogger(String name) {
        super(name, null);
    }

    GlassFishLogger(Logger logger2) {
        super(Objects.requireNonNull(logger2, "logger is null!").getName(), null);
        this.initMe(logger2);
    }

    private void initMe(Logger logger2) {
        this.setLevel(logger2.getLevel());
        this.setUseParentHandlers(logger2.getUseParentHandlers());
        this.setFilter(logger2.getFilter());
        if (logger2.getParent() != null) {
            this.setParent(logger2.getParent());
        }
        if (logger2.getResourceBundle() != null) {
            this.setResourceBundle(logger2.getResourceBundle());
        }
        for (Handler handler : logger2.getHandlers()) {
            this.addHandler(handler);
        }
    }

    @Override
    public void setLevel(Level newLevel) throws SecurityException {
        GlassFishLoggingTracer.trace(GlassFishLogger.class, () -> "setLevel(" + String.valueOf(newLevel) + "); this: " + String.valueOf(this));
        super.setLevel(newLevel);
    }

    @Override
    public void addHandler(Handler handler) throws SecurityException {
        GlassFishLoggingTracer.trace(GlassFishLogger.class, () -> "addHandler(" + String.valueOf(handler) + "); this: " + String.valueOf(this));
        super.addHandler(handler);
    }

    @Override
    public void removeHandler(Handler handler) throws SecurityException {
        GlassFishLoggingTracer.trace(GlassFishLogger.class, () -> "removeHandler(" + String.valueOf(handler) + "); this: " + String.valueOf(this));
        super.removeHandler(handler);
    }

    public String toString() {
        return super.toString() + "['" + this.getName() + "':" + String.valueOf(this.getLevel()) + "]";
    }

    public <T extends Handler> T getHandler(Class<T> type2) {
        return (T)((Handler)type2.cast(Arrays.stream(this.getHandlers()).filter(h -> h.getClass().equals(type2)).findFirst().orElse(null)));
    }

    public List<Handler> getHandlers(Class<?> type2) {
        return Arrays.stream(this.getHandlers()).filter(type2::isInstance).collect(Collectors.toList());
    }

    @Override
    public void log(Level level, String msg) {
        GlassFishLoggingStatus status = this.getLoggingStatus();
        if (!this.isProcessible(level, status)) {
            return;
        }
        GlassFishLogRecord record = new GlassFishLogRecord(level, msg, this.isClassAndMethodDetectionEnabled());
        ((LogRecord)record).setLoggerName(this.getName());
        ((LogRecord)record).setResourceBundle(this.getResourceBundle());
        ((LogRecord)record).setResourceBundleName(this.getResourceBundleName());
        this.logOrQueue(record, status);
    }

    @Override
    public void log(Level level, Supplier<String> msgSupplier) {
        GlassFishLoggingStatus status = this.getLoggingStatus();
        if (!this.isProcessible(level, status)) {
            return;
        }
        GlassFishLogRecord record = new GlassFishLogRecord(level, msgSupplier.get(), this.isClassAndMethodDetectionEnabled());
        ((LogRecord)record).setLoggerName(this.getName());
        this.logOrQueue(record, status);
    }

    @Override
    public void log(Level level, String msg, Object param) {
        this.log(level, msg, new Object[]{param});
    }

    @Override
    public void log(Level level, String msg, Object[] params) {
        GlassFishLoggingStatus status = this.getLoggingStatus();
        if (!this.isProcessible(level, status)) {
            return;
        }
        GlassFishLogRecord record = new GlassFishLogRecord(level, msg, this.isClassAndMethodDetectionEnabled());
        ((LogRecord)record).setLoggerName(this.getName());
        ((LogRecord)record).setResourceBundle(this.getResourceBundle());
        ((LogRecord)record).setResourceBundleName(this.getResourceBundleName());
        ((LogRecord)record).setParameters(params);
        this.logOrQueue(record, status);
    }

    @Override
    public void log(Level level, String msg, Throwable thrown) {
        GlassFishLoggingStatus status = this.getLoggingStatus();
        if (!this.isProcessible(level, status)) {
            return;
        }
        GlassFishLogRecord record = new GlassFishLogRecord(level, msg, this.isClassAndMethodDetectionEnabled());
        ((LogRecord)record).setLoggerName(this.getName());
        ((LogRecord)record).setResourceBundle(this.getResourceBundle());
        ((LogRecord)record).setResourceBundleName(this.getResourceBundleName());
        ((LogRecord)record).setThrown(thrown);
        this.logOrQueue(record, status);
    }

    @Override
    public void log(Level level, Throwable thrown, Supplier<String> msgSupplier) {
        GlassFishLoggingStatus status = this.getLoggingStatus();
        if (!this.isProcessible(level, status)) {
            return;
        }
        GlassFishLogRecord record = new GlassFishLogRecord(level, msgSupplier.get(), this.isClassAndMethodDetectionEnabled());
        ((LogRecord)record).setLoggerName(this.getName());
        ((LogRecord)record).setThrown(thrown);
        this.logOrQueue(record, status);
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg) {
        GlassFishLoggingStatus status = this.getLoggingStatus();
        if (!this.isProcessible(level, status)) {
            return;
        }
        this.logOrQueue(level, status, sourceClass, sourceMethod, msg, null, new Object[0]);
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, Supplier<String> msgSupplier) {
        GlassFishLoggingStatus status = this.getLoggingStatus();
        if (!this.isProcessible(level, status)) {
            return;
        }
        this.logOrQueue(level, status, sourceClass, sourceMethod, msgSupplier.get(), null, new Object[0]);
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object param) {
        GlassFishLoggingStatus status = this.getLoggingStatus();
        if (!this.isProcessible(level, status)) {
            return;
        }
        this.logOrQueue(level, status, sourceClass, sourceMethod, msg, null, param);
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Object[] params) {
        GlassFishLoggingStatus status = this.getLoggingStatus();
        if (!this.isProcessible(level, status)) {
            return;
        }
        this.logOrQueue(level, status, sourceClass, sourceMethod, msg, null, params);
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, String msg, Throwable thrown) {
        GlassFishLoggingStatus status = this.getLoggingStatus();
        if (!this.isProcessible(level, status)) {
            return;
        }
        this.logOrQueue(level, status, sourceClass, sourceMethod, msg, thrown, new Object[0]);
    }

    @Override
    public void logp(Level level, String sourceClass, String sourceMethod, Throwable thrown, Supplier<String> msgSupplier) {
        GlassFishLoggingStatus status = this.getLoggingStatus();
        if (!this.isProcessible(level, status)) {
            return;
        }
        this.logOrQueue(level, status, sourceClass, sourceMethod, msgSupplier.get(), thrown, new Object[0]);
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, ResourceBundle bundle2, String msg, Object ... params) {
        GlassFishLoggingStatus status = this.getLoggingStatus();
        if (!this.isProcessible(level, status)) {
            return;
        }
        GlassFishLogRecord record = new GlassFishLogRecord(level, msg, false);
        ((LogRecord)record).setLoggerName(this.getName());
        ((LogRecord)record).setSourceClassName(sourceClass);
        ((LogRecord)record).setSourceMethodName(sourceMethod);
        ((LogRecord)record).setParameters(params);
        if (bundle2 != null) {
            ((LogRecord)record).setResourceBundleName(bundle2.getBaseBundleName());
            ((LogRecord)record).setResourceBundle(bundle2);
        }
        this.logOrQueue(record, status);
    }

    @Override
    public void logrb(Level level, String sourceClass, String sourceMethod, ResourceBundle bundle2, String msg, Throwable thrown) {
        GlassFishLoggingStatus status = this.getLoggingStatus();
        if (!this.isProcessible(level, status)) {
            return;
        }
        GlassFishLogRecord record = new GlassFishLogRecord(level, msg, false);
        ((LogRecord)record).setLoggerName(this.getName());
        ((LogRecord)record).setSourceClassName(sourceClass);
        ((LogRecord)record).setSourceMethodName(sourceMethod);
        ((LogRecord)record).setThrown(thrown);
        if (bundle2 != null) {
            ((LogRecord)record).setResourceBundleName(bundle2.getBaseBundleName());
            ((LogRecord)record).setResourceBundle(bundle2);
        }
        this.logOrQueue(record, status);
    }

    @Override
    public void logrb(Level level, ResourceBundle bundle2, String msg, Object ... params) {
        GlassFishLoggingStatus status = this.getLoggingStatus();
        if (!this.isProcessible(level, status)) {
            return;
        }
        GlassFishLogRecord record = new GlassFishLogRecord(level, msg, this.isClassAndMethodDetectionEnabled());
        ((LogRecord)record).setLoggerName(this.getName());
        if (params != null && params.length != 0) {
            ((LogRecord)record).setParameters(params);
        }
        if (bundle2 != null) {
            ((LogRecord)record).setResourceBundleName(bundle2.getBaseBundleName());
            ((LogRecord)record).setResourceBundle(bundle2);
        }
        this.logOrQueue(record, status);
    }

    @Override
    public void entering(String sourceClass, String sourceMethod, Object[] params) {
        GlassFishLoggingStatus status = this.getLoggingStatus();
        if (!this.isProcessible(Level.FINER, status)) {
            return;
        }
        String msg = "ENTRY";
        if (params == null || params.length == 0) {
            this.logp(Level.FINER, sourceClass, sourceMethod, msg);
            return;
        }
        StringBuilder template = new StringBuilder(msg.length() + 4 * params.length).append(msg);
        for (int i = 0; i < params.length; ++i) {
            template.append(" {").append(i).append('}');
        }
        this.logp(Level.FINER, sourceClass, sourceMethod, template.toString(), params);
    }

    @Override
    public void throwing(String sourceClass, String sourceMethod, Throwable thrown) {
        this.logp(Level.FINER, sourceClass, sourceMethod, "THROW", thrown);
    }

    @Override
    public void log(LogRecord record) {
        GlassFishLoggingStatus status = this.getLoggingStatus();
        if (!this.isProcessible(record.getLevel(), status)) {
            return;
        }
        this.logOrQueue(record, status);
    }

    @Override
    public boolean isLoggable(Level level) {
        return this.isProcessible(level, this.getLoggingStatus());
    }

    protected boolean isProcessible(Level level, GlassFishLoggingStatus status) {
        return this.isLoggableLevel(level) || !this.isLevelResolutionPossible(status);
    }

    protected boolean isLoggableLevel(Level level) {
        return super.isLoggable(level);
    }

    private boolean isFullService(GlassFishLoggingStatus status) {
        return status == GlassFishLoggingStatus.FULL_SERVICE;
    }

    private boolean isLevelResolutionPossible(GlassFishLoggingStatus status) {
        return LoggingSystemEnvironment.isResolveLevelWithIncompleteConfiguration() || status == GlassFishLoggingStatus.FLUSHING_BUFFERS || status == GlassFishLoggingStatus.FULL_SERVICE;
    }

    private boolean isToQueue(GlassFishLoggingStatus status) {
        return status == GlassFishLoggingStatus.UNCONFIGURED || status == GlassFishLoggingStatus.CONFIGURING;
    }

    private boolean isClassAndMethodDetectionEnabled() {
        GlassFishLogManager manager = GlassFishLogManager.getLogManager();
        return manager == null ? false : manager.getConfiguration().isClassAndMethodDetectionEnabled();
    }

    void checkAndLog(LogRecord record) {
        if (!this.isLoggableLevel(record.getLevel())) {
            return;
        }
        Filter filter = this.getFilter();
        if (filter != null && !filter.isLoggable(record)) {
            return;
        }
        Predicate<Handler> handlerFilter = h -> h.isLoggable(record);
        Iterator handlers = this.getLoggers().stream().flatMap(LOGER_TO_HANDLER).filter(handlerFilter).iterator();
        if (!handlers.hasNext()) {
            return;
        }
        GlassFishLogRecord resolvedLogRecord = MSG_RESOLVER.resolve(record);
        handlers.forEachRemaining(h -> h.publish(resolvedLogRecord));
    }

    private List<Logger> getLoggers() {
        boolean useParentHandlers;
        ArrayList<Logger> loggers = new ArrayList<Logger>();
        Logger log = this;
        do {
            loggers.add(log);
        } while ((useParentHandlers = log.getUseParentHandlers()) && (log = log.getParent()) != null);
        return loggers;
    }

    private GlassFishLoggingStatus getLoggingStatus() {
        if (GlassFishLogManager.isGlassFishLogManager()) {
            return GlassFishLogManager.getLogManager().getLoggingStatus();
        }
        return GlassFishLoggingStatus.FULL_SERVICE;
    }

    private void logOrQueue(Level level, GlassFishLoggingStatus status, String sourceClass, String sourceMethod, String msg, Throwable thrown, Object ... params) {
        GlassFishLogRecord record = new GlassFishLogRecord(level, msg, false);
        ((LogRecord)record).setLoggerName(this.getName());
        ((LogRecord)record).setResourceBundle(this.getResourceBundle());
        ((LogRecord)record).setResourceBundleName(this.getResourceBundleName());
        ((LogRecord)record).setSourceClassName(sourceClass);
        ((LogRecord)record).setSourceMethodName(sourceMethod);
        ((LogRecord)record).setThrown(thrown);
        ((LogRecord)record).setParameters(params);
        this.logOrQueue(record, status);
    }

    private void logOrQueue(LogRecord record, GlassFishLoggingStatus status) {
        if (this.isFullService(status)) {
            this.checkAndLog(record);
            return;
        }
        if (this.isToQueue(status)) {
            StartupQueue.getInstance().add(this, record);
            return;
        }
        while (!this.isFullService(this.getLoggingStatus())) {
            Thread.onSpinWait();
        }
        this.checkAndLog(record);
    }
}

