/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.kernel.event;

import jakarta.inject.Inject;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.api.event.RestrictTo;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.kernel.KernelLoggerInfo;

public class EventsImpl
implements Events {
    private static final Logger LOG = KernelLoggerInfo.getLogger();
    private final AtomicLong sequenceGenerator = new AtomicLong(0L);
    final Map<Listener, EventMatcher> listeners = new ConcurrentSkipListMap<Listener, EventMatcher>();
    @Inject
    private ExecutorService executor;

    @Override
    public void register(EventListener listener) {
        try {
            Method eventMethod = listener.getClass().getMethod("event", EventListener.Event.class);
            RestrictTo[] restrictTo = (RestrictTo[])eventMethod.getParameters()[0].getAnnotationsByType(RestrictTo.class);
            EventTypes[] eventTypes = (EventTypes[])Arrays.stream(restrictTo).map(restrict -> EventTypes.create(restrict.value())).toArray(EventTypes[]::new);
            this.listeners.putIfAbsent(new Listener(listener, this.sequenceGenerator.getAndIncrement()), new EventMatcher(eventTypes));
        }
        catch (Throwable t) {
            LOG.log(Level.SEVERE, "NCLS-CORE-00068", t);
        }
    }

    @Override
    public void send(EventListener.Event<?> event) {
        this.send(event, true);
    }

    @Override
    public void send(EventListener.Event<?> event, boolean asynchronously) {
        for (Map.Entry<Listener, EventMatcher> entry : this.listeners.entrySet()) {
            EventMatcher matcher = entry.getValue();
            if (!matcher.matches(event)) continue;
            Listener listener = entry.getKey();
            if (asynchronously) {
                this.executor.submit(() -> {
                    try {
                        listener.event(event);
                    }
                    catch (Throwable t) {
                        LOG.log(Level.WARNING, "NCLS-CORE-00069", t);
                    }
                });
                continue;
            }
            try {
                listener.event(event);
            }
            catch (DeploymentException e) {
                throw e;
            }
            catch (Throwable t) {
                LOG.log(Level.WARNING, "NCLS-CORE-00069", t);
            }
        }
    }

    @Override
    public boolean unregister(EventListener listener) {
        return this.listeners.remove(new Listener(listener)) != null;
    }

    static class Listener
    implements Comparable<Listener> {
        private final EventListener eventListener;
        private final long sequenceNumber;

        Listener(EventListener eventListener) {
            this(eventListener, -1L);
        }

        Listener(EventListener eventListener, long sequenceNumber) {
            this.eventListener = eventListener;
            this.sequenceNumber = sequenceNumber;
        }

        void event(EventListener.Event<?> event) {
            this.eventListener.event(event);
        }

        EventListener unwrap() {
            return this.eventListener;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof Listener)) {
                return false;
            }
            return this.eventListener.equals(((Listener)obj).eventListener);
        }

        public int hashCode() {
            return this.eventListener.hashCode();
        }

        @Override
        public int compareTo(Listener listener) {
            return Long.compare(this.sequenceNumber, listener.sequenceNumber);
        }
    }

    static class EventMatcher {
        private final EventTypes<?>[] eventTypes;

        EventMatcher(EventTypes<?>[] eventTypes) {
            this.eventTypes = eventTypes;
        }

        boolean matches(EventListener.Event<?> event) {
            if (this.eventTypes.length == 0) {
                return true;
            }
            return Arrays.stream(this.eventTypes).anyMatch(event::is);
        }
    }
}

