/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.kernel.bean_validator;

import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorContext;
import jakarta.validation.ValidatorFactory;
import javax.naming.NamingException;
import org.glassfish.api.naming.NamedNamingObjectProxy;
import org.glassfish.api.naming.NamespacePrefixes;
import org.jvnet.hk2.annotations.Optional;
import org.jvnet.hk2.annotations.Service;

@Service
@NamespacePrefixes(value={"java:comp/Validator", "java:comp/ValidatorFactory"})
public class BeanValidatorNamingProxy
implements NamedNamingObjectProxy {
    static final String nameForValidator = "java:comp/Validator";
    static final String nameForValidatorFactory = "java:comp/ValidatorFactory";
    private ValidatorFactory validatorFactory;
    private Validator validator;
    @Inject
    @Named(value="ValidationNamingProxy")
    @Optional
    private NamedNamingObjectProxy cdiNamingProxy;

    @Override
    public Object handle(String name) throws NamingException {
        Object result = null;
        if (this.cdiNamingProxy != null && (result = this.cdiNamingProxy.handle(name)) != null) {
            return result;
        }
        if (nameForValidator.equals(name)) {
            result = this.getValidator();
        } else if (nameForValidatorFactory.equals(name)) {
            result = this.getValidatorFactory();
        }
        return result;
    }

    private Validator getValidator() throws NamingException {
        if (null == this.validator) {
            try {
                ValidatorFactory factory = this.getValidatorFactory();
                ValidatorContext validatorContext = factory.usingContext();
                this.validator = validatorContext.getValidator();
            }
            catch (Throwable t) {
                NamingException ne = new NamingException("Error retrieving Validator for java:comp/Validator lookup");
                ne.initCause(t);
                throw ne;
            }
        }
        return this.validator;
    }

    private ValidatorFactory getValidatorFactory() throws NamingException {
        if (null == this.validatorFactory) {
            try {
                this.validatorFactory = Validation.buildDefaultValidatorFactory();
            }
            catch (Throwable t) {
                NamingException ne = new NamingException("Error retrieving ValidatorFactory for java:comp/ValidatorFactory lookup");
                ne.initCause(t);
                throw ne;
            }
        }
        return this.validatorFactory;
    }
}

