/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.message.internal;

import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.glassfish.jersey.message.internal.AbstractMessageReaderWriterProvider;
import org.glassfish.jersey.message.internal.ReaderInterceptorExecutor;
import org.glassfish.jersey.message.internal.ReaderWriter;

@Produces(value={"application/octet-stream", "*/*"})
@Consumes(value={"application/octet-stream", "*/*"})
@Singleton
public final class InputStreamProvider
extends AbstractMessageReaderWriterProvider<InputStream> {
    @Override
    public boolean isReadable(Class<?> type2, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return InputStream.class == type2;
    }

    @Override
    public InputStream readFrom(Class<InputStream> type2, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        return ReaderInterceptorExecutor.closeableInputStream(entityStream);
    }

    @Override
    public boolean isWriteable(Class<?> type2, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return InputStream.class.isAssignableFrom(type2);
    }

    @Override
    public long getSize(InputStream t, Class<?> type2, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (t instanceof ByteArrayInputStream) {
            return ((ByteArrayInputStream)t).available();
        }
        return -1L;
    }

    @Override
    public void writeTo(InputStream t, Class<?> type2, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        try (InputStream inputStream = t;){
            ReaderWriter.writeTo(t, entityStream);
        }
    }
}

