/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.jettison.internal.entity;

import jakarta.inject.Inject;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.Providers;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.glassfish.jersey.jaxb.internal.AbstractCollectionJaxbProvider;
import org.glassfish.jersey.jettison.JettisonConfig;
import org.glassfish.jersey.jettison.JettisonConfigured;
import org.glassfish.jersey.jettison.internal.Stax2JettisonFactory;
import org.glassfish.jersey.message.internal.ReaderWriter;

public class JettisonListElementProvider
extends AbstractCollectionJaxbProvider {
    JettisonListElementProvider(Providers ps, Configuration config) {
        super(ps, config);
    }

    JettisonListElementProvider(Providers ps, MediaType mt, Configuration config) {
        super(ps, mt, config);
    }

    @Override
    public boolean isReadable(Class<?> type2, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return super.isReadable(type2, genericType, annotations, mediaType);
    }

    @Override
    public boolean isWriteable(Class<?> type2, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return super.isWriteable(type2, genericType, annotations, mediaType);
    }

    @Override
    public final void writeCollection(Class<?> elementType, Collection<?> t, MediaType mediaType, Charset c, Marshaller m, OutputStream entityStream) throws JAXBException, IOException {
        OutputStreamWriter osw = new OutputStreamWriter(entityStream, c);
        JettisonConfig origJsonConfig = JettisonConfig.DEFAULT;
        if (m instanceof JettisonConfigured) {
            origJsonConfig = ((JettisonConfigured)((Object)m)).getJSONConfiguration();
        }
        JettisonConfig unwrappingJsonConfig = JettisonConfig.createJSONConfiguration(origJsonConfig);
        XMLStreamWriter jxsw = Stax2JettisonFactory.createWriter(osw, unwrappingJsonConfig);
        String invisibleRootName = this.getRootElementName(elementType);
        try {
            jxsw.writeStartDocument();
            jxsw.writeStartElement(invisibleRootName);
            for (Object o : t) {
                m.marshal(o, jxsw);
            }
            jxsw.writeEndElement();
            jxsw.writeEndDocument();
            jxsw.flush();
        }
        catch (XMLStreamException ex) {
            Logger.getLogger(JettisonListElementProvider.class.getName()).log(Level.SEVERE, null, ex);
            throw new JAXBException(ex.getMessage(), ex);
        }
    }

    @Override
    protected final XMLStreamReader getXMLStreamReader(Class<?> elementType, MediaType mediaType, Unmarshaller u, InputStream entityStream) throws XMLStreamException {
        JettisonConfig c = JettisonConfig.DEFAULT;
        Charset charset = ReaderWriter.getCharset(mediaType);
        if (u instanceof JettisonConfigured) {
            c = ((JettisonConfigured)((Object)u)).getJSONConfiguration();
        }
        return Stax2JettisonFactory.createReader(new InputStreamReader(entityStream, charset), c);
    }

    @Produces(value={"*/*"})
    @Consumes(value={"*/*"})
    public static final class General
    extends JettisonListElementProvider {
        @Inject
        public General(@Context Providers ps, @Context Configuration config) {
            super(ps, config);
        }

        @Override
        protected boolean isSupported(MediaType m) {
            return m.getSubtype().endsWith("+json");
        }
    }

    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public static final class App
    extends JettisonListElementProvider {
        @Inject
        public App(@Context Providers ps, @Context Configuration config) {
            super(ps, MediaType.APPLICATION_JSON_TYPE, config);
        }
    }
}

