/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.internal;

import jakarta.ws.rs.RuntimeType;
import jakarta.ws.rs.SeBootstrap;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.util.concurrent.CompletionStage;
import org.glassfish.jersey.internal.AbstractRuntimeDelegate;
import org.glassfish.jersey.internal.LocalizationMessages;
import org.glassfish.jersey.internal.ServiceFinder;
import org.glassfish.jersey.message.internal.MessagingBinders;

public class RuntimeDelegateImpl
extends AbstractRuntimeDelegate {
    public RuntimeDelegateImpl() {
        super(new MessagingBinders.HeaderDelegateProviders(RuntimeType.CLIENT).getHeaderDelegateProviders());
    }

    @Override
    public <T> T createEndpoint(Application application, Class<T> endpointType) throws IllegalArgumentException, UnsupportedOperationException {
        RuntimeDelegate runtimeDelegate = this.findServerDelegate();
        if (runtimeDelegate != null) {
            return runtimeDelegate.createEndpoint(application, endpointType);
        }
        throw new UnsupportedOperationException(LocalizationMessages.NO_CONTAINER_AVAILABLE());
    }

    @Override
    public SeBootstrap.Configuration.Builder createConfigurationBuilder() {
        RuntimeDelegate runtimeDelegate = this.findServerDelegate();
        if (runtimeDelegate != null) {
            return runtimeDelegate.createConfigurationBuilder();
        }
        throw new UnsupportedOperationException(LocalizationMessages.NO_CONTAINER_AVAILABLE());
    }

    @Override
    public CompletionStage<SeBootstrap.Instance> bootstrap(Application application, SeBootstrap.Configuration configuration) {
        RuntimeDelegate runtimeDelegate = this.findServerDelegate();
        if (runtimeDelegate != null) {
            return runtimeDelegate.bootstrap(application, configuration);
        }
        throw new UnsupportedOperationException(LocalizationMessages.NO_CONTAINER_AVAILABLE());
    }

    @Override
    public CompletionStage<SeBootstrap.Instance> bootstrap(Class<? extends Application> applicationClass, SeBootstrap.Configuration configuration) {
        RuntimeDelegate runtimeDelegate = this.findServerDelegate();
        if (runtimeDelegate != null) {
            return runtimeDelegate.bootstrap(applicationClass, configuration);
        }
        throw new UnsupportedOperationException(LocalizationMessages.NO_CONTAINER_AVAILABLE());
    }

    private RuntimeDelegate findServerDelegate() {
        for (RuntimeDelegate delegate : ServiceFinder.find(RuntimeDelegate.class)) {
            if (delegate.getClass() == RuntimeDelegateImpl.class) continue;
            RuntimeDelegate.setInstance(delegate);
            return delegate;
        }
        return null;
    }
}

