/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.grizzly2.httpserver;

import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.server.TimeoutHandler;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyRequestPropertiesDelegate;
import org.glassfish.jersey.grizzly2.httpserver.internal.LocalizationMessages;
import org.glassfish.jersey.innate.inject.InjectionIds;
import org.glassfish.jersey.innate.inject.InternalBinder;
import org.glassfish.jersey.innate.inject.SupplierClassBinding;
import org.glassfish.jersey.innate.inject.SupplierInstanceBinding;
import org.glassfish.jersey.internal.inject.Binder;
import org.glassfish.jersey.internal.inject.ReferencingFactory;
import org.glassfish.jersey.internal.util.ExtendedLogger;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.process.internal.RequestScoped;
import org.glassfish.jersey.server.ApplicationHandler;
import org.glassfish.jersey.server.ContainerException;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ContainerResponse;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.ServerProperties;
import org.glassfish.jersey.server.internal.ContainerUtils;
import org.glassfish.jersey.server.spi.Container;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;

public final class GrizzlyHttpContainer
extends HttpHandler
implements Container {
    private static final ExtendedLogger logger = new ExtendedLogger(Logger.getLogger(GrizzlyHttpContainer.class.getName()), Level.FINEST);
    private final Type RequestTYPE = new GenericType<Ref<Request>>(){}.getType();
    private final Type ResponseTYPE = new GenericType<Ref<Response>>(){}.getType();
    private boolean configSetStatusOverSendError;
    private boolean configReduceContextPathSlashesEnabled;
    private static final CompletionHandler<Response> EMPTY_COMPLETION_HANDLER = new CompletionHandler<Response>(){

        @Override
        public void cancelled() {
        }

        @Override
        public void failed(Throwable throwable) {
        }

        @Override
        public void completed(Response result) {
        }

        @Override
        public void updated(Response result) {
        }
    };
    private volatile ApplicationHandler appHandler;

    GrizzlyHttpContainer(Application application) {
        this(new ApplicationHandler(application, (Binder)new GrizzlyBinder()));
    }

    GrizzlyHttpContainer(Class<? extends Application> applicationClass) {
        this(new ApplicationHandler(applicationClass, (Binder)new GrizzlyBinder()));
    }

    GrizzlyHttpContainer(Application application, Object parentContext) {
        this(new ApplicationHandler(application, new GrizzlyBinder(), parentContext));
    }

    private GrizzlyHttpContainer(ApplicationHandler applicationHandler) {
        this.appHandler = applicationHandler;
        this.cacheConfigSetStatusOverSendError();
        this.cacheConfigEnableLeadingContextPathSlashes();
    }

    @Override
    public void start() {
        super.start();
        this.appHandler.onStartup(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void service(Request request, Response response) {
        ResponseWriter responseWriter = new ResponseWriter(response, this.configSetStatusOverSendError);
        try {
            logger.debugLog("GrizzlyHttpContainer.service(...) started");
            URI baseUri = this.getBaseUri(request);
            URI requestUri = this.getRequestUri(request);
            ContainerRequest requestContext = new ContainerRequest(baseUri, requestUri, request.getMethod().getMethodString(), this.getSecurityContext(request), new GrizzlyRequestPropertiesDelegate(request), this.appHandler.getConfiguration());
            requestContext.setEntityStream(request.getInputStream());
            for (String headerName : request.getHeaderNames()) {
                requestContext.headers(headerName, request.getHeaders(headerName));
            }
            requestContext.setWriter(responseWriter);
            requestContext.setRequestScopedInitializer(injectionManager -> {
                ((Ref)injectionManager.getInstance(this.RequestTYPE)).set(request);
                ((Ref)injectionManager.getInstance(this.ResponseTYPE)).set(response);
            });
            this.appHandler.handle(requestContext);
        }
        finally {
            logger.debugLog("GrizzlyHttpContainer.service(...) finished");
        }
    }

    private boolean containsContextPath(Request request) {
        return request.getContextPath() != null && request.getContextPath().length() > 0;
    }

    @Override
    public ResourceConfig getConfiguration() {
        return this.appHandler.getConfiguration();
    }

    @Override
    public void reload() {
        this.reload(new ResourceConfig(this.appHandler.getConfiguration()));
    }

    @Override
    public void reload(ResourceConfig configuration) {
        this.appHandler.onShutdown(this);
        this.appHandler = new ApplicationHandler(configuration, (Binder)new GrizzlyBinder());
        this.appHandler.onReload(this);
        this.appHandler.onStartup(this);
        this.cacheConfigSetStatusOverSendError();
        this.cacheConfigEnableLeadingContextPathSlashes();
    }

    @Override
    public ApplicationHandler getApplicationHandler() {
        return this.appHandler;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.appHandler.onShutdown(this);
        this.appHandler = null;
    }

    private SecurityContext getSecurityContext(final Request request) {
        return new SecurityContext(){

            @Override
            public boolean isUserInRole(String role) {
                return false;
            }

            @Override
            public boolean isSecure() {
                return request.isSecure();
            }

            @Override
            public Principal getUserPrincipal() {
                return request.getUserPrincipal();
            }

            @Override
            public String getAuthenticationScheme() {
                return request.getAuthType();
            }
        };
    }

    private URI getBaseUri(Request request) {
        try {
            return new URI(request.getScheme(), null, request.getServerName(), request.getServerPort(), this.getBasePath(request), null, null);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private String getBasePath(Request request) {
        String contextPath = request.getContextPath();
        if (contextPath == null || contextPath.isEmpty()) {
            return "/";
        }
        if (contextPath.charAt(contextPath.length() - 1) != '/') {
            return contextPath + "/";
        }
        return contextPath;
    }

    private URI getRequestUri(Request request) {
        try {
            String serverAddress = this.getServerAddress(request);
            Object uri = this.configReduceContextPathSlashesEnabled && this.containsContextPath(request) ? ContainerUtils.reduceLeadingSlashes(request.getRequestURI()) : request.getRequestURI();
            String queryString = request.getQueryString();
            if (queryString != null) {
                uri = (String)uri + "?" + ContainerUtils.encodeUnsafeCharacters(queryString);
            }
            return new URI(serverAddress + (String)uri);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private String getServerAddress(Request request) throws URISyntaxException {
        return new URI(request.getScheme(), null, request.getServerName(), request.getServerPort(), null, null, null).toString();
    }

    private void cacheConfigSetStatusOverSendError() {
        this.configSetStatusOverSendError = ServerProperties.getValue(this.getConfiguration().getProperties(), "jersey.config.server.response.setStatusOverSendError", false, Boolean.class);
    }

    private void cacheConfigEnableLeadingContextPathSlashes() {
        this.configReduceContextPathSlashesEnabled = ServerProperties.getValue(this.getConfiguration().getProperties(), "jersey.config.server.reduceContextPathSlashes.enabled", false, Boolean.class);
    }

    static class GrizzlyBinder
    extends InternalBinder {
        GrizzlyBinder() {
        }

        @Override
        protected void configure() {
            ((SupplierClassBinding)((SupplierClassBinding)((SupplierClassBinding)this.bindFactory(GrizzlyRequestReferencingFactory.class).to((Type)((Object)Request.class))).proxy(false)).in(RequestScoped.class)).id(InjectionIds.GRIZZLY_REQUEST_REFERENCING_FACTORY.id());
            ((SupplierInstanceBinding)((SupplierInstanceBinding)this.bindFactory(ReferencingFactory.referenceFactory()).to(new GenericType<Ref<Request>>(){})).in(RequestScoped.class)).id(InjectionIds.GRIZZLY_REQUEST.id());
            ((SupplierClassBinding)((SupplierClassBinding)((SupplierClassBinding)((SupplierClassBinding)this.bindFactory(GrizzlyResponseReferencingFactory.class).to((Type)((Object)Response.class))).proxy(true)).proxyForSameScope(false)).in(RequestScoped.class)).id(InjectionIds.GRIZZLY_RESPONSE_REFERENCING_FACTORY.id());
            ((SupplierInstanceBinding)((SupplierInstanceBinding)this.bindFactory(ReferencingFactory.referenceFactory()).to(new GenericType<Ref<Response>>(){})).in(RequestScoped.class)).id(InjectionIds.GRIZZLY_RESPONSE.id());
        }
    }

    private static final class ResponseWriter
    implements ContainerResponseWriter {
        private final String name;
        private final Response grizzlyResponse;
        private final boolean configSetStatusOverSendError;

        ResponseWriter(Response response, boolean configSetStatusOverSendError) {
            this.grizzlyResponse = response;
            this.configSetStatusOverSendError = configSetStatusOverSendError;
            if (logger.isDebugLoggable()) {
                this.name = "ResponseWriter {id=" + UUID.randomUUID().toString() + ", grizzlyResponse=" + this.grizzlyResponse.hashCode() + "}";
                logger.debugLog("{0} - init", this.name);
            } else {
                this.name = "ResponseWriter";
            }
        }

        public String toString() {
            return this.name;
        }

        @Override
        public void commit() {
            try {
                if (this.grizzlyResponse.isSuspended()) {
                    this.grizzlyResponse.resume();
                }
            }
            catch (Throwable throwable) {
                logger.debugLog("{0} - commit() called", this.name);
                throw throwable;
            }
            logger.debugLog("{0} - commit() called", this.name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean suspend(long timeOut, TimeUnit timeUnit, final ContainerResponseWriter.TimeoutHandler timeoutHandler) {
            boolean bl;
            try {
                this.grizzlyResponse.suspend(timeOut, timeUnit, EMPTY_COMPLETION_HANDLER, new TimeoutHandler(){

                    @Override
                    public boolean onTimeout(Response response) {
                        if (timeoutHandler != null) {
                            timeoutHandler.onTimeout(this);
                        }
                        return false;
                    }
                });
                bl = true;
            }
            catch (IllegalStateException ex) {
                boolean bl2;
                try {
                    bl2 = false;
                }
                catch (Throwable throwable) {
                    logger.debugLog("{0} - suspend(...) called", this.name);
                    throw throwable;
                }
                logger.debugLog("{0} - suspend(...) called", this.name);
                return bl2;
            }
            logger.debugLog("{0} - suspend(...) called", this.name);
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setSuspendTimeout(long timeOut, TimeUnit timeUnit) throws IllegalStateException {
            try {
                this.grizzlyResponse.getSuspendContext().setTimeout(timeOut, timeUnit);
            }
            catch (Throwable throwable) {
                logger.debugLog("{0} - setTimeout(...) called", this.name);
                throw throwable;
            }
            logger.debugLog("{0} - setTimeout(...) called", this.name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public OutputStream writeResponseStatusAndHeaders(long contentLength, ContainerResponse context) throws ContainerException {
            OutputStream outputStream;
            try {
                Response.StatusType statusInfo = context.getStatusInfo();
                if (statusInfo.getReasonPhrase() == null) {
                    this.grizzlyResponse.setStatus(statusInfo.getStatusCode());
                } else {
                    this.grizzlyResponse.setStatus(statusInfo.getStatusCode(), statusInfo.getReasonPhrase());
                }
                this.grizzlyResponse.setContentLengthLong(contentLength);
                for (Map.Entry e : context.getStringHeaders().entrySet()) {
                    for (String value : (List)e.getValue()) {
                        this.grizzlyResponse.addHeader((String)e.getKey(), value);
                    }
                }
                outputStream = this.grizzlyResponse.getOutputStream();
            }
            catch (Throwable throwable) {
                logger.debugLog("{0} - writeResponseStatusAndHeaders() called", this.name);
                throw throwable;
            }
            logger.debugLog("{0} - writeResponseStatusAndHeaders() called", this.name);
            return outputStream;
        }

        @Override
        public void failure(Throwable error) {
            block7: {
                try {
                    if (this.grizzlyResponse.isCommitted()) break block7;
                    try {
                        if (this.configSetStatusOverSendError) {
                            this.grizzlyResponse.reset();
                            this.grizzlyResponse.setStatus(500, "Request failed.");
                        } else {
                            this.grizzlyResponse.sendError(500, "Request failed.");
                        }
                    }
                    catch (IllegalStateException ex) {
                        logger.log(Level.FINER, "Unable to reset failed response.", ex);
                    }
                    catch (IOException ex) {
                        throw new ContainerException(LocalizationMessages.EXCEPTION_SENDING_ERROR_RESPONSE(500, "Request failed."), ex);
                    }
                }
                catch (Throwable throwable) {
                    logger.debugLog("{0} - failure(...) called", this.name);
                    this.rethrow(error);
                    throw throwable;
                }
            }
            logger.debugLog("{0} - failure(...) called", this.name);
            this.rethrow(error);
        }

        @Override
        public boolean enableResponseBuffering() {
            return true;
        }

        private void rethrow(Throwable error) {
            if (error instanceof RuntimeException) {
                throw (RuntimeException)error;
            }
            throw new ContainerException(error);
        }
    }

    private static class GrizzlyResponseReferencingFactory
    extends ReferencingFactory<Response> {
        @Inject
        public GrizzlyResponseReferencingFactory(Provider<Ref<Response>> referenceFactory) {
            super(referenceFactory);
        }
    }

    private static class GrizzlyRequestReferencingFactory
    extends ReferencingFactory<Request> {
        @Inject
        public GrizzlyRequestReferencingFactory(Provider<Ref<Request>> referenceFactory) {
            super(referenceFactory);
        }
    }
}

