/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.ext.cdi1x.transaction.internal;

import jakarta.annotation.Priority;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.spi.AfterTypeDiscovery;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.BeforeBeanDiscovery;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.inject.Qualifier;
import jakarta.ws.rs.ext.ExceptionMapper;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import java.util.Set;
import org.glassfish.jersey.ext.cdi1x.internal.CdiUtil;
import org.glassfish.jersey.ext.cdi1x.internal.GenericCdiBeanSupplier;
import org.glassfish.jersey.ext.cdi1x.transaction.internal.TransactionalExceptionMapper;
import org.glassfish.jersey.ext.cdi1x.transaction.internal.WebAppExceptionHolder;
import org.glassfish.jersey.ext.cdi1x.transaction.internal.WebAppExceptionInterceptor;
import org.glassfish.jersey.innate.inject.Bindings;
import org.glassfish.jersey.internal.inject.Binding;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.server.spi.ComponentProvider;

@Priority(value=199)
public class TransactionalExceptionInterceptorProvider
implements ComponentProvider,
Extension {
    private InjectionManager injectionManager;
    private BeanManager beanManager;

    @Override
    public void initialize(InjectionManager injectionManager) {
        this.injectionManager = injectionManager;
        this.beanManager = CdiUtil.getBeanManager();
    }

    @Override
    public boolean bind(Class<?> component, Set<Class<?>> providerContracts) {
        return false;
    }

    @Override
    public void done() {
        if (this.beanManager != null) {
            this.bindWaeRestoringExceptionMapper();
        }
    }

    private void bindWaeRestoringExceptionMapper() {
        GenericCdiBeanSupplier beanSupplier = new GenericCdiBeanSupplier(TransactionalExceptionMapper.class, this.injectionManager, this.beanManager, true);
        Object binding = Bindings.supplier(beanSupplier).to(ExceptionMapper.class);
        this.injectionManager.register((Binding)binding);
    }

    private void afterTypeDiscovery(@Observes AfterTypeDiscovery afterTypeDiscovery) {
        List<Class<?>> interceptors = afterTypeDiscovery.getInterceptors();
        interceptors.add(WebAppExceptionInterceptor.class);
    }

    private void beforeBeanDiscovery(@Observes BeforeBeanDiscovery beforeBeanDiscovery, BeanManager beanManager) {
        TransactionalExceptionInterceptorProvider.addAnnotatedTypes(beforeBeanDiscovery, beanManager, WebAppExceptionHolder.class, WebAppExceptionInterceptor.class, TransactionalExceptionMapper.class);
    }

    private static void addAnnotatedTypes(BeforeBeanDiscovery beforeBeanDiscovery, BeanManager beanManager, Class<?> ... types) {
        for (Class<?> type2 : types) {
            beforeBeanDiscovery.addAnnotatedType(beanManager.createAnnotatedType(type2), "Jersey " + type2.getName());
        }
    }

    @Qualifier
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD, ElementType.FIELD, ElementType.PARAMETER, ElementType.TYPE})
    public static @interface WaeQualifier {
    }
}

