/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jdbcruntime.deployment.annotation.handlers;

import com.sun.enterprise.deployment.DataSourceDefinitionDescriptor;
import com.sun.enterprise.deployment.MetadataSource;
import com.sun.enterprise.deployment.ResourceDescriptor;
import com.sun.enterprise.deployment.annotation.context.ResourceContainerContext;
import com.sun.enterprise.deployment.annotation.handlers.AbstractResourceHandler;
import com.sun.enterprise.deployment.annotation.handlers.ResourceAnnotationControl;
import jakarta.annotation.sql.DataSourceDefinition;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.AroundTimeout;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.Interceptors;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;
import org.glassfish.apf.AnnotationHandlerFor;
import org.glassfish.apf.AnnotationInfo;
import org.glassfish.apf.AnnotationProcessorException;
import org.glassfish.apf.HandlerProcessingResult;
import org.glassfish.deployment.common.JavaEEResourceType;
import org.jvnet.hk2.annotations.Service;

@Service
@AnnotationHandlerFor(value=DataSourceDefinition.class)
public class DataSourceDefinitionHandler
extends AbstractResourceHandler {
    private static final ResourceAnnotationControl CTRL = new ResourceAnnotationControl(DataSourceDefinition.class);

    @Override
    protected HandlerProcessingResult processAnnotation(AnnotationInfo ainfo, ResourceContainerContext[] rcContexts) throws AnnotationProcessorException {
        DataSourceDefinition dataSourceDefnAn = (DataSourceDefinition)ainfo.getAnnotation();
        return this.processAnnotation(dataSourceDefnAn, ainfo, rcContexts);
    }

    protected HandlerProcessingResult processAnnotation(DataSourceDefinition dataSourceDefnAn, AnnotationInfo aiInfo, ResourceContainerContext[] rcContexts) throws AnnotationProcessorException {
        Class annotatedClass = (Class)aiInfo.getAnnotatedElement();
        Annotation[] annotations = annotatedClass.getAnnotations();
        boolean warClass = this.isAWebComponentClass(annotations);
        boolean ejbClass = this.isAEjbComponentClass(annotations);
        for (ResourceContainerContext context : rcContexts) {
            DataSourceDefinitionDescriptor desc;
            if (!CTRL.canProcessAnnotation(annotatedClass, ejbClass, warClass, context)) {
                return this.getDefaultProcessedResult();
            }
            Set<ResourceDescriptor> dsdDescs = context.getResourceDescriptors(JavaEEResourceType.DSD);
            if (this.isDefinitionAlreadyPresent(dsdDescs, desc = this.createDescriptor(dataSourceDefnAn))) {
                this.merge(dsdDescs, dataSourceDefnAn);
                continue;
            }
            dsdDescs.add(desc);
        }
        return this.getDefaultProcessedResult();
    }

    private boolean isDefinitionAlreadyPresent(Set<ResourceDescriptor> dsdDescs, DataSourceDefinitionDescriptor desc) {
        boolean result = false;
        for (ResourceDescriptor descriptor : dsdDescs) {
            if (!descriptor.equals(desc)) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public Class<? extends Annotation>[] getTypeDependencies() {
        Class<? extends Annotation>[] annotations = this.getEjbAndWebAnnotationTypes();
        ArrayList<Class<Annotation>> annotationsList = new ArrayList<Class<Annotation>>();
        for (Class<? extends Annotation> annotation : annotations) {
            annotationsList.add(annotation);
        }
        annotationsList.add(Interceptors.class);
        annotationsList.add(Interceptor.class);
        annotationsList.add(AroundInvoke.class);
        annotationsList.add(AroundTimeout.class);
        Class[] result = new Class[annotationsList.size()];
        return annotationsList.toArray(result);
    }

    private void merge(Set<ResourceDescriptor> dsdDescs, DataSourceDefinition defn) {
        for (ResourceDescriptor orgdesc : dsdDescs) {
            DataSourceDefinitionDescriptor desc = (DataSourceDefinitionDescriptor)orgdesc;
            if (!desc.getName().equals(defn.name())) continue;
            if (desc.getClassName() == null) {
                desc.setClassName(defn.className());
            }
            if (desc.getDescription() == null && defn.description() != null && !defn.description().isEmpty()) {
                desc.setDescription(defn.description());
            }
            if (!desc.isServerNameSet() && desc.getUrl() == null && defn.serverName() != null && !defn.serverName().equals("localhost")) {
                desc.setServerName(defn.serverName());
            }
            if (desc.getPortNumber() == -1 && desc.getUrl() == null && defn.portNumber() != -1) {
                desc.setPortNumber(defn.portNumber());
            }
            if (desc.getDatabaseName() == null && desc.getUrl() == null && defn.databaseName() != null && !defn.databaseName().isEmpty()) {
                desc.setDatabaseName(defn.databaseName());
            }
            if (!(desc.getUrl() != null || desc.getPortNumber() != -1 && desc.getServerName() != null && desc.getDatabaseName() != null || defn.url() == null || defn.url().isEmpty())) {
                desc.setUrl(defn.url());
            }
            if (desc.getUser() == null && defn.user() != null && !defn.user().isEmpty()) {
                desc.setUser(defn.user());
            }
            if (desc.getPassword() == null && defn.password() != null) {
                desc.setPassword(defn.password());
            }
            if (desc.getIsolationLevel() == -1 && defn.isolationLevel() != -1) {
                desc.setIsolationLevel(String.valueOf(defn.isolationLevel()));
            }
            if (!desc.isTransactionSet()) {
                if (defn.transactional()) {
                    desc.setTransactional(true);
                } else {
                    desc.setTransactional(false);
                }
            }
            if (desc.getMinPoolSize() == -1 && defn.minPoolSize() != -1) {
                desc.setMinPoolSize(defn.minPoolSize());
            }
            if (desc.getMaxPoolSize() == -1 && defn.maxPoolSize() != -1) {
                desc.setMaxPoolSize(defn.maxPoolSize());
            }
            if (desc.getInitialPoolSize() == -1 && defn.initialPoolSize() != -1) {
                desc.setInitialPoolSize(defn.initialPoolSize());
            }
            if (desc.getMaxIdleTime() == -1L && defn.maxIdleTime() != -1) {
                desc.setMaxIdleTime(String.valueOf(defn.maxIdleTime()));
            }
            if (desc.getMaxStatements() == -1 && defn.maxStatements() != -1) {
                desc.setMaxStatements(defn.maxStatements());
            }
            if (!desc.isLoginTimeoutSet() && defn.loginTimeout() != 0) {
                desc.setLoginTimeout(String.valueOf(defn.loginTimeout()));
            }
            Properties properties = desc.getProperties();
            String[] defnProperties = defn.properties();
            if (defnProperties.length <= 0) break;
            for (String property : defnProperties) {
                int index = property.indexOf("=");
                if (index <= -1 || index == 0 || index >= property.length() - 1) continue;
                String name = property.substring(0, index);
                String value = property.substring(index + 1);
                if (properties.get(name) != null) continue;
                properties.put(name, value);
            }
        }
    }

    private DataSourceDefinitionDescriptor createDescriptor(DataSourceDefinition defn) {
        DataSourceDefinitionDescriptor desc = new DataSourceDefinitionDescriptor();
        desc.setMetadataSource(MetadataSource.ANNOTATION);
        desc.setName(defn.name());
        desc.setClassName(defn.className());
        if (defn.description() != null && !defn.description().isEmpty()) {
            desc.setDescription(defn.description());
        }
        if (defn.serverName() != null && !defn.serverName().equals("localhost")) {
            desc.setServerName(defn.serverName());
        }
        if (defn.portNumber() != -1) {
            desc.setPortNumber(defn.portNumber());
        }
        if (defn.databaseName() != null && !defn.databaseName().isEmpty()) {
            desc.setDatabaseName(defn.databaseName());
        }
        if (!(desc.getPortNumber() != -1 && desc.getDatabaseName() != null && desc.getServerName() != null || defn.url() == null || defn.url().isEmpty())) {
            desc.setUrl(defn.url());
        }
        if (defn.user() != null && !defn.user().isEmpty()) {
            desc.setUser(defn.user());
        }
        if (defn.password() != null) {
            desc.setPassword(defn.password());
        }
        if (defn.isolationLevel() != -1) {
            desc.setIsolationLevel(String.valueOf(defn.isolationLevel()));
        }
        if (defn.transactional()) {
            desc.setTransactional(true);
        } else {
            desc.setTransactional(false);
        }
        if (defn.minPoolSize() != -1) {
            desc.setMinPoolSize(defn.minPoolSize());
        }
        if (defn.maxPoolSize() != -1) {
            desc.setMaxPoolSize(defn.maxPoolSize());
        }
        if (defn.initialPoolSize() != -1) {
            desc.setInitialPoolSize(defn.initialPoolSize());
        }
        if (defn.maxIdleTime() != -1) {
            desc.setMaxIdleTime(String.valueOf(defn.maxIdleTime()));
        }
        if (defn.maxStatements() != -1) {
            desc.setMaxStatements(defn.maxStatements());
        }
        if (defn.loginTimeout() != 0) {
            desc.setLoginTimeout(String.valueOf(defn.loginTimeout()));
        }
        if (defn.properties() != null) {
            Properties properties = desc.getProperties();
            String[] defnProperties = defn.properties();
            if (defnProperties.length > 0) {
                for (String property : defnProperties) {
                    int index = property.indexOf("=");
                    if (index <= -1 || index == 0 || index >= property.length() - 1) continue;
                    String name = property.substring(0, index);
                    String value = property.substring(index + 1);
                    properties.put(name, value);
                }
            }
        }
        return desc;
    }
}

