/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jdbc.deployer;

import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.DataSourceDefinitionDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbInterceptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.ManagedBeanDescriptor;
import com.sun.logging.LogDomains;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.beans.PropertyVetoException;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.glassfish.api.jdbc.objects.TxIsolationLevel;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.deployment.common.JavaEEResourceType;
import org.glassfish.deployment.common.RootDeploymentDescriptor;
import org.glassfish.javaee.services.CommonResourceProxy;
import org.glassfish.jdbc.config.JdbcConnectionPool;
import org.glassfish.jdbc.config.JdbcResource;
import org.glassfish.resourcebase.resources.api.ResourceConflictException;
import org.glassfish.resourcebase.resources.api.ResourceDeployer;
import org.glassfish.resourcebase.resources.api.ResourceDeployerInfo;
import org.glassfish.resourcebase.resources.api.ResourceInfo;
import org.glassfish.resourcebase.resources.naming.ResourceNamingService;
import org.glassfish.resourcebase.resources.util.ResourceManagerFactory;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service
@ResourceDeployerInfo(value=DataSourceDefinitionDescriptor.class)
public class DataSourceDefinitionDeployer
implements ResourceDeployer<DataSourceDefinitionDescriptor> {
    private static final Logger LOG = LogDomains.getLogger(DataSourceDefinitionDeployer.class, "jakarta.enterprise.resource.resourceadapter");
    @Inject
    private Provider<ResourceManagerFactory> resourceManagerFactoryProvider;
    @Inject
    private Provider<CommonResourceProxy> dataSourceDefinitionProxyProvider;
    @Inject
    private Provider<ResourceNamingService> resourceNamingServiceProvider;

    @Override
    public void deployResource(DataSourceDefinitionDescriptor resource, String applicationName, String moduleName) throws Exception {
    }

    @Override
    public void deployResource(DataSourceDefinitionDescriptor resource) throws Exception {
        SimpleJndiName jndiName = SimpleJndiName.of(resource.getName());
        SimpleJndiName poolName = ConnectorsUtil.deriveResourceName(resource.getResourceId(), jndiName, JavaEEResourceType.DSDPOOL);
        SimpleJndiName resourceName = ConnectorsUtil.deriveResourceName(resource.getResourceId(), jndiName, resource.getResourceType());
        MyJdbcConnectionPool jdbcConnectionPool = new MyJdbcConnectionPool(resource, poolName);
        this.getDeployer(jdbcConnectionPool).deployResource(jdbcConnectionPool);
        MyJdbcResource jdbcResource = new MyJdbcResource(poolName, resourceName);
        this.getDeployer(jdbcResource).deployResource(jdbcResource);
    }

    @Override
    public void validatePreservedResource(com.sun.enterprise.config.serverbeans.Application oldApp, com.sun.enterprise.config.serverbeans.Application newApp, Resource resource, Resources allResources) throws ResourceConflictException {
    }

    private ResourceDeployer getDeployer(Object resource) {
        return this.resourceManagerFactoryProvider.get().getResourceDeployer(resource);
    }

    private DataSourceProperty convertProperty(String name, String value) {
        return new DataSourceProperty(name, value);
    }

    public void registerDataSourceDefinitions(Application application) {
        String appName = application.getAppName();
        Set<BundleDescriptor> bundles = application.getBundleDescriptors();
        for (BundleDescriptor bundle2 : bundles) {
            this.registerDataSourceDefinitions(appName, bundle2);
            Collection<RootDeploymentDescriptor> deploymentDescriptors = bundle2.getExtensionsDescriptors();
            if (deploymentDescriptors == null) continue;
            for (RootDeploymentDescriptor deploymentDescriptor : deploymentDescriptors) {
                this.registerDataSourceDefinitions(appName, deploymentDescriptor);
            }
        }
    }

    private void registerDataSourceDefinitions(String appName, Descriptor descriptor) {
        if (descriptor instanceof JndiNameEnvironment) {
            JndiNameEnvironment env = (JndiNameEnvironment)((Object)descriptor);
            for (Descriptor descriptor2 : env.getResourceDescriptors(JavaEEResourceType.DSD)) {
                this.registerDSDReferredByApplication(appName, (DataSourceDefinitionDescriptor)descriptor2);
            }
        }
        if (descriptor instanceof EjbBundleDescriptor) {
            EjbBundleDescriptor ejbDesc = (EjbBundleDescriptor)descriptor;
            Set<? extends EjbDescriptor> ejbDescriptors = ejbDesc.getEjbs();
            for (EjbDescriptor ejbDescriptor : ejbDescriptors) {
                for (Descriptor descriptor3 : ejbDescriptor.getResourceDescriptors(JavaEEResourceType.DSD)) {
                    this.registerDSDReferredByApplication(appName, (DataSourceDefinitionDescriptor)descriptor3);
                }
            }
            for (EjbInterceptor ejbInterceptor : ejbDesc.getInterceptors()) {
                for (Descriptor descriptor4 : ejbInterceptor.getResourceDescriptors(JavaEEResourceType.DSD)) {
                    this.registerDSDReferredByApplication(appName, (DataSourceDefinitionDescriptor)descriptor4);
                }
            }
        }
        if (descriptor instanceof BundleDescriptor) {
            Set<ManagedBeanDescriptor> managedBeanDescriptors = ((BundleDescriptor)descriptor).getManagedBeans();
            for (ManagedBeanDescriptor managedBeanDescriptor : managedBeanDescriptors) {
                for (Descriptor descriptor5 : managedBeanDescriptor.getResourceDescriptors(JavaEEResourceType.DSD)) {
                    this.registerDSDReferredByApplication(appName, (DataSourceDefinitionDescriptor)descriptor5);
                }
            }
        }
    }

    private void unregisterDSDReferredByApplication(DataSourceDefinitionDescriptor dataSourceDefinitionDescriptor) {
        try {
            if (dataSourceDefinitionDescriptor.isDeployed()) {
                this.undeployResource(dataSourceDefinitionDescriptor);
            }
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "exception while unregistering DSD [ " + dataSourceDefinitionDescriptor.getName() + " ]", e);
        }
    }

    public void unRegisterDataSourceDefinitions(Application application) {
        Set<BundleDescriptor> bundles = application.getBundleDescriptors();
        for (BundleDescriptor bundle2 : bundles) {
            this.unRegisterDataSourceDefinitions(bundle2);
            Collection<RootDeploymentDescriptor> deploymentDescriptors = bundle2.getExtensionsDescriptors();
            if (deploymentDescriptors == null) continue;
            for (RootDeploymentDescriptor deploymentDescriptor : deploymentDescriptors) {
                this.unRegisterDataSourceDefinitions(deploymentDescriptor);
            }
        }
    }

    private void unRegisterDataSourceDefinitions(Descriptor descriptor) {
        if (descriptor instanceof JndiNameEnvironment) {
            JndiNameEnvironment env = (JndiNameEnvironment)((Object)descriptor);
            for (Descriptor descriptor2 : env.getResourceDescriptors(JavaEEResourceType.DSD)) {
                this.unregisterDSDReferredByApplication((DataSourceDefinitionDescriptor)descriptor2);
            }
        }
        if (descriptor instanceof EjbBundleDescriptor) {
            EjbBundleDescriptor ejbDesc = (EjbBundleDescriptor)descriptor;
            Set<? extends EjbDescriptor> ejbDescriptors = ejbDesc.getEjbs();
            for (EjbDescriptor ejbDescriptor : ejbDescriptors) {
                for (Descriptor descriptor3 : ejbDescriptor.getResourceDescriptors(JavaEEResourceType.DSD)) {
                    this.unregisterDSDReferredByApplication((DataSourceDefinitionDescriptor)descriptor3);
                }
            }
            for (EjbInterceptor ejbInterceptor : ejbDesc.getInterceptors()) {
                for (Descriptor descriptor4 : ejbInterceptor.getResourceDescriptors(JavaEEResourceType.DSD)) {
                    this.unregisterDSDReferredByApplication((DataSourceDefinitionDescriptor)descriptor4);
                }
            }
        }
        if (descriptor instanceof BundleDescriptor) {
            Set<ManagedBeanDescriptor> managedBeanDescriptors = ((BundleDescriptor)descriptor).getManagedBeans();
            for (ManagedBeanDescriptor managedBeanDescriptor : managedBeanDescriptors) {
                for (Descriptor descriptor5 : managedBeanDescriptor.getResourceDescriptors(JavaEEResourceType.DSD)) {
                    this.unregisterDSDReferredByApplication((DataSourceDefinitionDescriptor)descriptor5);
                }
            }
        }
    }

    private void registerDSDReferredByApplication(String appName, DataSourceDefinitionDescriptor dataSourceDefinitionDescriptor) {
        if (!dataSourceDefinitionDescriptor.isDeployed()) {
            CommonResourceProxy proxy = this.dataSourceDefinitionProxyProvider.get();
            ResourceNamingService resourceNamingService = this.resourceNamingServiceProvider.get();
            proxy.setDescriptor(dataSourceDefinitionDescriptor);
            SimpleJndiName dsdName = SimpleJndiName.of(dataSourceDefinitionDescriptor.getName());
            if (dsdName.isJavaApp()) {
                dataSourceDefinitionDescriptor.setResourceId(appName);
            }
            if (dsdName.isJavaGlobal() || dsdName.isJavaApp()) {
                ResourceInfo resourceInfo = new ResourceInfo(dsdName, appName, null);
                try {
                    resourceNamingService.publishObject(resourceInfo, proxy, true);
                    dataSourceDefinitionDescriptor.setDeployed(true);
                }
                catch (NamingException e) {
                    LOG.log(Level.WARNING, "dsd.registration.failed", new Object[]{appName, dsdName, e});
                }
            }
        }
    }

    @Override
    public void undeployResource(DataSourceDefinitionDescriptor resource, String applicationName, String moduleName) throws Exception {
    }

    @Override
    public void undeployResource(DataSourceDefinitionDescriptor resource) throws Exception {
        SimpleJndiName simpleJndiName = new SimpleJndiName(resource.getName());
        SimpleJndiName poolName = ConnectorsUtil.deriveResourceName(resource.getResourceId(), simpleJndiName, JavaEEResourceType.DSDPOOL);
        SimpleJndiName resourceName = ConnectorsUtil.deriveResourceName(resource.getResourceId(), simpleJndiName, resource.getResourceType());
        LOG.log(Level.FINE, () -> "DataSourceDefinitionDeployer.undeployResource() : pool-name [" + String.valueOf(poolName) + "],  resource-name [" + String.valueOf(resourceName) + "]");
        MyJdbcResource jdbcResource = new MyJdbcResource(poolName, resourceName);
        this.getDeployer(jdbcResource).undeployResource(jdbcResource);
        MyJdbcConnectionPool jdbcCp = new MyJdbcConnectionPool(resource, poolName);
        this.getDeployer(jdbcCp).undeployResource(jdbcCp);
        resource.setDeployed(false);
    }

    @Override
    public void enableResource(DataSourceDefinitionDescriptor resource) throws Exception {
        throw new UnsupportedOperationException("enable() not supported for datasource-definition type");
    }

    @Override
    public void disableResource(DataSourceDefinitionDescriptor resource) throws Exception {
        throw new UnsupportedOperationException("disable() not supported for datasource-definition type");
    }

    @Override
    public boolean handles(Object resource) {
        return resource instanceof DataSourceDefinitionDescriptor;
    }

    class MyJdbcConnectionPool
    extends FakeConfigBean
    implements JdbcConnectionPool {
        private final DataSourceDefinitionDescriptor dataSourceDefinitionDescriptor;
        private final SimpleJndiName name;

        MyJdbcConnectionPool(DataSourceDefinitionDescriptor desc, SimpleJndiName name) {
            this.dataSourceDefinitionDescriptor = desc;
            this.name = name;
        }

        @Override
        public String getDatasourceClassname() {
            if (!this.getResType().equals("java.sql.Driver")) {
                return this.dataSourceDefinitionDescriptor.getClassName();
            }
            return null;
        }

        @Override
        public void setDatasourceClassname(String value) throws PropertyVetoException {
        }

        @Override
        public String getResType() {
            String type2 = "javax.sql.DataSource";
            try {
                Class<?> dataSoureClass = Thread.currentThread().getContextClassLoader().loadClass(this.dataSourceDefinitionDescriptor.getClassName());
                if (XADataSource.class.isAssignableFrom(dataSoureClass)) {
                    type2 = "javax.sql.XADataSource";
                } else if (ConnectionPoolDataSource.class.isAssignableFrom(dataSoureClass)) {
                    type2 = "javax.sql.ConnectionPoolDataSource";
                } else if (DataSource.class.isAssignableFrom(dataSoureClass)) {
                    type2 = "javax.sql.DataSource";
                } else if (Driver.class.isAssignableFrom(dataSoureClass)) {
                    type2 = "java.sql.Driver";
                }
            }
            catch (ClassNotFoundException e) {
                LOG.log(Level.FINEST, () -> "Unable to load class [ " + this.dataSourceDefinitionDescriptor.getClassName() + " ] to determine its res-type, defaulting to [javax.sql.DataSource]");
            }
            return type2;
        }

        @Override
        public void setResType(String value) throws PropertyVetoException {
        }

        @Override
        public String getObjectType() {
            return null;
        }

        @Override
        public void setObjectType(String value) throws PropertyVetoException {
        }

        @Override
        public String getIdentity() {
            return this.name.toString();
        }

        @Override
        public String getSteadyPoolSize() {
            int minPoolSize = this.dataSourceDefinitionDescriptor.getMinPoolSize();
            if (minPoolSize == -1) {
                minPoolSize = 8;
            }
            return String.valueOf(minPoolSize);
        }

        @Override
        public void setSteadyPoolSize(String value) throws PropertyVetoException {
        }

        @Override
        public String getMaxPoolSize() {
            int maxPoolSize = this.dataSourceDefinitionDescriptor.getMaxPoolSize();
            if (maxPoolSize == -1) {
                maxPoolSize = 32;
            }
            return String.valueOf(maxPoolSize);
        }

        @Override
        public void setMaxPoolSize(String value) throws PropertyVetoException {
        }

        @Override
        public String getMaxWaitTimeInMillis() {
            return String.valueOf(60000);
        }

        @Override
        public void setMaxWaitTimeInMillis(String value) throws PropertyVetoException {
        }

        @Override
        public String getPoolResizeQuantity() {
            return String.valueOf(2);
        }

        @Override
        public void setPoolResizeQuantity(String value) throws PropertyVetoException {
        }

        @Override
        public String getIdleTimeoutInSeconds() {
            long maxIdleTime = this.dataSourceDefinitionDescriptor.getMaxIdleTime();
            if (maxIdleTime == -1L) {
                maxIdleTime = 300L;
            }
            return String.valueOf(maxIdleTime);
        }

        @Override
        public void setIdleTimeoutInSeconds(String value) throws PropertyVetoException {
        }

        @Override
        public String getTransactionIsolationLevel() {
            if (this.dataSourceDefinitionDescriptor.getIsolationLevel() == -1) {
                return null;
            }
            return TxIsolationLevel.byId(this.dataSourceDefinitionDescriptor.getIsolationLevel()).getName();
        }

        @Override
        public void setTransactionIsolationLevel(String value) throws PropertyVetoException {
        }

        @Override
        public String getIsIsolationLevelGuaranteed() {
            return String.valueOf("true");
        }

        @Override
        public void setIsIsolationLevelGuaranteed(String value) throws PropertyVetoException {
        }

        @Override
        public String getIsConnectionValidationRequired() {
            return String.valueOf("false");
        }

        @Override
        public void setIsConnectionValidationRequired(String value) throws PropertyVetoException {
        }

        @Override
        public String getConnectionValidationMethod() {
            return null;
        }

        @Override
        public void setConnectionValidationMethod(String value) throws PropertyVetoException {
        }

        @Override
        public String getValidationTableName() {
            return null;
        }

        @Override
        public void setValidationTableName(String value) throws PropertyVetoException {
        }

        @Override
        public String getValidationClassname() {
            return null;
        }

        @Override
        public void setValidationClassname(String value) throws PropertyVetoException {
        }

        @Override
        public String getFailAllConnections() {
            return String.valueOf("false");
        }

        @Override
        public void setFailAllConnections(String value) throws PropertyVetoException {
        }

        @Override
        public String getNonTransactionalConnections() {
            return String.valueOf(!this.dataSourceDefinitionDescriptor.isTransactional());
        }

        @Override
        public void setNonTransactionalConnections(String value) throws PropertyVetoException {
        }

        @Override
        public String getAllowNonComponentCallers() {
            return String.valueOf("false");
        }

        @Override
        public void setAllowNonComponentCallers(String value) throws PropertyVetoException {
        }

        @Override
        public String getValidateAtmostOncePeriodInSeconds() {
            return String.valueOf(0);
        }

        @Override
        public void setValidateAtmostOncePeriodInSeconds(String value) throws PropertyVetoException {
        }

        @Override
        public String getConnectionLeakTimeoutInSeconds() {
            return String.valueOf(0);
        }

        @Override
        public void setConnectionLeakTimeoutInSeconds(String value) throws PropertyVetoException {
        }

        @Override
        public String getConnectionLeakReclaim() {
            return String.valueOf(false);
        }

        @Override
        public void setConnectionLeakReclaim(String value) throws PropertyVetoException {
        }

        @Override
        public String getConnectionCreationRetryAttempts() {
            return String.valueOf(0);
        }

        @Override
        public void setConnectionCreationRetryAttempts(String value) throws PropertyVetoException {
        }

        @Override
        public String getConnectionCreationRetryIntervalInSeconds() {
            return String.valueOf(10);
        }

        @Override
        public void setConnectionCreationRetryIntervalInSeconds(String value) throws PropertyVetoException {
        }

        @Override
        public String getStatementTimeoutInSeconds() {
            return String.valueOf(-1);
        }

        @Override
        public void setStatementTimeoutInSeconds(String value) throws PropertyVetoException {
        }

        @Override
        public String getLazyConnectionEnlistment() {
            return String.valueOf(false);
        }

        @Override
        public void setLazyConnectionEnlistment(String value) throws PropertyVetoException {
        }

        @Override
        public String getLazyConnectionAssociation() {
            return String.valueOf(false);
        }

        @Override
        public void setLazyConnectionAssociation(String value) throws PropertyVetoException {
        }

        @Override
        public String getAssociateWithThread() {
            return String.valueOf(false);
        }

        @Override
        public void setAssociateWithThread(String value) throws PropertyVetoException {
        }

        @Override
        public String getPooling() {
            return String.valueOf(true);
        }

        @Override
        public void setPooling(String value) throws PropertyVetoException {
        }

        @Override
        public String getStatementCacheSize() {
            return String.valueOf(0);
        }

        @Override
        public void setStatementCacheSize(String value) throws PropertyVetoException {
        }

        @Override
        public String getMatchConnections() {
            return String.valueOf(true);
        }

        @Override
        public void setMatchConnections(String value) throws PropertyVetoException {
        }

        @Override
        public String getMaxConnectionUsageCount() {
            return String.valueOf(0);
        }

        @Override
        public void setMaxConnectionUsageCount(String value) throws PropertyVetoException {
        }

        @Override
        public String getWrapJdbcObjects() {
            return String.valueOf(true);
        }

        @Override
        public void setWrapJdbcObjects(String value) throws PropertyVetoException {
        }

        @Override
        public String getDescription() {
            return this.dataSourceDefinitionDescriptor.getDescription();
        }

        @Override
        public void setDescription(String value) throws PropertyVetoException {
        }

        @Override
        public List<Property> getProperty() {
            DataSourceProperty property;
            Properties descriptorProperties = this.dataSourceDefinitionDescriptor.getProperties();
            ArrayList<Property> dataSourceProperties = new ArrayList<Property>();
            for (Map.Entry<Object, Object> entry : descriptorProperties.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                dataSourceProperties.add(DataSourceDefinitionDeployer.this.convertProperty(key, value));
            }
            if (this.dataSourceDefinitionDescriptor.getUser() != null) {
                property = DataSourceDefinitionDeployer.this.convertProperty("user", this.dataSourceDefinitionDescriptor.getUser());
                dataSourceProperties.add(property);
            }
            if (this.dataSourceDefinitionDescriptor.getPassword() != null) {
                property = DataSourceDefinitionDeployer.this.convertProperty("password", this.dataSourceDefinitionDescriptor.getPassword());
                dataSourceProperties.add(property);
            }
            if (this.dataSourceDefinitionDescriptor.getDatabaseName() != null) {
                property = DataSourceDefinitionDeployer.this.convertProperty("databaseName", this.dataSourceDefinitionDescriptor.getDatabaseName());
                dataSourceProperties.add(property);
            }
            if (this.dataSourceDefinitionDescriptor.getServerName() != null) {
                property = DataSourceDefinitionDeployer.this.convertProperty("serverName", this.dataSourceDefinitionDescriptor.getServerName());
                dataSourceProperties.add(property);
            }
            if (this.dataSourceDefinitionDescriptor.getPortNumber() != -1) {
                property = DataSourceDefinitionDeployer.this.convertProperty("portNumber", String.valueOf(this.dataSourceDefinitionDescriptor.getPortNumber()));
                dataSourceProperties.add(property);
            }
            if (this.dataSourceDefinitionDescriptor.getUrl() != null && !this.isStandardPropertiesSet(this.dataSourceDefinitionDescriptor)) {
                property = DataSourceDefinitionDeployer.this.convertProperty("url", this.dataSourceDefinitionDescriptor.getUrl());
                dataSourceProperties.add(property);
            }
            if (this.dataSourceDefinitionDescriptor.getLoginTimeout() != 0L) {
                property = DataSourceDefinitionDeployer.this.convertProperty("loginTimeout", String.valueOf(this.dataSourceDefinitionDescriptor.getLoginTimeout()));
                dataSourceProperties.add(property);
            }
            if (this.dataSourceDefinitionDescriptor.getMaxStatements() != -1) {
                property = DataSourceDefinitionDeployer.this.convertProperty("maxStatements", String.valueOf(this.dataSourceDefinitionDescriptor.getMaxStatements()));
                dataSourceProperties.add(property);
            }
            return dataSourceProperties;
        }

        private boolean isStandardPropertiesSet(DataSourceDefinitionDescriptor dataSourceDefinitionDescriptor) {
            return dataSourceDefinitionDescriptor.getServerName() != null && dataSourceDefinitionDescriptor.getDatabaseName() != null && dataSourceDefinitionDescriptor.getPortNumber() != -1;
        }

        @Override
        public Property getProperty(String name) {
            String value = (String)this.dataSourceDefinitionDescriptor.getProperties().get(name);
            return new DataSourceProperty(name, value);
        }

        @Override
        public String getPropertyValue(String name) {
            return (String)this.dataSourceDefinitionDescriptor.getProperties().get(name);
        }

        @Override
        public String getPropertyValue(String name, String defaultValue) {
            String value = (String)this.dataSourceDefinitionDescriptor.getProperties().get(name);
            if (value != null) {
                return value;
            }
            return defaultValue;
        }

        public void injectedInto(Object o) {
        }

        @Override
        public String getName() {
            return this.name.toString();
        }

        @Override
        public void setName(String value) throws PropertyVetoException {
        }

        @Override
        public String getSqlTraceListeners() {
            return null;
        }

        @Override
        public void setSqlTraceListeners(String value) throws PropertyVetoException {
        }

        @Override
        public String getPing() {
            return String.valueOf(false);
        }

        @Override
        public void setPing(String value) throws PropertyVetoException {
        }

        @Override
        public String getInitSql() {
            return null;
        }

        @Override
        public void setInitSql(String value) throws PropertyVetoException {
        }

        @Override
        public String getDriverClassname() {
            if (this.getResType().equals("java.sql.Driver")) {
                return this.dataSourceDefinitionDescriptor.getClassName();
            }
            return null;
        }

        @Override
        public void setDriverClassname(String value) throws PropertyVetoException {
        }

        @Override
        public String getStatementLeakTimeoutInSeconds() {
            return String.valueOf(0);
        }

        @Override
        public void setStatementLeakTimeoutInSeconds(String value) throws PropertyVetoException {
        }

        @Override
        public String getStatementLeakReclaim() {
            return String.valueOf(false);
        }

        @Override
        public void setStatementLeakReclaim(String value) throws PropertyVetoException {
        }

        @Override
        public String getStatementCacheType() {
            return null;
        }

        @Override
        public void setStatementCacheType(String value) throws PropertyVetoException {
        }

        @Override
        public String getDeploymentOrder() {
            return null;
        }

        @Override
        public void setDeploymentOrder(String value) {
        }

        @Override
        public Property addProperty(Property prprt) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Property lookupProperty(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Property removeProperty(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Property removeProperty(Property prprt) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    class MyJdbcResource
    extends FakeConfigBean
    implements JdbcResource {
        private SimpleJndiName poolName;
        private SimpleJndiName jndiName;

        MyJdbcResource(SimpleJndiName poolName, SimpleJndiName jndiName) {
            this.poolName = poolName;
            this.jndiName = jndiName;
        }

        @Override
        public String getPoolName() {
            return this.poolName.toString();
        }

        @Override
        public void setPoolName(String value) throws PropertyVetoException {
            this.poolName = new SimpleJndiName(value);
        }

        @Override
        public String getObjectType() {
            return null;
        }

        @Override
        public void setObjectType(String value) throws PropertyVetoException {
        }

        @Override
        public String getIdentity() {
            return this.jndiName.toString();
        }

        @Override
        public String getEnabled() {
            return String.valueOf(true);
        }

        @Override
        public void setEnabled(String value) throws PropertyVetoException {
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public void setDescription(String value) throws PropertyVetoException {
        }

        @Override
        public List<Property> getProperty() {
            return null;
        }

        @Override
        public Property getProperty(String name) {
            return null;
        }

        @Override
        public String getPropertyValue(String name) {
            return null;
        }

        @Override
        public String getPropertyValue(String name, String defaultValue) {
            return null;
        }

        public void injectedInto(Object o) {
        }

        @Override
        public String getJndiName() {
            return this.jndiName.toString();
        }

        @Override
        public void setJndiName(String value) throws PropertyVetoException {
            this.jndiName = new SimpleJndiName(value);
        }

        @Override
        public String getDeploymentOrder() {
            return null;
        }

        @Override
        public void setDeploymentOrder(String value) {
        }

        @Override
        public Property addProperty(Property prprt) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Property lookupProperty(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Property removeProperty(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Property removeProperty(Property prprt) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }

    class DataSourceProperty
    extends FakeConfigBean
    implements Property {
        private String name;
        private String value;
        private String description;

        DataSourceProperty(String name, String value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void setName(String value) throws PropertyVetoException {
            this.name = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public void setValue(String value) throws PropertyVetoException {
            this.value = value;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public void setDescription(String value) throws PropertyVetoException {
            this.description = value;
        }

        public void injectedInto(Object o) {
        }
    }

    abstract class FakeConfigBean
    implements ConfigBeanProxy {
        FakeConfigBean() {
        }

        @Override
        public ConfigBeanProxy deepCopy(ConfigBeanProxy parent) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ConfigBeanProxy getParent() {
            return null;
        }

        @Override
        public <T extends ConfigBeanProxy> T getParent(Class<T> tClass) {
            return null;
        }

        @Override
        public <T extends ConfigBeanProxy> T createChild(Class<T> tClass) throws TransactionFailure {
            return null;
        }
    }
}

