/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jdbc.admin.cli.internal;

import com.sun.enterprise.config.serverbeans.Resources;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.naming.SimpleJndiName;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.jdbcruntime.service.JdbcAdminServiceImpl;
import org.glassfish.resourcebase.resources.api.PoolInfo;
import org.jvnet.hk2.annotations.Service;

@Service(name="_get-validation-table-names")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@RestEndpoints(value={@RestEndpoint(configBean=Resources.class, opType=RestEndpoint.OpType.GET, path="get-validation-table-names", description="Get Validation Table Names")})
public class GetValidationTableNames
implements AdminCommand {
    @Inject
    private JdbcAdminServiceImpl jdbcAdminService;
    @Param
    private String poolName;
    @Param(name="appname", optional=true)
    private String applicationName;
    @Param(name="modulename", optional=true)
    private String moduleName;

    @Override
    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        try {
            PoolInfo poolInfo = new PoolInfo(SimpleJndiName.of(this.poolName), this.applicationName, this.moduleName);
            Set<String> validationTableNames = this.jdbcAdminService.getValidationTableNames(poolInfo);
            Properties extraProperties = new Properties();
            extraProperties.put("validationTableNames", new ArrayList<String>(validationTableNames));
            report.setExtraProperties(extraProperties);
        }
        catch (Exception e) {
            report.setMessage("_get-validation-table-names failed : " + e.getMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause(e);
            return;
        }
        ActionReport.ExitCode ec = ActionReport.ExitCode.SUCCESS;
        report.setActionExitCode(ec);
    }
}

