/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.utilities.general;

import jakarta.validation.Path;
import jakarta.validation.TraversableResolver;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorContext;
import jakarta.validation.ValidatorFactory;
import java.lang.annotation.ElementType;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.concurrent.locks.ReentrantLock;
import org.glassfish.hk2.utilities.general.internal.MessageInterpolatorImpl;
import org.hibernate.validator.HibernateValidator;

public class ValidatorUtilities {
    private static final ReentrantLock slock = new ReentrantLock();
    private static final TraversableResolver TRAVERSABLE_RESOLVER = new TraversableResolver(){

        @Override
        public boolean isReachable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
            return true;
        }

        @Override
        public boolean isCascadable(Object traversableObject, Path.Node traversableProperty, Class<?> rootBeanType, Path pathToTraversableObject, ElementType elementType) {
            return true;
        }
    };
    private static Validator validator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Validator initializeValidator() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(HibernateValidator.class.getClassLoader());
            ValidatorFactory validatorFactory = Validation.buildDefaultValidatorFactory();
            ValidatorContext validatorContext = validatorFactory.usingContext();
            validatorContext.messageInterpolator(new MessageInterpolatorImpl());
            Validator validator = validatorContext.traversableResolver(TRAVERSABLE_RESOLVER).getValidator();
            return validator;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public static Validator getValidator() {
        slock.lock();
        try {
            if (validator == null) {
                validator = AccessController.doPrivileged(new PrivilegedAction<Validator>(){

                    @Override
                    public Validator run() {
                        return ValidatorUtilities.initializeValidator();
                    }
                });
            }
            if (validator == null) {
                throw new IllegalStateException("Could not find a jakarta.validator");
            }
            Validator validator = ValidatorUtilities.validator;
            return validator;
        }
        finally {
            slock.unlock();
        }
    }
}

