/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.extras.provides;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.DynamicConfiguration;
import org.glassfish.hk2.api.DynamicConfigurationService;
import org.glassfish.hk2.api.Populator;
import org.glassfish.hk2.api.Rank;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.extras.provides.ForwardingDynamicConfiguration;
import org.glassfish.hk2.extras.provides.NoInstancesFilter;
import org.glassfish.hk2.extras.provides.ProvidesDescriptor;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;

@Singleton
@Rank(value=1)
final class NoInstancesService
implements DynamicConfigurationService {
    private final ServiceLocator locator;

    @Inject
    public NoInstancesService(ServiceLocator locator) {
        this.locator = Objects.requireNonNull(locator);
    }

    private DynamicConfigurationService defaultConfigurationService() {
        return this.locator.getAllServiceHandles(DynamicConfigurationService.class, new Annotation[0]).stream().filter(serviceHandle -> serviceHandle.getActiveDescriptor().getImplementationClass() != this.getClass()).map(serviceHandle -> (DynamicConfigurationService)serviceHandle.getService()).findAny().orElseThrow(() -> new NoSuchElementException("Default configuration service not found"));
    }

    @Override
    public DynamicConfiguration createDynamicConfiguration() {
        final NoInstancesFilter filter = this.locator.getService(NoInstancesFilter.class, new Annotation[0]);
        final DynamicConfiguration config = this.defaultConfigurationService().createDynamicConfiguration();
        return new ForwardingDynamicConfiguration(){

            @Override
            public DynamicConfiguration delegate() {
                return config;
            }

            @Override
            public <T> ActiveDescriptor<T> addActiveDescriptor(Class<T> rawClass) {
                Objects.requireNonNull(rawClass);
                return filter.matches(rawClass) ? this.addActiveDescriptor(NoInstancesService.noInstancesDescriptor(rawClass)) : config.addActiveDescriptor(rawClass);
            }
        };
    }

    @Override
    public Populator getPopulator() {
        return this.defaultConfigurationService().getPopulator();
    }

    private static <T> ActiveDescriptor<T> noInstancesDescriptor(Class<T> rawClass) {
        Objects.requireNonNull(rawClass);
        return new ProvidesDescriptor<Object>(rawClass, rawClass, rawClass, Collections.emptySet(), ServiceLocatorUtilities.getPerLookupAnnotation(), root -> {
            throw new UnsupportedOperationException();
        }, instance -> {
            throw new UnsupportedOperationException();
        });
    }
}

