/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.extras.provides;

import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Objects;
import org.glassfish.hk2.api.DuplicateServiceException;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.hk2.extras.provides.NoInstancesService;
import org.glassfish.hk2.utilities.ServiceLocatorUtilities;
import org.jvnet.hk2.annotations.Contract;

@Contract
public interface NoInstancesFilter {
    public boolean matches(Class<?> var1);

    public static void enableNoInstancesFilter(ServiceLocator locator) {
        block2: {
            Objects.requireNonNull(locator);
            try {
                ServiceLocatorUtilities.addClasses(locator, true, DefaultFilter.class, NoInstancesService.class);
            }
            catch (MultiException multiException) {
                List<Throwable> errors = multiException.getErrors();
                if (!errors.isEmpty() && errors.stream().allMatch(e -> e instanceof DuplicateServiceException)) break block2;
                throw multiException;
            }
        }
    }

    public static final class DefaultFilter
    implements NoInstancesFilter {
        @Override
        public boolean matches(Class<?> clazz) {
            Objects.requireNonNull(clazz);
            return Modifier.isAbstract(clazz.getModifiers()) || clazz.getConstructors().length == 0;
        }
    }
}

