/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.classmodel.reflect.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.hk2.classmodel.reflect.ArchiveAdapter;
import org.glassfish.hk2.classmodel.reflect.Parser;
import org.glassfish.hk2.classmodel.reflect.util.AbstractAdapter;
import org.glassfish.hk2.classmodel.reflect.util.JarArchive;

public class DirectoryArchive
extends AbstractAdapter {
    public final File directory;
    public final Parser parser;

    public DirectoryArchive(Parser parser, File directory) {
        this.directory = directory;
        this.parser = parser;
    }

    public String toString() {
        return this.getURI().toString();
    }

    @Override
    public URI getURI() {
        return this.directory.toURI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Manifest getManifest() throws IOException {
        File manifest = new File(this.directory, "META-INF/MANIFEST.MF");
        if (manifest.exists()) {
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(manifest));){
                Manifest manifest2 = new Manifest(is);
                return manifest2;
            }
        }
        return null;
    }

    @Override
    public void onSelectedEntries(ArchiveAdapter.Selector selector, ArchiveAdapter.EntryTask task, Logger logger2) throws IOException {
        this.parse(this.directory, selector, task, logger2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(File dir, ArchiveAdapter.Selector selector, ArchiveAdapter.EntryTask task, Logger logger2) throws IOException {
        File[] listFiles = dir.listFiles();
        if (null == listFiles) {
            System.err.println("listFiles() is null for: " + dir);
            return;
        }
        for (File f : listFiles) {
            ArchiveAdapter.Entry ae = new ArchiveAdapter.Entry(this.mangle(f), f.length(), f.isDirectory());
            if (!f.isDirectory()) {
                if (ae.name.endsWith(".jar")) {
                    try (JarArchive ja = null;){
                        ja = new JarArchive(this.parser, f.toURI());
                        ja.onSelectedEntries(selector, task, logger2);
                        continue;
                    }
                }
                if (!selector.isSelected(ae)) continue;
                try (FileInputStream is = null;){
                    try {
                        is = new FileInputStream(f);
                        task.on(ae, is);
                    }
                    catch (Exception e) {
                        logger2.log(Level.SEVERE, "Exception while processing " + f.getName() + " of size " + f.length(), e);
                    }
                    continue;
                }
            }
            this.parse(f, selector, task, logger2);
        }
    }

    private String mangle(File f) {
        String relativePath = f.getAbsolutePath().substring(this.directory.getAbsolutePath().length() + 1);
        return relativePath.replace(File.separatorChar, '/');
    }

    @Override
    public void close() throws IOException {
    }
}

