/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.hk2.classmodel.reflect.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.glassfish.hk2.classmodel.reflect.ExtensibleType;
import org.glassfish.hk2.classmodel.reflect.FieldModel;
import org.glassfish.hk2.classmodel.reflect.InterfaceModel;
import org.glassfish.hk2.classmodel.reflect.ParameterizedInterfaceModel;
import org.glassfish.hk2.classmodel.reflect.Type;
import org.glassfish.hk2.classmodel.reflect.impl.ParameterizedInterfaceModelImpl;
import org.glassfish.hk2.classmodel.reflect.impl.TypeImpl;
import org.glassfish.hk2.classmodel.reflect.impl.TypeProxy;

public abstract class ExtensibleTypeImpl<T extends ExtensibleType>
extends TypeImpl
implements ExtensibleType<T> {
    private final ReentrantLock lock = new ReentrantLock();
    protected TypeProxy<?> parent;
    private final List<FieldModel> staticFields = new ArrayList<FieldModel>();
    private final List<TypeProxy<InterfaceModel>> implementedIntf = new ArrayList<TypeProxy<InterfaceModel>>();
    private final List<ParameterizedInterfaceModel> implementedParameterizedIntf = new ArrayList<ParameterizedInterfaceModel>();
    private Map<String, ParameterizedInterfaceModel> formalTypeParameters;

    public ExtensibleTypeImpl(String name, TypeProxy<Type> sink, TypeProxy parent) {
        super(name, sink);
        this.parent = parent;
    }

    @Override
    public Map<String, ParameterizedInterfaceModel> getFormalTypeParameters() {
        return this.formalTypeParameters;
    }

    public void setFormalTypeParameters(Map<String, ParameterizedInterfaceModel> typeParameters) {
        this.formalTypeParameters = typeParameters;
    }

    @Override
    public T getParent() {
        if (this.parent != null) {
            return (T)((ExtensibleType)this.parent.get());
        }
        return null;
    }

    @Override
    public boolean isInstanceOf(String name) {
        if (name == null) {
            throw new IllegalArgumentException(name);
        }
        if (this.getParent() != null) {
            if (name.equals(this.getParent().getName())) {
                return true;
            }
            return this.getParent().isInstanceOf(name);
        }
        return false;
    }

    @Override
    public String getSimpleName() {
        String simpleName = this.getName();
        simpleName = simpleName.substring(simpleName.lastIndexOf(46) + 1);
        simpleName = simpleName.substring(simpleName.lastIndexOf(36) + 1);
        return simpleName;
    }

    public TypeProxy<?> setParent(TypeProxy<?> parent) {
        this.lock.lock();
        try {
            if (null == this.parent) {
                this.parent = parent;
            }
            TypeProxy<?> typeProxy = this.parent;
            return typeProxy;
        }
        finally {
            this.lock.unlock();
        }
    }

    void isImplementing(TypeProxy<InterfaceModel> intf) {
        try {
            this.lock.lock();
            this.implementedIntf.add(intf);
        }
        finally {
            this.lock.unlock();
        }
    }

    void isImplementing(ParameterizedInterfaceModelImpl pim) {
        try {
            this.lock.lock();
            if (pim.getRawInterface() instanceof InterfaceModel) {
                this.implementedIntf.add(pim.getRawInterfaceProxy());
            }
            this.implementedParameterizedIntf.add(pim);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Collection<InterfaceModel> getInterfaces() {
        return TypeProxy.adapter(Collections.unmodifiableCollection(this.implementedIntf));
    }

    @Override
    public Collection<ParameterizedInterfaceModel> getParameterizedInterfaces() {
        return Collections.unmodifiableCollection(this.implementedParameterizedIntf);
    }

    @Override
    public ParameterizedInterfaceModel getParameterizedInterface(ExtensibleType type2) {
        for (ParameterizedInterfaceModel interfaceModel : this.implementedParameterizedIntf) {
            if (interfaceModel.getRawInterface() != type2) continue;
            return interfaceModel;
        }
        return null;
    }

    @Override
    public Collection<T> subTypes() {
        ArrayList<ExtensibleType> subTypes = new ArrayList<ExtensibleType>();
        for (Type t : this.getProxy().getSubTypeRefs()) {
            subTypes.add((ExtensibleType)t);
        }
        return subTypes;
    }

    @Override
    public Collection<T> allSubTypes() {
        Collection<T> allTypes = this.subTypes();
        for (ExtensibleType child : this.subTypes()) {
            allTypes.addAll(child.allSubTypes());
        }
        return allTypes;
    }

    void addStaticField(FieldModel field) {
        try {
            this.lock.lock();
            this.staticFields.add(field);
        }
        finally {
            this.lock.unlock();
        }
    }

    void addField(FieldModel field) {
        throw new RuntimeException("Cannot add a field to a non classmodel type");
    }

    @Override
    public Collection<FieldModel> getStaticFields() {
        return Collections.unmodifiableCollection(this.staticFields);
    }

    @Override
    protected void print(StringBuffer sb) {
        super.print(sb);
        sb.append(", parent=").append(this.parent == null ? "null" : this.parent.getName());
        sb.append(", interfaces=[");
        for (TypeProxy<InterfaceModel> im : this.implementedIntf) {
            sb.append(" ").append(im.getName());
        }
        sb.append("]");
    }
}

