/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.flashlight.impl.client;

import com.sun.enterprise.util.Utility;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.lang.ref.WeakReference;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.flashlight.FlashlightLoggerInfo;
import org.glassfish.flashlight.impl.client.AgentAttacher;
import org.glassfish.flashlight.impl.client.Log;
import org.glassfish.flashlight.provider.FlashlightProbe;
import org.glassfish.flashlight.provider.ProbeRegistry;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.AdviceAdapter;
import org.objectweb.asm.commons.Method;

public class ProbeProviderClassFileTransformer
implements ClassFileTransformer {
    private final WeakReference<Class> providerClassRef;
    private String providerClassName = null;
    private Map<String, FlashlightProbe> probes = new HashMap<String, FlashlightProbe>();
    private ClassWriter cw;
    private volatile boolean enabled = false;
    private boolean allProbesTransformed = true;
    private boolean transformerAdded = false;
    private int count = 0;
    private static Map<Class, ProbeProviderClassFileTransformer> instances = new WeakHashMap<Class, ProbeProviderClassFileTransformer>();
    private static final Instrumentation instrumentation;
    private static boolean _debug;
    private static boolean emittedAttachUnavailableMessageAlready;
    private static final String AGENT_CLASSNAME = "org.glassfish.flashlight.agent.ProbeAgentMain";
    private static final Logger logger;

    private ProbeProviderClassFileTransformer(Class providerClass) {
        this.providerClassRef = new WeakReference<Class>(providerClass);
        this.providerClassName = providerClass.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ProbeProviderClassFileTransformer getInstance(Class aProbeProvider) {
        Map<Class, ProbeProviderClassFileTransformer> map = instances;
        synchronized (map) {
            if (!instances.containsKey(aProbeProvider)) {
                ProbeProviderClassFileTransformer tx = new ProbeProviderClassFileTransformer(aProbeProvider);
                instances.put(aProbeProvider, tx);
                return tx;
            }
            return instances.get(aProbeProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void transformAll() {
        Map<Class, ProbeProviderClassFileTransformer> map = instances;
        synchronized (map) {
            Set<Map.Entry<Class, ProbeProviderClassFileTransformer>> entries = instances.entrySet();
            for (Map.Entry<Class, ProbeProviderClassFileTransformer> entry : entries) {
                entry.getValue().transform();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void untransformAll() {
        Map<Class, ProbeProviderClassFileTransformer> map = instances;
        synchronized (map) {
            Set<Map.Entry<Class, ProbeProviderClassFileTransformer>> entries = instances.entrySet();
            for (Map.Entry<Class, ProbeProviderClassFileTransformer> entry : entries) {
                entry.getValue().untransform();
            }
        }
    }

    static void untransform(Class aProviderClazz) {
        ProbeProviderClassFileTransformer.getInstance(aProviderClazz).untransform();
    }

    static void transform(Class aProviderClazz) {
        ProbeProviderClassFileTransformer.getInstance(aProviderClazz).transform();
    }

    synchronized void addProbe(FlashlightProbe probe) throws NoSuchMethodException {
        java.lang.reflect.Method m = this.getMethod(probe);
        this.probes.put(probe.getProviderJavaMethodName() + "::" + Type.getMethodDescriptor(m), probe);
        this.allProbesTransformed = false;
    }

    final synchronized void transform() {
        Class providerClass = (Class)this.providerClassRef.get();
        if (providerClass == null) {
            if (Log.getLogger().isLoggable(Level.FINER)) {
                Log.finer("provider class was reclaimed, not.transformed", this.providerClassName);
            }
            return;
        }
        if (this.enabled) {
            if (this.allProbesTransformed) {
                if (Log.getLogger().isLoggable(Level.FINER)) {
                    Log.finer("all probes already.transformed", providerClass);
                }
                return;
            }
            if (Log.getLogger().isLoggable(Level.FINER)) {
                Log.finer("some probes need to be.transformed", providerClass);
            }
        }
        this.allProbesTransformed = true;
        this.enabled = true;
        if (instrumentation == null) {
            return;
        }
        try {
            this.addTransformer();
            instrumentation.retransformClasses(providerClass);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "NCLS-MON-00507", e);
        }
    }

    final synchronized void untransform() {
        Class providerClass = (Class)this.providerClassRef.get();
        if (providerClass == null) {
            if (Log.getLogger().isLoggable(Level.FINER)) {
                Log.finer("provider class was reclaimed, not.untransformed", this.providerClassName);
            }
            return;
        }
        this.allProbesTransformed = false;
        if (!this.enabled) {
            if (Log.getLogger().isLoggable(Level.FINER)) {
                Log.finer("already.not.transformed", providerClass);
            }
            return;
        }
        this.enabled = false;
        if (instrumentation == null) {
            return;
        }
        try {
            instrumentation.retransformClasses(providerClass);
        }
        catch (UnmodifiableClassException e) {
            logger.log(Level.WARNING, "NCLS-MON-00507", e);
        }
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        byte[] ret = null;
        Class providerClass = (Class)this.providerClassRef.get();
        if (providerClass == null) {
            if (Log.getLogger().isLoggable(Level.FINER)) {
                Log.finer("provider class was reclaimed, not.transformed", this.providerClassName);
            }
            return null;
        }
        try {
            if (!AgentAttacher.canAttach()) {
                return null;
            }
            if (classBeingRedefined != providerClass) {
                return null;
            }
            if (this.enabled) {
                this.cw = new ClassWriter(3);
                ClassReader cr = new ClassReader(classfileBuffer);
                cr.accept(new ProbeProviderClassVisitor((ClassVisitor)this.cw), null, 0);
                ret = this.cw.toByteArray();
                Log.fine("transformed", this.providerClassName);
                if (_debug) {
                    ProbeProviderClassFileTransformer.writeFile(className.substring(className.lastIndexOf(47) + 1) + "supplied_" + this.count, classfileBuffer);
                    ProbeProviderClassFileTransformer.writeFile(className.substring(className.lastIndexOf(47) + 1) + "transformed_" + this.count, ret);
                    ++this.count;
                }
            } else {
                if (_debug) {
                    ProbeProviderClassFileTransformer.writeFile(className.substring(className.lastIndexOf(47) + 1) + "supplied_" + this.count, classfileBuffer);
                    ++this.count;
                }
                ret = null;
                Log.fine("untransformed", providerClass.getName());
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "NCLS-MON-00508", ex);
        }
        return ret;
    }

    private synchronized void addTransformer() {
        if (!this.transformerAdded) {
            instrumentation.addTransformer(this, true);
            this.transformerAdded = true;
        }
    }

    private static String makeKey(String name, String desc) {
        return name + "::" + desc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void writeFile(String name, byte[] data) {
        FileOutputStream fos = null;
        try {
            File installRoot = new File(System.getProperty("com.sun.aas.installRoot"));
            File dir = new File(installRoot, "flashlight-generated");
            if (!dir.isDirectory() && !dir.mkdirs()) {
                throw new RuntimeException("Can't create directory: " + String.valueOf(dir));
            }
            fos = new FileOutputStream(new File(dir, name + ".class"));
            fos.write(data);
        }
        catch (Throwable th) {
            logger.log(Level.WARNING, "NCLS-MON-00509", th);
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception installRoot) {}
        }
    }

    private java.lang.reflect.Method getMethod(FlashlightProbe probe) throws NoSuchMethodException {
        java.lang.reflect.Method m = probe.getProbeMethod();
        if (m == null) {
            m = probe.getProviderClazz().getDeclaredMethod(probe.getProviderJavaMethodName(), probe.getParamTypes());
            probe.setProbeMethod(m);
        }
        return m;
    }

    static {
        _debug = Boolean.parseBoolean(Utility.getEnvOrProp("AS_DEBUG"));
        emittedAttachUnavailableMessageAlready = false;
        logger = FlashlightLoggerInfo.getLogger();
        Instrumentation nonFinalInstrumentation = null;
        Throwable throwable = null;
        Class<?> agentMainClass = null;
        boolean canAttach = false;
        if (AgentAttacher.canAttach()) {
            canAttach = true;
            try {
                ProbeProviderClassFileTransformer.class.getClassLoader();
                ClassLoader classLoader = ClassLoader.getSystemClassLoader();
                try {
                    agentMainClass = classLoader.loadClass(AGENT_CLASSNAME);
                }
                catch (Throwable t) {
                    AgentAttacher.attachAgent();
                    agentMainClass = classLoader.loadClass(AGENT_CLASSNAME);
                }
                java.lang.reflect.Method mthd = agentMainClass.getMethod("getInstrumentation", null);
                nonFinalInstrumentation = (Instrumentation)mthd.invoke(null, null);
            }
            catch (Throwable t) {
                nonFinalInstrumentation = null;
                throwable = t;
            }
        }
        instrumentation = nonFinalInstrumentation;
        if (!canAttach) {
            logger.log(Level.WARNING, "NCLS-MON-00510");
        } else if (instrumentation != null) {
            Log.info("yes.attach.api", instrumentation);
        } else {
            logger.log(Level.WARNING, "NCLS-MON-00511", throwable);
        }
    }

    private class ProbeProviderClassVisitor
    extends ClassVisitor {
        ProbeProviderClassVisitor(ClassVisitor cv) {
            super(589824, cv);
            if (Log.getLogger().isLoggable(Level.FINER)) {
                for (String methodDesc : ProbeProviderClassFileTransformer.this.probes.keySet()) {
                    Log.finer("visit" + methodDesc, new Object[0]);
                }
            }
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
            FlashlightProbe probe = ProbeProviderClassFileTransformer.this.probes.get(ProbeProviderClassFileTransformer.makeKey(name, desc));
            if (probe != null) {
                mv = new ProbeProviderMethodVisitor(mv, access, name, desc, probe);
            }
            return mv;
        }
    }

    private static class ProbeProviderMethodVisitor
    extends AdviceAdapter {
        private FlashlightProbe probe;
        private int stateLocal;
        private Label startFinally;

        ProbeProviderMethodVisitor(MethodVisitor mv, int access, String name, String desc, FlashlightProbe probe) {
            super(589824, mv, access, name, desc);
            this.probe = probe;
        }

        @Override
        public void visitMaxs(int maxStack, int maxLocals) {
            if (this.probe.getStateful()) {
                Label endFinally = new Label();
                this.mv.visitTryCatchBlock(this.startFinally, endFinally, endFinally, null);
                this.mv.visitLabel(endFinally);
                this.onFinally(191);
                this.mv.visitInsn(191);
            }
            this.mv.visitMaxs(maxStack, maxLocals);
        }

        @Override
        protected void onMethodEnter() {
            if (!this.probe.getStateful()) {
                this.insertCode();
                return;
            }
            this.stateLocal = this.newLocal(Type.getType(Object.class));
            this.visitInsn(1);
            this.storeLocal(this.stateLocal);
            this.startFinally = new Label();
            this.visitLabel(this.startFinally);
            this.push(this.probe.getId());
            this.loadArgArray();
            this.invokeStatic(Type.getType(ProbeRegistry.class), Method.getMethod("Object invokeProbeBefore(int, Object[])"));
            this.storeLocal(this.stateLocal);
        }

        @Override
        protected void onMethodExit(int opcode) {
            if (opcode != 191) {
                this.onFinally(opcode);
            }
        }

        private void onFinally(int opcode) {
            if (!this.probe.getStateful()) {
                return;
            }
            if (opcode == 191) {
                if (this.probe.getStatefulException()) {
                    this.dup();
                } else {
                    this.visitInsn(1);
                }
                this.push(this.probe.getId());
                this.loadLocal(this.stateLocal);
                this.invokeStatic(Type.getType(ProbeRegistry.class), Method.getMethod("void invokeProbeOnException(Object, int, Object)"));
            } else {
                if (this.probe.getStatefulReturn()) {
                    if (opcode == 177) {
                        this.visitInsn(1);
                    } else if (opcode == 176) {
                        this.dup();
                    } else {
                        if (opcode == 173 || opcode == 175) {
                            this.dup2();
                        } else {
                            this.dup();
                        }
                        this.box(Type.getReturnType(this.methodDesc));
                    }
                } else {
                    this.visitInsn(1);
                }
                this.push(this.probe.getId());
                this.loadLocal(this.stateLocal);
                this.invokeStatic(Type.getType(ProbeRegistry.class), Method.getMethod("void invokeProbeAfter(Object, int, Object)"));
            }
        }

        private void insertCode() {
            this.push(this.probe.getId());
            this.loadArgArray();
            this.invokeStatic(Type.getType(ProbeRegistry.class), Method.getMethod("void invokeProbe(int, Object[])"));
        }
    }
}

