/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.exousia.permissions;

import jakarta.security.jacc.EJBRoleRefPermission;
import jakarta.security.jacc.PolicyContextException;
import jakarta.security.jacc.WebRoleRefPermission;
import java.security.Permission;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import org.glassfish.exousia.constraints.transformer.ConstraintsToPermissionsTransformer;
import org.glassfish.exousia.mapping.SecurityRoleRef;
import org.glassfish.exousia.permissions.JakartaPermissions;

public class RolesToPermissionsTransformer {
    private static final System.Logger LOG = System.getLogger(RolesToPermissionsTransformer.class.getName());
    public static final String ANY_AUTHENTICATED_CALLER_ROLE = "**";
    private static final String CLASS_NAME = ConstraintsToPermissionsTransformer.class.getSimpleName();
    private static final BiFunction<String, String, Permission> CREATE_BEAN_REF = EJBRoleRefPermission::new;
    private static final BiFunction<String, String, Permission> CREATE_WEB_REF = WebRoleRefPermission::new;

    public static JakartaPermissions createWebRoleRefPermission(Set<String> declaredRoles, Map<String, List<SecurityRoleRef>> servletRoleMappings) throws PolicyContextException {
        LOG.log(System.Logger.Level.DEBUG, "The role-reference translation: Processing WebRoleRefPermission for roles {0}", declaredRoles);
        JakartaPermissions jakartaPermissions = new JakartaPermissions();
        ArrayList<String> servletScopedRoleNames = new ArrayList<String>();
        boolean rolesetContainsAnyAuthUserRole = declaredRoles.contains(ANY_AUTHENTICATED_CALLER_ROLE);
        for (Map.Entry<String, List<SecurityRoleRef>> servletEntry : servletRoleMappings.entrySet()) {
            RolesToPermissionsTransformer.addPermissionsForRoleRefRoles(CREATE_WEB_REF, servletEntry, servletScopedRoleNames, jakartaPermissions.getPerRole());
            LOG.log(System.Logger.Level.DEBUG, "role-reference translation: Going through the list of roles not present in RoleRef elements and creating WebRoleRefPermissions ");
            RolesToPermissionsTransformer.addPermissionsForNonRoleRefRoles(CREATE_WEB_REF, declaredRoles, servletScopedRoleNames, servletEntry.getKey(), jakartaPermissions.getPerRole());
            if (servletScopedRoleNames.contains(ANY_AUTHENTICATED_CALLER_ROLE) || rolesetContainsAnyAuthUserRole) continue;
            RolesToPermissionsTransformer.addAnyAuthenticatedUserRoleRef(CREATE_WEB_REF, jakartaPermissions.getPerRole(), servletEntry.getKey());
        }
        RolesToPermissionsTransformer.addGlobalPermissionsForAllRoles(declaredRoles, jakartaPermissions.getPerRole());
        if (!rolesetContainsAnyAuthUserRole) {
            RolesToPermissionsTransformer.addAnyAuthenticatedUserRoleRef(CREATE_WEB_REF, jakartaPermissions.getPerRole(), "");
        }
        return jakartaPermissions;
    }

    public static JakartaPermissions createEnterpriseBeansRoleRefPermission(Set<String> declaredRoles, Map<String, List<SecurityRoleRef>> beanRoleMappings) throws PolicyContextException {
        LOG.log(System.Logger.Level.DEBUG, "The role-reference translation: Processing EjbRoleRefPermission for roles {0}", declaredRoles);
        JakartaPermissions jakartaPermissions = new JakartaPermissions();
        ArrayList<String> beanScopedRoleNames = new ArrayList<String>();
        boolean rolesetContainsAnyAuthUserRole = declaredRoles.contains(ANY_AUTHENTICATED_CALLER_ROLE);
        for (Map.Entry<String, List<SecurityRoleRef>> beanEntry : beanRoleMappings.entrySet()) {
            RolesToPermissionsTransformer.addPermissionsForRoleRefRoles(CREATE_BEAN_REF, beanEntry, beanScopedRoleNames, jakartaPermissions.getPerRole());
            LOG.log(System.Logger.Level.DEBUG, "Going through the list of roles not present in RoleRef elements and creating EjbRoleRefPermissions.");
            RolesToPermissionsTransformer.addPermissionsForNonRoleRefRoles(CREATE_BEAN_REF, declaredRoles, beanScopedRoleNames, beanEntry.getKey(), jakartaPermissions.getPerRole());
            if (beanScopedRoleNames.contains(ANY_AUTHENTICATED_CALLER_ROLE) || rolesetContainsAnyAuthUserRole) continue;
            RolesToPermissionsTransformer.addAnyAuthenticatedUserRoleRef(CREATE_BEAN_REF, jakartaPermissions.getPerRole(), beanEntry.getKey());
        }
        return jakartaPermissions;
    }

    private static void addGlobalPermissionsForAllRoles(Collection<String> declaredRoles, Map<String, Permissions> roleMap) {
        for (String role : declaredRoles) {
            RolesToPermissionsTransformer.addToRoleMap(roleMap, role, new WebRoleRefPermission("", role));
            LOG.log(System.Logger.Level.DEBUG, "The role-reference translation: RoleRef {0} is added for jsp's that can't be mapped to servlets. Permission added for above role-ref = {0}", role);
        }
    }

    private static void addPermissionsForRoleRefRoles(BiFunction<String, String, Permission> createComponent, Map.Entry<String, List<SecurityRoleRef>> roleEntry, Collection<String> componentScopedRoleNames, Map<String, Permissions> roleMap) {
        for (SecurityRoleRef securityRoleRef : roleEntry.getValue()) {
            componentScopedRoleNames.add(securityRoleRef.getRoleName());
            String globalRole = securityRoleRef.getRoleLink();
            RolesToPermissionsTransformer.addToRoleMap(roleMap, globalRole, createComponent.apply(roleEntry.getKey(), securityRoleRef.getRoleName()));
            LOG.log(System.Logger.Level.DEBUG, "The role-reference translation: RoleRefPermission created with name = {0} and action = {1} added to role = {2}", roleEntry.getKey(), securityRoleRef.getRoleName(), globalRole);
        }
    }

    private static void addPermissionsForNonRoleRefRoles(BiFunction<String, String, Permission> createComponent, Collection<String> declaredRoles, Collection<String> roleRefRoles, String componentName, Map<String, Permissions> roleMap) {
        for (String role : declaredRoles) {
            LOG.log(System.Logger.Level.DEBUG, "The role-reference translation: Looking at Role = {0}", role);
            if (roleRefRoles.contains(role)) continue;
            RolesToPermissionsTransformer.addToRoleMap(roleMap, role, createComponent.apply(componentName, role));
            LOG.log(System.Logger.Level.DEBUG, "The role-reference translation: RoleRef = {0} is added for = {1}. Permission added for above role-ref = {1} {0}", role, componentName);
        }
    }

    private static void addAnyAuthenticatedUserRoleRef(BiFunction<String, String, Permission> createComponent, Map<String, Permissions> roleMap, String name) throws PolicyContextException {
        RolesToPermissionsTransformer.addToRoleMap(roleMap, ANY_AUTHENTICATED_CALLER_ROLE, createComponent.apply(name, ANY_AUTHENTICATED_CALLER_ROLE));
        LOG.log(System.Logger.Level.DEBUG, "Any authenticated user role-reference translation: Permission added for role-ref = {0} {1}", name, ANY_AUTHENTICATED_CALLER_ROLE);
    }

    private static void addToRoleMap(Map<String, Permissions> roleMap, String role, Permission permission) {
        roleMap.computeIfAbsent(role, e -> new Permissions()).add(permission);
    }
}

